<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Export Report', 'custom_css' => 'assets/css/export-report.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <?php if(!empty($error)): ?>
    <ul class="alert alert-warning">
        <li><?php echo e($error); ?></li>
    </ul>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Report</h1>
        </div>
        <div class="card-body">
            <div class="report-tab-wrapper" data-toggle-tab>
                <nav class="report-tab-nav">
                    <ul>
                        <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                        <li>
                            <button type="button" class="btn active" data-toggle-tab-btn="1">
                                Financial Year Wise
                            </button>
                        </li>
                        <input type="hidden" name="include-radio-button-js" value="yes">
                        <?php endif; ?>
                        <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin') || $user->hasRole('Department-User') || $user->hasRole('Department-Approver')): ?>
                        <li>
                            <button type="button" class="btn <?php if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD')): ?> active <?php endif; ?>" data-toggle-tab-btn="2">
                                <?php if($user->hasRole('Department-User') || $user->hasRole('Department-Approver')): ?>
                                Department Wise Report
                                <?php else: ?>
                                Department Wise
                                <?php endif; ?>
                            </button>
                        </li>
                        <?php endif; ?>
                        <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin') || $user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')): ?>
                        <li>
                            <button type="button" class="btn <?php if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')): ?> active <?php endif; ?>" data-toggle-tab-btn="3">
                                <?php if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')): ?>
                                District Wise Report
                                <?php else: ?>
                                District Wise
                                <?php endif; ?>
                            </button>
                        </li>
                        <?php endif; ?>
                    </ul>
                </nav>
                <div class="report-tab-body">
                    <div class="report-tab-item" data-toggle-tab-content="1">
                        <form id="form1" method="GET" action="<?php echo e(route('export_report.export_data')); ?>">
                            <!-- <?php echo csrf_field(); ?> -->
                            <div class="container-fluid">
                                <div class="row">
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="financial_year1" class="form-label">Financial Year <em>*</em></label>
                                            <select name="financial_year1[]" id="financial_year1" class="form-select" multiple data-rule-multiselectDropdown="true">
                                                <?php if(isset($financialYears) && !empty($financialYears)): ?>
                                                <option value="all" <?php echo e((request('financial_year1') && in_array('all', request('financial_year1'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $financialYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $financialYear): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($financialYear); ?>" <?php echo e((request('financial_year1') && in_array($financialYear, request('financial_year1'))) ? 'selected' : ''); ?>><?php echo e($financialYear); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['financial_year1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="goal1" class="form-label">Goal <em>*</em></label>
                                            <select name="goal1[]" id="goal1" class="form-select" multiple data-rule-multiselectDropdown="true">
                                                <?php if(isset($goals) && !empty($goals)): ?>
                                                <option value="all" <?php echo e((request('goal1') && in_array('all', request('goal1'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($goal['goal_id']); ?>" <?php echo e((request('goal1') && in_array($goal['goal_id'], request('goal1'))) ? 'selected' : ''); ?>><?php echo e($goal['goal_name']); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['goal1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                                    <div class="col-lg-3 col-md-6 <?php if(request('department1')): ?>d-none <?php endif; ?>" data-field="district-1">
                                        <div class="form-group cs-form-group">
                                            <label for="district1" class="form-label">District <em>*</em></label>
                                            <select name="district1[]" id="district1" class="form-select" multiple data-rule-multiselectDropdown="true">
                                                <?php if(isset($districts) && !empty($districts)): ?>
                                                <option value="all" <?php echo e((request('district1') && in_array('all', request('district1'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($district->id); ?>" <?php echo e((request('district1') && in_array($district->id, request('district1'))) ? 'selected' : ''); ?>><?php echo e($district->district_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['district1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <?php else: ?>
                                    <?php if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')): ?>
                                    <input type="hidden" name="district1" id="district1" value="<?php echo e($districts['id']); ?>">
                                    <?php $__errorArgs = ['district1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                                    <div class="col-lg-3 col-md-6 <?php if(!request('department1')): ?>d-none <?php endif; ?>" data-field="department-1">
                                        <div class="form-group cs-form-group">
                                            <label for="department1" class="form-label">Department <em>*</em></label>
                                            <select name="department1[]" id="department1" class="form-select" multiple data-rule-mandatory="true">
                                                <?php if(isset($departments) && !empty($departments)): ?>
                                                <option value="all">All</option>
                                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($department->id); ?>" <?php echo e((request('department1') && in_array($department->id, request('department1'))) ? 'selected' : ''); ?>><?php echo e($department->department_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['department1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <?php else: ?>
                                    <?php if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD')): ?>
                                    <input type="hidden" name="department1" id="department1" value="<?php echo e($departments['id']); ?>">
                                    <?php $__errorArgs = ['department1'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="w-100"></div>
                                    <div class="col-md-6">
                                        <div class="form-group cs-form-group mb-0 mt-4">
                                            <div class="form-check-wrapper">
                                                <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault1" id="flexRadioDefault1-1" <?php if(!request('department1') && empty(request('department1'))): ?>checked <?php endif; ?> data-radio="district-1" value="district" />
                                                    <label class="form-check-label" for="flexRadioDefault1-1">
                                                        By District <em>*</em>
                                                    </label>
                                                </div>
                                                <?php else: ?>
                                                <?php if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')): ?>
                                                <input type="hidden" name="flexRadioDefault1" id="flexRadioDefault1-1" value="district">
                                                <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" name="flexRadioDefault1" id="flexRadioDefault1-2" <?php if(request('department1') && !empty(request('department1'))): ?>checked <?php endif; ?> data-radio="department-1" value="department" />
                                                    <label class="form-check-label" for="flexRadioDefault1-2">
                                                        By Department <em>*</em>
                                                    </label>
                                                </div>
                                                <?php else: ?>
                                                <?php if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD')): ?>
                                                <input type="hidden" name="flexRadioDefault1" id="flexRadioDefault1-2" value="department">
                                                <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="base" value="financial-year-wise">
                                    <div class="col-md-6">
                                        <div class="mt-3 d-flex justify-content-end">
                                            <button type="submit" id="generate_report_button1" class="btn btn-primary">
                                                Generate Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <?php if(!empty($financial_year_wise_data) || count($financial_year_wise_data)>0): ?>
                        <?php if($financial_year_wise_data->total()>0): ?>
                        <div class="row mt-4">
                            <div class="col-12">
                                <div class="generated-report-wrapper">
                                    <div class="download-action-tray">
                                        <input type="hidden">
                                        <ul class="text-success download-message" style="display: none;">
                                            <li><b>The Download is in progress, this may take a minute, please wait...!</b></li>
                                        </ul>
                                        <button class="btn btn-danger" id="pdf_button_1">PDF</button>
                                        <button class="btn btn-success" id="excel_button_button_1">Excel</button>
                                    </div>

                                    <div class="table-responsive">
                                        <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                            <thead>
                                                <tr>
                                                    <th>Sr No.</th>
                                                    <th>Goal</th>
                                                    <th>Target</th>
                                                    <th>Indicator</th>
                                                    <th>Unit</th>
                                                    <th>Baseline Year</th>
                                                    <th>Baseline Value</th>
                                                    <th>Target 2030</th>
                                                    <?php if($indicator_type == 'district'): ?>
                                                    <th>District</th>
                                                    <?php else: ?>
                                                    <th>Department</th>
                                                    <?php endif; ?>
                                                    <th>Financial Year</th>
                                                    <th>Achieved Value</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $financial_year_wise_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e(($financial_year_wise_data->currentPage() - 1) * $financial_year_wise_data->perPage() + $loop->iteration); ?></td>
                                                    <td>
                                                        Goal <?php echo e($data->goal_id); ?>: <?php echo e($data->goal_name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->target_name); ?>

                                                    </td>

                                                    <td>
                                                        <?php echo e($data->indicator_name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->unit !="" ? $data->unit : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->baseline_year !="" ? $data->baseline_year : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->baseline_value !="" ? $data->baseline_value : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->target_value !="" ? $data->target_value : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php if($indicator_type == 'district'): ?>
                                                        <?php echo e($data->district_name != "" ? $data->district_name : 'N/A'); ?>

                                                        <?php else: ?>
                                                        <?php echo e($data->department_name != "" ? $data->department_name : 'N/A'); ?>

                                                        <?php endif; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo e($data->reporting_year != "" ? $data->reporting_year : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->achieved_value !="" ? $data->achieved_value : 'N/A'); ?>

                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <nav>
                            <ul class="pagination">
                                <?php echo e($financial_year_wise_data->appends(array_merge(request()->query()))->links('pagination.bootstrap-4')); ?>

                            </ul>
                        </nav>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="report-tab-item d-none" data-toggle-tab-content="2">
                        <form id="form2" method="GET" action="<?php echo e(route('export_report.export_data')); ?>">
                            <!-- <?php echo csrf_field(); ?> -->
                            <div class="container-fluid">
                                <div class="row">
                                    <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="department2" class="form-label">Department <em>*</em></label>
                                            <select name="department2" id="department2" class="form-select" data-rule-mandatory="true">
                                                <option value="">-- Select Department --</option>
                                                <?php if(isset($departments) && !empty($departments)): ?>
                                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($department->id); ?>" <?php echo e((request('department2') && request('department2')==$department->id) ? 'selected' : ''); ?>><?php echo e($department->department_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['department2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <?php else: ?>
                                    <?php if($user->hasRole('Department-User') || $user->hasRole('Department-Approver') || $user->hasRole('Department-HOD')): ?>
                                    <input type="hidden" name="department2" id="department2" value="<?php echo e($departments['id']); ?>">
                                    <?php $__errorArgs = ['department2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="goal2" class="form-label">Goal <em>*</em></label>
                                            <select name="goal2[]" id="goal2" class="form-select" multiple data-rule-mandatory="true">
                                                <?php if(isset($goals) && !empty($goals)): ?>
                                                <option value="all" <?php echo e((request('goal2') && in_array('all', request('goal2'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($goal['goal_id']); ?>" <?php echo e((request('goal2') && in_array($goal['goal_id'], request('goal2'))) ? 'selected' : ''); ?>><?php echo e($goal['goal_name']); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['goal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="financial_year2" class="form-label">Financial Year <em>*</em></label>
                                            <select name="financial_year2[]" id="financial_year2" class="form-select" multiple data-rule-mandatory="true">
                                                <?php if(isset($financialYears) && !empty($financialYears)): ?>
                                                <option value="all" <?php echo e((request('financial_year2') && in_array('all', request('financial_year2'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $financialYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $financialYear): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($financialYear); ?>" <?php echo e((request('financial_year2') && in_array($financialYear, request('financial_year2'))) ? 'selected' : ''); ?>><?php echo e($financialYear); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['financial_year'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <input type="hidden" name="base" value="department-wise">
                                    <div class="w-100"></div>
                                    <div class="col-12">
                                        <div class="mt-3 d-flex justify-content-end">
                                            <button type="submit" class="btn btn-primary" id="generate_report_button2">
                                                Generate Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <?php if(!empty($department_wise_data) || count($department_wise_data)>0): ?>
                        <?php if($department_wise_data->total()>0): ?>
                        <div class="row mt-4" data-report-wrapper="2">
                            <div class="col-12">
                                <div class="generated-report-wrapper">
                                    <div class="download-action-tray">
                                        <button class="btn btn-danger" id="pdf_button_2">PDF</button>
                                        <button class="btn btn-success" id="excel_button_button_2">Excel</button>
                                    </div>
                                    <ul class="text-success download-message" style="display: none;">
                                        <li><b>The Download is in progress, this may take a minute, please wait...!</b></li>
                                    </ul>
                                    <div class="table-responsive">
                                        <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                            <thead>
                                                <tr>
                                                    <th>Sr No.</th>
                                                    <th>Goal</th>
                                                    <th>Target</th>
                                                    <th>Indicator</th>
                                                    <th>Unit</th>
                                                    <th>Baseline Year</th>
                                                    <th>Baseline Value</th>
                                                    <th>Target 2030</th>
                                                    <th>Department</th>
                                                    <th>Financial Year</th>
                                                    <th>Achieved Value</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $department_wise_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e(($department_wise_data->currentPage() - 1) * $department_wise_data->perPage() + $loop->iteration); ?></td>
                                                    <td>
                                                        Goal <?php echo e($data->goal_id); ?>: <?php echo e($data->goal_name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->target_name); ?>

                                                    </td>

                                                    <td>
                                                        <?php echo e($data->indicator_name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->unit !="" ? $data->unit : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->baseline_year !="" ? $data->baseline_year : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->baseline_value !="" ? $data->baseline_value : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->target_value !="" ? $data->target_value : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->department_name != "" ? $data->department_name : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->reporting_year !="" ? $data->reporting_year : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->achieved_value !="" ? $data->achieved_value : 'N/A'); ?>

                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <nav>
                                <ul class="pagination">
                                    <?php echo e($department_wise_data->appends(array_merge(request()->query()))->links('pagination.bootstrap-4')); ?>

                                </ul>
                            </nav>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                    <div class="report-tab-item d-none" data-toggle-tab-content="3">
                        <form id="form3" method="GET" action="<?php echo e(route('export_report.export_data')); ?>">
                            <!-- <?php echo csrf_field(); ?> -->
                            <div class="container-fluid">
                                <div class="row">
                                    <?php if($user->hasRole('Admin') || $user->hasRole('Super Admin')): ?>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="district3" class="form-label">District<em>*</em></label>
                                            <select name="district3" id="district3" class="form-select" data-rule-mandatory="true">
                                                <option value="">--Select District--</option>
                                                <?php if(isset($districts) && !empty($districts)): ?>
                                                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($district->id); ?>" <?php echo e((request('district3') && request('district3')==$district->id) ? 'selected' : ''); ?>><?php echo e($district->district_name); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['district3'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <?php else: ?>
                                    <?php if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD')): ?>
                                    <input type="hidden" name="district3" id="district3" value="<?php echo e($districts['id']); ?>">
                                    <?php $__errorArgs = ['district3'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="goal3" class="form-label">Goal <em>*</em></label>
                                            <select name="goal3[]" id="goal3" class="form-select" data-rule-mandatory="true" multiple>
                                                <?php if(isset($goals) && !empty($goals)): ?>
                                                <option value="all" <?php echo e((request('goal3') && in_array('all', request('goal3'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($goal['goal_id']); ?>" <?php echo e((request('goal3') && in_array($goal['goal_id'], request('goal3'))) ? 'selected' : ''); ?>><?php echo e($goal['goal_name']); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['goal3'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-lg-3 col-md-6">
                                        <div class="form-group cs-form-group">
                                            <label for="financial_year3" class="form-label">Financial Year <em>*</em></label>
                                            <select name="financial_year3[]" id="financial_year3" class="form-select" multiple data-rule-mandatory="true">
                                                <?php if(isset($financialYears) && !empty($financialYears)): ?>
                                                <option value="all" <?php echo e((request('financial_year3') && in_array('all', request('financial_year3'))) ? 'selected' : ''); ?>>All</option>
                                                <?php $__currentLoopData = $financialYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $financialYear): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($financialYear); ?>" <?php echo e((request('financial_year3') && in_array($financialYear, request('financial_year3'))) ? 'selected' : ''); ?>><?php echo e($financialYear); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php $__errorArgs = ['financial_year3'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <input type="hidden" name="base" value="district-wise">
                                    <div class="col-12">
                                        <div class="mt-3 d-flex justify-content-end">
                                            <button type="submit" id="generate_report_button3" class="btn btn-primary">
                                                Generate Report
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <?php if(!empty($district_wise_data) || count($district_wise_data)>0): ?>
                        <?php if($district_wise_data->total()>0): ?>
                        <div class="row mt-4" data-report-wrapper="3">
                            <div class="col-12">
                                <div class="generated-report-wrapper">
                                    <div class="download-action-tray">
                                        <button class="btn btn-danger" id="pdf_button_3">PDF</button>
                                        <button class="btn btn-success" id="excel_button_button_3">Excel</button>
                                    </div>
                                    <div class="table-responsive">
                                        <ul class="text-success download-message" style="display: none;">
                                            <li><b>The Download is in progress, this may take a minute, please wait...!</b></li>
                                        </ul>
                                        <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                                            <thead>
                                                <tr>
                                                    <th>Sr No.</th>
                                                    <th>Goal</th>
                                                    <th>Target</th>
                                                    <th>Indicator</th>
                                                    <th>Unit</th>
                                                    <th>Baseline Year</th>
                                                    <th>Baseline Value</th>
                                                    <th>Target 2030</th>
                                                    <th>District</th>
                                                    <th>Financial Year</th>
                                                    <th>Achieved Value</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $district_wise_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e(($district_wise_data->currentPage() - 1) * $district_wise_data->perPage() + $loop->iteration); ?></td>
                                                    <td>
                                                        Goal <?php echo e($data->goal_id); ?>: <?php echo e($data->goal_name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->target_name); ?>

                                                    </td>

                                                    <td>
                                                        <?php echo e($data->indicator_name); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->unit !="" ? $data->unit : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->baseline_year !="" ? $data->baseline_year : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->baseline_value !="" ? $data->baseline_value : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->target_value !="" ? $data->target_value : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->district_name != "" ? $data->district_name : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->reporting_year != "" ? $data->reporting_year : 'N/A'); ?>

                                                    </td>
                                                    <td>
                                                        <?php echo e($data->achieved_value !="" ? $data->achieved_value : 'N/A'); ?>

                                                    </td>
                                                </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <nav>
                                <ul class="pagination">
                                    <?php echo e($district_wise_data->appends(array_merge(request()->query()))->links('pagination.bootstrap-4')); ?>

                                </ul>
                            </nav>
                        </div>
                        <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.validate.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/validation.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
<script src="<?php echo e(asset('assets/js/plugins/select2.js')); ?>"></script>
<!-- Export Report Script -->
<script src="<?php echo e(asset('assets/js/export-report.js')); ?>"></script>
<script>
    $(document).ready(function() {

        // Get the current URL and its parameters
        var url = new URL(window.location.href);

        // Remove the 'export' parameter
        url.searchParams.delete('export');

        // Update the browser's URL without reloading the page
        window.history.replaceState({}, '', url.toString());

        <?php if (request('base') == 'financial-year-wise') { ?>
            $('[data-toggle-tab-btn="1"]').trigger('click');
        <?php } else if (request('base') == 'department-wise') { ?>
            $('[data-toggle-tab-btn="2"]').trigger('click');
        <?php } else if (request('base') == 'district-wise') { ?>
            $('[data-toggle-tab-btn="3"]').trigger('click');
        <?php }
        if (request('flexRadioDefault1') == 'district') { ?>
            $('#flexRadioDefault1-1').trigger('click');
        <?php } else if (request('flexRadioDefault1') == 'department') { ?>
            $('#flexRadioDefault1-2').trigger('click');
        <?php } ?>

        //#region Export Report in excel
        $('#excel_button_button_1').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form1').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form1 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'excel';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '<?php echo e(route("export_report.export_data")); ?>', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download File button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-primary ms-2">Download file</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#excel_button_button_2').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form2').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form2 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'excel';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '<?php echo e(route("export_report.export_data")); ?>', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download File button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-primary ms-2">Download file</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#excel_button_button_3').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form3').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form3 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'excel';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '<?php echo e(route("export_report.export_data")); ?>', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download File button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-primary ms-2">Download file</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });
        //#endregion

        //#region PDF Button Click Event
        $('#pdf_button_1').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form1').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form1 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'pdf';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '<?php echo e(route("export_report.export_data")); ?>', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-success ms-2" target="blank" >Open PDF</a><a href="' + response.filepath + '" class="btn btn-primary ms-2" download>Download PDF</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#pdf_button_2').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form2').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form2 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'pdf';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '<?php echo e(route("export_report.export_data")); ?>', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-success ms-2" target="blank" >Open PDF</a><a href="' + response.filepath + '" class="btn btn-primary ms-2" download>Download PDF</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });

        $('#pdf_button_3').click(function(e) {
            e.preventDefault();

            // Create an object to hold the data to send with the request
            var dataToSend = {};

            // Get the form data
            var formData = $('#form3').serializeArray();

            // Add the form data to the dataToSend object
            $.each(formData, function(i, field) {
                if (dataToSend[field.name]) {
                    if (!Array.isArray(dataToSend[field.name])) {
                        dataToSend[field.name] = [dataToSend[field.name]];
                    }
                    dataToSend[field.name].push(field.value);
                } else {
                    dataToSend[field.name] = field.value;
                }
            });

            // Handle multiple selected options
            $('#form3 select[multiple]').each(function() {
                var selectName = $(this).attr('name');
                dataToSend[selectName] = $(this).val();
            });

            // Add any additional data
            dataToSend['export'] = 'pdf';

            // Show the alert before sending the request
            $('.download-message').find('li').text('');
            $('.download-message').removeClass('text-danger').addClass('text-success').show().find('li').text('The Download is in progress, this may take a minute, please wait...');

            $.ajax({
                url: '<?php echo e(route("export_report.export_data")); ?>', // Update with your route
                type: 'GET',
                data: dataToSend,
                success: function(response) {
                    // Handle the success response
                    if (response.status === 'success') {
                        // Add a download button with the file path
                        $('.download-message').find('li').text('');
                        $('.download-message').find('li').text('Click on Download button to download the file.').append('<a href="' + response.filepath + '" class="btn btn-success ms-2" target="blank" >Open PDF</a><a href="' + response.filepath + '" class="btn btn-primary ms-2" download>Download PDF</a>');
                    } else {
                        // Show the error message
                        $('.download-message').find('li').text('');
                        $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text(response.message);
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    // Handle any errors
                    $('.download-message').find('li').text('');
                    $('.download-message').removeClass('text-success').addClass('text-danger').find('li').text('An error occurred while processing the request.');
                }
            });
        });
        //#endregion

        //#region form submission on generate button
        $("#form1").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                form.submit();
            }
        });
        $("#form2").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                form.submit();
            }
        });
        $("#form3").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                form.submit();
            }
        });
        //#endregion
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/export-report/index.blade.php ENDPATH**/ ?>