<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Indicator Listing', 'custom_css' => 'assets/css/indicator.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    <?php echo $__env->make('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter','defalut_goal_id'=>$default_goal], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="page-content">
        <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>
        <?php if(session('error')): ?>
        <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
        <?php endif; ?>
        <div class="card">
            <div class="card-header cs-card-header">
                <h1 class="page-title">Indicators</h1>
                <div class="card-header-action">
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Export Indicator')): ?>
                    <a href="<?php echo e(route('indicators.export',['goal' => request('goal'), 'target' => request('target'),'type'=> request('type')])); ?>" class="btn btn-success btn-sm">
                        Export
                    </a>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Indicator')): ?>
                    <a href="<?php echo e(url('indicators/create')); ?>" class="btn btn-primary btn-sm me-4">
                        Add New Indicator
                    </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <div class="graph-filters-strip">
                    <form action="<?php echo e(route('indicators.filter')); ?>" method="GET" style="width: 100%;">
                        <?php if(request('goal')): ?>
                        <input type="hidden" name="goal" value="<?php echo e(request('goal')); ?>">
                        <?php endif; ?>
                        <div class="filters-area">
                            <div class="form-group cs-form-group mr-5">
                                <label for="target" class="form-label">Target</label>
                                <select name="target" id="target" class="form-select form-select-sm">
                                    <option value="">-- Select Target --</option>
                                    <?php $__currentLoopData = $targets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $target): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($target->target_id); ?>" <?php echo e(request('target') == $target->target_id ? 'selected' : ''); ?>><?php echo e($target->target_number.': '.$target->target_name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="form-group cs-form-group">
                                <label for="type" class="form-label">Indicator Type</label>
                                <select name="type" id="type" class="form-select form-select-sm" data-field="indicator-type">
                                    <option value="">-- Select Indicator Type --</option>
                                    <option value="utif" <?php if(request('type')=='utif' || $type=='utif' ): ?> selected <?php endif; ?>>UTIF</option>
                                    <option value="dif" <?php if(request('type')=='dif' || $type=='dif' ): ?> selected <?php endif; ?>>DIF</option>
                                </select>
                            </div>
                            <div class="form-group cs-form-group form-group-btn">
                                <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">Submit</button>
                                <a href="<?php echo e(url('indicators')); ?>" class="btn btn-danger btn-sm ms-2 pt-2 pb-2 ps-3 pe-3">Clear Filter</a>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="table-responsive">
                    <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                        <thead>
                            <tr>
                                <th>Sr. No.</th>
                                <th>Indicator Name</th>
                                <th>Goal</th>
                                <th>Target</th>
                                <th>Baseline Year</th>
                                <th>Unit</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(isset($indicators) && count($indicators) > 0): ?>
                            <?php $__currentLoopData = $indicators; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $indicator): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(($indicators->currentPage() - 1) * $indicators->perPage() + $loop->iteration); ?></td>
                                <td><?php echo e($indicator->indicator_number); ?>: <?php echo e($indicator->indicator_name); ?></td>
                                <td><?php echo e($indicator->goal_name); ?></td>
                                <td><?php echo e($indicator->target_name); ?></td>
                                <td><?php echo e($indicator->baseline_year); ?></td>
                                <td><?php echo e($indicator->unit); ?></td>
                                <td>
                                    <?php if(strtolower($indicator->is_discontinue) == 'no'): ?>
                                    <span class="text-success">Active</span>
                                    <?php else: ?>
                                    <span class="text-danger">Discontinued</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="cs-icons-wrapper">
                                        <?php if($indicator->is_editable == 'yes'): ?>
                                        <a href="<?php echo e(url('indicators/'.$indicator->indicator_id.'/edit')); ?>" class="cs-icon-edit" data-icon-toggle-title="Edit">
                                            <i class="bi bi-pencil-square"></i>
                                        </a>
                                        <?php endif; ?>
                                        <?php if(strtolower($indicator->is_discontinue) == 'no'): ?>
                                        <a href="javascript:void(0);" class="cs-icon-delete ms-1" data-icon-toggle-title="Discontinue" onclick="confirmAction('<?php echo e($indicator->indicator_id); ?>','yes')">
                                            <i class="bi bi-x-lg"></i>
                                        </a>
                                        <?php else: ?>
                                        <a href="javascript:void(0);" class="cs-icon-save" data-icon-toggle-title="Activate" onclick="confirmAction('<?php echo e($indicator->indicator_id); ?>','no')">
                                            <i class=" bi bi-check-lg"></i>
                                        </a>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php else: ?>
                            <tr>
                                <td colspan="10">
                                    <?php if(request('goal') == 14): ?>
                                    Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                                    <?php else: ?>
                                    <?php if(request('goal') == 17): ?>
                                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                                    <?php else: ?>
                                    No record found
                                    <?php endif; ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination">
                        <?php echo e($indicators->appends(request()->query())->links('pagination.bootstrap-4')); ?>

                    </ul>
                </nav>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>

<script src="<?php echo e(asset('assets/js/indicator.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/select2.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/sweetAlert.js')); ?>"></script>
<script>
    $(document).ready(function() {
        $('#target').select2({
            tags: true,
            tokenSeparators: [',', ' ']
        });
        $('#type').select2({
            tags: true,
            tokenSeparators: [',', ' ']
        });
    });
    //#region
    /**
     * Below code handle the height of the SDG goals vertical scrollbar
     * it helps in making the sidebar goals scroll sticky
     */
    window.addEventListener("scroll", () => {
        let drawer = document.querySelector(".goals-drawer");
        let drawerContent = document.querySelector(`.goals-drawer-content`);
        let footer = document.querySelector(".cs-footer");
        let footerTop = footer.getBoundingClientRect().top;
        let drawerBottom = drawer.getBoundingClientRect().bottom;

        if (footerTop < drawerBottom) {
            let diff = 120 + (drawerBottom - footerTop);
            drawerContent.style.height = `calc(100vh - ${diff}px)`;
        } else {
            drawerContent.style.height = `calc(100vh - 120px)`;
        }
    });
    //#endregion
    function confirmAction(indicatorId, action) {
        var url = 'indicators/' + indicatorId + '/' + action + '/delete';
        if (action != '') {
            if (action == 'yes') {
                var message = 'Are you sure to discontinue this indicator?';
                var prompt = 'This indicator consists of values in it';
            } else {
                var prompt = 'Are you sure to activate this indicator?';
                var message = '';
            }
        } else {
            Swal('Error', 'Action not found', 'error');
        }
        Swal.fire({
            title: prompt,
            text: message,
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, do it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        })
    }
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/indicator/index.blade.php ENDPATH**/ ?>