<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Target', 'custom_css' => 'assets/css/add-indicator.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <?php if(session('status')): ?>
    <div class="alert alert-success"><?php echo e(session('status')); ?></div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Target</h1>
        </div>
        <div class="card-body">
            <form id="create_target" method="POST" action="<?php if(!empty($target->target_id)): ?> <?php echo e(url('targets/'.$target->target_id)); ?> <?php else: ?> <?php echo e(url('targets')); ?> <?php endif; ?>">
                <?php echo csrf_field(); ?>
                <?php if(!empty($target->target_id)): ?>
                <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="goal">Select Goal <em>*</em></label>
                                <select name="goal" id="goal" class="form-select" data-rule-required="true">
                                    <option value="">-- Select Goal --</option>
                                    <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($goal['goal_id']); ?>" <?php if(!empty($target) && $target->goal_id == $goal['goal_id']): ?> Selected <?php else: ?> <?php echo e(old('goal')==$goal['goal_id']?'selected':''); ?> <?php endif; ?>> <?php echo e($goal['goal_id']); ?>. <?php echo e($goal['goal_name']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['goal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="w-100"></div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-id">Target Id/Number <em>*</em></label>
                                <input type="text" class="form-control" id="target-number" name="target_number" value="<?php if(!empty($target) && !empty($target->target_number)): ?><?php echo e($target->target_number); ?><?php else: ?><?php echo e(old('target_number')); ?><?php endif; ?>" placeholder="Enter Target Id/Number" data-rule-required="true" />
                            </div>
                            <?php $__errorArgs = ['target_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-name">Target Name <em>*</em></label>
                                <input type="text" class="form-control" id="target-name" name="target_name" value="<?php if(!empty($target) && !empty($target->target_name)): ?><?php echo e($target->target_name); ?><?php else: ?><?php echo e(old('target_name')); ?><?php endif; ?>" placeholder="Enter Target Name" data-rule-required="true" />
                            </div>
                            <?php $__errorArgs = ['target_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.validate.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/validation.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
<script>
    $(document).ready(function() {
        $("#create_target").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/target/create.blade.php ENDPATH**/ ?>