<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.public_page_head', ['title'=> 'SDG J&K - Dashboard','custom_css' => 'assets/css/sdg-index.css'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.public_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.public_page_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('public_content'); ?>
    <div class="heading-area">
        <h1>Performance of J&K on SDG India Index</h1>
    </div>

    <!-- Stats Section -->
    <section class="stats-section">
        <div class="stats-area">
            
        </div>
    </section>
    <!-- /Stats Section -->

    <!-- Year Wise Table -->
    <section class="year-wise-table-section">
        <div class="year-wise-table-area">
            <div class="table-responsive">
                <table class="table cs-table cs-table-sticky-header table-sm mb-0" role="grid">
                    <colgroup>
                        <col style="min-width: 100px" />
                        <col style="min-width: 80px" />
                        <col style="min-width: 100px" />
                        <col style="min-width: 150px" />
                        <col style="min-width: 150px" />
                        <col style="min-width: 130px" />
                        <col style="min-width: 140px" />
                    </colgroup>
                    <thead>
                        <tr style="vertical-align: middle;">
                            <th>Years</th>
                            <th>India Score</th>
                            <th>J&K Score</th>
                            <th>Best Performing<br>States</th>
                            <th>Best Performing<br>State Scores</th>
                            <th>Best Performing<br>UT</th>
                            <th>Best Performing<br>UT Scores</th>
                        </tr>
                    </thead>
                    <tbody>
                        
                    </tbody>
                </table>
            </div>
        </div>
    </section>
    <!-- /Year Wise Table -->

    <!-- Goal Table -->
    <section class="goals-table-section">
        <small class="table-footer-text">
            <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M6 0C2.688 0 0 2.688 0 6C0 9.312 2.688 12 6 12C9.312 12 12 9.312 12 6C12 2.688 9.312 0 6 0ZM6.6 9H5.4V5.4H6.6V9ZM6.6 4.2H5.4V3H6.6V4.2Z"
                    fill="#00437C" />
            </svg>
            Goal-wise data is displaying for the latest year.
        </small>
        <div class="goals-table-area">
            <div class="table-responsive" style="max-height: unset !important;">
                <table class="table cs-table-2 cs-table-sticky-header table-striped" role="grid">
                    <colgroup>
                        <col />
                        <col style="min-width: 140px" />
                        <col style="min-width: 110px" />
                        <col style="min-width: 100px" />
                        <col style="min-width: 200px" />
                        <col style="min-width: 160px" />
                        <col style="min-width: 150px" />
                        <col style="min-width: 150px" />
                    </colgroup>
                    <thead>
                        <tr style="vertical-align: middle;">
                            <th></th>
                            <th>Goal</th>
                            <th>India Score</th>
                            <th>J&K Score</th>
                            <th>Best Performing<br>States</th>
                            <th>Best Performing<br>State Scores</th>
                            <th>Best Performing<br>UT</th>
                            <th>Best Performing<br>UT Scores</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            
                        </tr>
                    </tbody>
                </table>
            </div>
            <small class="table-footer-text">
                <svg width="12" height="12" viewBox="0 0 12 12" fill="none"
                    xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M6 0C2.688 0 0 2.688 0 6C0 9.312 2.688 12 6 12C9.312 12 12 9.312 12 6C12 2.688 9.312 0 6 0ZM6.6 9H5.4V5.4H6.6V9ZM6.6 4.2H5.4V3H6.6V4.2Z"
                        fill="#00437C" />
                </svg>
                Goal-wise data is displaying for the latest year.
            </small>
        </div>
        <div class="modal fade" id="excelModal" tabindex="-1" aria-labelledby="excelModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable modal-fullscreen">
          <div class="modal-content">
            <div class="modal-header">
              <h1 class="modal-title fs-5" id="excelModalLabel">Overall Comparison - 2023-2024</h1>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div id="excelContent" class="overflow-auto"></div>
            </div>
            <div class="modal-footer">
              <button type="button" class="btn btn-secondary btn-sm" data-bs-dismiss="modal">Close</button>
            </div>
          </div>
        </div>
    </div>
    </section>
    <?php echo $__env->make('layouts.other.indicator_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
<script src="<?php echo e(asset('assets/js/dashboard.js')); ?>" defer></script>

<script src="<?php echo e(asset('assets/js/map/highmap.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/highcharts-more.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/map/module/exporting.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/map/module/offline_exporting.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/map/module/data.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/map/module/accessibility.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.1/xlsx.full.min.js"></script>
    <script>
        //this function is used to fetch the data.
        function fetchComparisonData(GoalId) {

            $.ajax({
                url: "<?php echo e(route('public_page_comparison_data')); ?>",
                type: 'GET',
                data: {
                    goal_id: GoalId
                },
                success: function(response) {
                    
                    if (response && response.data.length > 0) {
                        var statsData = response.data;
                        updateComparisonStats(statsData); // Update the comparison stats
                        updateTable(statsData); // Call the function to update the table
                        populateTable(response);
                    } else {
                        console.log("No data available.");
                        resetComparisonStats(); // Reset the comparison stats
                        resetTable(); // Reset the table
                        resetGoalTable(); // Reset the goal table
                    }
                },
                error: function(error) {
                    console.error("Error fetching data:", error);
                    resetComparisonStats(); // Reset the comparison stats
                    resetTable(); // Reset the table
                    resetGoalTable(); // Reset the goal table
                },
                complete: function() {
                    // Hide the loader
                    $('.loader').fadeOut('slow');
                }
            });
        }


        // Update the table with the response data
        function updateTable(data) {
            // Get the table body
            const tableBody = document.querySelector(".cs-table tbody");

            // Clear the existing rows
            tableBody.innerHTML = '';

            // Iterate through the response data and populate rows
            data.slice(0, 4).forEach((row, index) => {

                const nextYearData = index < data.length - 1 ? data[index + 1] : null;

                // Determine India score arrow
                let indiaArrow = "arrow-straight.svg"; // Default arrow for no change
                if (nextYearData) {
                    if (row.india_score > nextYearData.india_score) {
                        indiaArrow = "arrow-up.svg";
                    } else if (row.india_score < nextYearData.india_score) {
                        indiaArrow = "arrow-down.svg";
                    }
                }

                // Determine J&K score arrow
                let jkArrow = "arrow-straight.svg"; // Default arrow for no change
                if (nextYearData) {
                    if (row.jammu_and_kashmir_score > nextYearData.jammu_and_kashmir_score) {
                        jkArrow = "arrow-up.svg";
                    } else if (row.jammu_and_kashmir_score < nextYearData.jammu_and_kashmir_score) {
                        jkArrow = "arrow-down.svg";
                    }
                }

                // Create a new row
                const newRow = document.createElement("tr");

                // Populate the row with data
                newRow.innerHTML = `
                 <td>
                     <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#excelModal" data-year="${row.financial_year}">
                         ${row.financial_year}
                     </a>
                 </td>
                 <td>${(row.india_score !== 0 && row.india_score !== null && row.india_score !== '') ? row.india_score : 'N/A'} ${data.length - index === 1 ? '' : `<img src="<?php echo e(asset('assets/images/${indiaArrow}')); ?>">`}</td>
                <td>${(row.jammu_and_kashmir_score !== null && row.jammu_and_kashmir_score !== 0 && row.jammu_and_kashmir_score !== '') ? row.jammu_and_kashmir_score : 'N/A'} ${data.length - index === 1 ? '' : `<img src="<?php echo e(asset('assets/images/${jkArrow}')); ?>">`}</td>
                <td>${(row.best_performer_state !== null && row.best_performer_state !== 0 && row.best_performer_state !== '') ? row.best_performer_state : 'N/A' }</td>
                <td style="padding-left:40px">${(row.best_performer_state_score !== 0 && row.best_performer_state_score !== null && row.best_performer_state_score !== '' ) ? row.best_performer_state_score : 'N/A'}</td>
                <td>${(row.best_performer_ut !== null && row.best_performer_ut !== 0 && row.best_performer_ut !== '') ? row.best_performer_ut : 'N/A' }</td>
                <td style="padding-left:40px">${(row.best_performer_ut_score !== 0 && row.best_performer_ut_score !== null && row.best_performer_ut_score !== '') ? row.best_performer_ut_score : 'N/A' }</td>

                 
             `;

                // Append the new row to the table body
                tableBody.appendChild(newRow);
            });
        }

        // Reset the table with default data
        function resetTable() {
            const tableBody = $(".cs-table tbody");
            tableBody.html(`
             <tr>
                 <td colspan="7" class="text-center">No Data Available</td>
             </tr>
         `);
        }

        function resetGoalTable() {
            const tableBody = document.querySelector('table.cs-table-2 tbody');
            tableBody.innerHTML = `
                <tr>
                    <td colspan="8" class="text-center">No Data Available</td>
                </tr>
            `;
        }

        // Reset the comparison stats with default data
        function resetComparisonStats() {
            const statsWrapper = document.querySelector(".stats-area");
            statsWrapper.innerHTML = `
                <div class="stats-grid">
                    <div class="stats-grid-item">
                        <div class="stats-card">
                            <div class="stats-card-body">
                                <div class="stats-left">
                                    <p class="stats-title">
                                        <img src="https://upload.wikimedia.org/wikipedia/commons/b/bb/Sdg_icon_wheel_rgb-290x290.png"
                                            width="40px" alt="SDG Wheel Icon" />
                                        India
                                    </p>
                                </div>
                                <div class="stats-right">
                                    <div class="stats-value">0</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="stats-grid-item">
                        <div class="stats-card">
                            <div class="stats-card-body">
                                <div class="stats-left">
                                    <p class="stats-title">J&K</p>
                                </div>
                                <div class="stats-right">
                                    <div class="stats-value">0</div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="stats-grid-item">
                        <div class="stats-card">
                            <div class="stats-card-body">
                                <div class="stats-left">
                                    <p class="stats-title">N/A</p>
                                </div>
                                <div class="stats-right">
                                    <div class="stats-value">0</div>
                                    <small class="stats-sub">Best Performing State</small>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="stats-grid-item">
                        <div class="stats-card">
                            <div class="stats-card-body">
                                <div class="stats-left">
                                    <p class="stats-title">N/A</p>
                                </div>
                                <div class="stats-right">
                                    <div class="stats-value">0</div>
                                    <small class="stats-sub">Best Performing UT</small>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            `;
        }

        // Update the comparison stats with the response data
        function updateComparisonStats(data) {
            // Get the latest year's data (assuming the data is sorted by year descending)
            const latestData = data[0]; // The first element contains the latest year data

            // Update the comparison stats
            const statsWrapper = document.querySelector(".stats-area");
            statsWrapper.innerHTML = `
             <div class="stats-grid">
                 <div class="stats-grid-item">
                    <div class="stats-card">
                        <div class="stats-card-body">
                            <div class="stats-left">
                                <p class="stats-title">
                                    <img src="https://upload.wikimedia.org/wikipedia/commons/b/bb/Sdg_icon_wheel_rgb-290x290.png"
                                        width="40px" alt="SDG Wheel Icon" />
                                    India
                                </p>
                            </div>
                            <div class="stats-right">
                                <div class="stats-value">${latestData.india_score}</div>
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="stats-grid-item">
                    <div class="stats-card">
                        <div class="stats-card-body">
                            <div class="stats-left">
                                <p class="stats-title">J&K</p>
                            </div>
                            <div class="stats-right">
                                <div class="stats-value">${latestData.jammu_and_kashmir_score}</div>
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="stats-grid-item">
                    <div class="stats-card">
                        <div class="stats-card-body">
                            <div class="stats-left">
                                <p class="stats-title">${latestData.best_performer_state || ""}</p>
                            </div>
                            <div class="stats-right">
                                <div class="stats-value">${(latestData.best_performer_state_score !== 0 && latestData.best_performer_state_score !== null) ? latestData.best_performer_state_score : 'N/A'}</div>
                                <small class="stats-sub">Best Performing State</small>
                            </div>
                        </div>
                    </div>
                </div>
                 <div class="stats-grid-item">
                    <div class="stats-card">
                        <div class="stats-card-body">
                            <div class="stats-left">
                                <p class="stats-title">${latestData.best_performer_ut || "N/A"}</p>
                            </div>
                            <div class="stats-right">
                                <div class="stats-value">${latestData.best_performer_ut_score}</div>
                                <small class="stats-sub">Best Performing UT</small>
                            </div>
                        </div>
                    </div>
                </div>
             </div>
         `;
        }

        function populateTable(response) {
            const tableBody = document.querySelector('table.cs-table-2 tbody');
            const tableData = response.tabledata;

            // Clear existing table rows
            tableBody.innerHTML = '';

            // Loop through the table data
            tableData.forEach(item => {
                const row = document.createElement('tr');

                // Generate HTML for the row
                row.innerHTML = `
                    <td>
                        <img src="<?php echo e(asset('assets/images/goals/100 x 100/goal_${item.goal_id}.png')); ?>" alt="" class="goal-table-image" />
                    </td>
                    <td>${item.goal_name}</td>
                    <td>
                        ${item.india_score}
                        <img src="<?php echo e(asset('assets/images/arrow-${item.india_score_trend}.svg')); ?>" alt="" />
                    </td>
                    <td>
                        ${item.jammu_and_kashmir_score}
                        <img src="<?php echo e(asset('assets/images/arrow-${item.jk_score_trend}.svg')); ?>" alt="" />
                    </td>
                    <td>${item.best_performer_state}</td>
                    <td>${item.best_performer_state_score}</td>
                    <td>${item.best_performer_ut}</td>
                    <td>${item.best_performer_ut_score}</td>
                `;

                // Append the row to the table body
                tableBody.appendChild(row);
            });
        }

        // Fetch the data for the current year and goal
        fetchComparisonData(0);
    </script>
    
    <script>
        $(document).ready(function () {
            // Function to handle the click on the financial year link
            $(document).on("click", '[data-bs-toggle="modal"]', function () {
                
                const financialYear = $(this).data("year"); // Get the financial year from the data attribute

                if (financialYear) {
                    // Dynamically construct the file name based on the financial year
                    const fileName = `SDG_Analysis_${financialYear}.xlsx`;

                    // Set the fileUrl dynamically
                    window.fileUrl = `<?php echo e(asset('${fileName}')); ?>`;
                    $('#excelModalLabel').text(`Overall Comparison - ${financialYear}`); // Update the modal title

                    // Call the function to load the Excel file
                    loadExcelFile();
                } else {
                    console.error("Financial year not found or invalid.");
                    document.getElementById("excelContent").innerHTML = "Financial year not found or invalid.";
                }
            });

            // Function to load and parse the Excel file
            function loadExcelFile() {
                fetch(window.fileUrl)
                    .then((response) => response.arrayBuffer())
                    .then((data) => {
                        const workbook = XLSX.read(data, { type: "array" });
                        const sheet = workbook.Sheets[workbook.SheetNames[0]];
                        const html = XLSX.utils.sheet_to_html(sheet);

                        const contentDiv = document.getElementById("excelContent");
                        contentDiv.innerHTML = html;

                        const table = contentDiv.querySelector("table");
                        if (table) {
                            table.classList.add("excel-table");
                        }
                    })
                    .catch((error) => {
                        console.error("Error loading Excel file:", error);
                        document.getElementById("excelContent").innerHTML = "Failed to load Excel file.";
                    });
            }
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.main_content.public_page_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/public_dashboard/comparison_sdg_india.blade.php ENDPATH**/ ?>