<!DOCTYPE html>
<html>
<?php if($paginator->hasPages()): ?>
<nav aria-label="Page navigation example">
    <ul class="pagination justify-content-center">
        <?php if($paginator->onFirstPage()): ?>
        <li class="page-item disabled">
            <a class="page-link" href="#" tabindex="-1">Previous</a>
        </li>
        <?php else: ?>
        <li class="page-item"><a class="page-link" href="<?php echo e($paginator->previousPageUrl()); ?>">
                Previous</a>
        </li>
        <?php endif; ?>

        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if(is_string($element)): ?>
        <li class="page-item disabled"><?php echo e($element); ?></li>
        <?php endif; ?>

        <?php if(is_array($element)): ?>
        <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if($page == $paginator->currentPage()): ?>
        <li class="page-item active">
            <a class="page-link"><?php echo e($page); ?></a>
        </li>
        <?php else: ?>
        <li class="page-item">
            <a class="page-link" href="<?php echo e($url); ?>"><?php echo e($page); ?></a>
        </li>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <?php if($paginator->hasMorePages()): ?>
        <li class="page-item">
            <a class="page-link" href="<?php echo e($paginator->nextPageUrl()); ?>" rel="next">Next</a>
        </li>
        <?php else: ?>
        <li class="page-item disabled">
            <a class="page-link" href="#">Next</a>
        </li>
        <?php endif; ?>
    </ul>
    <p class="text-sm text-gray-700 mt-3">
        <?php echo __('Showing'); ?>

        <?php if($paginator->firstItem()): ?>
        <span class="font-medium"><?php echo e($paginator->firstItem()); ?></span>
        <?php echo __('to'); ?>

        <span class="font-medium"><?php echo e($paginator->lastItem()); ?></span>
        <?php else: ?>
        <?php echo e($paginator->count()); ?>

        <?php endif; ?>
        <?php echo __('of'); ?>

        <span class="font-medium"><?php echo e($paginator->total()); ?></span>
        <?php echo __('results'); ?>

    </p>
</nav>
<?php endif; ?>

</html><?php /**PATH /var/www/html/sdg_jk/resources/views/pagination/bootstrap-4.blade.php ENDPATH**/ ?>