<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add District', 'custom_css' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="page-content">
    <?php if(session('status')): ?>
    <div class="alert alert-success"><?php echo e(session('status')); ?></div>
    <?php endif; ?>
    <?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">District</h1>
        </div>
        <div class="card-body">
            <form id="create_district" method="POST" action="<?php if(!empty($district->id)): ?> <?php echo e(url('districts/'.$district->id)); ?> <?php else: ?> <?php echo e(url('districts')); ?> <?php endif; ?>">
                <?php echo csrf_field(); ?>
                <?php if(!empty($district->id)): ?>
                <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="district-name">District Name <em>*</em></label>
                                <input type="text" class="form-control" id="district-name" name="district_name" value="<?php if(!empty($district)): ?><?php echo e($district->district_name !=''?$district->district_name : ''); ?><?php else: ?><?php echo e(old('district_name')); ?><?php endif; ?>" placeholder="Enter District Name" data-rule-required="true" />
                                <?php $__errorArgs = ['district_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="district-code">District Code <em>*</em></label>
                                <input type="text" class="form-control" id="district-code" name="district_code" value="<?php if(!empty($district)): ?><?php echo e($district->district_code !=''?$district->district_code : ''); ?><?php else: ?><?php echo e(old('district_code')); ?><?php endif; ?>" placeholder="Enter District Code" data-rule-required="true" />
                                <?php $__errorArgs = ['district_code'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label">Division</label>
                                <div class="form-check-wrapper">
                                    <?php
                                    $jammu = '';
                                    $kashmir = '';
                                    ?>
                                    <?php if(old('division')=='jammu'): ?>
                                    <?php
                                    $jammu = 'checked';
                                    ?>
                                    <?php else: ?>
                                    <?php if(old('division')=='kashmir'): ?>
                                    <?php
                                    $kashmir = 'checked';
                                    ?>
                                    <?php else: ?>
                                    <?php if(!empty($district) && strtolower($district->region) == 'jammu'): ?>
                                    <?php
                                    $jammu = 'checked';
                                    ?>
                                    <?php else: ?>
                                    <?php if(!empty($district) && strtolower($district->region) == 'kashmir'): ?>
                                    <?php
                                    $kashmir = 'checked';
                                    ?>
                                    <?php else: ?>
                                    <?php
                                    $jammu = 'checked';
                                    ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <?php endif; ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="Jammu" id="flexCheckDefault2" name="division" <?php echo e($jammu); ?> />
                                        <label class="form-check-label" for="flexCheckDefault2">
                                            Jammu
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="Kashmir" name="division" id="flexCheckChecked" <?php echo e($kashmir); ?> />
                                        <label class="form-check-label" for="flexCheckChecked">
                                            Kashmir
                                        </label>
                                    </div>
                                    <?php $__errorArgs = ['division'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="<?php echo e(url()->previous()); ?>" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.validate.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/validation.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>
<script>
    $(document).ready(function() {
        $("#create_district").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/district/create.blade.php ENDPATH**/ ?>