<div class="modal-dialog modal-fullscreen" id="blur">
    <div id="loading">
        <div class="loader simple-loader">
            <div class="loader-body">
                <img src="<?php echo e(asset('assets/images/sdg-loader.gif')); ?>" alt="Loading..." />
            </div>
        </div>
    </div>
    <div class="modal-content">

        <div class="modal-header">
            <h1 class="modal-title fs-5" id="indicator3Label">
                <?php if(isset($indicator_district) && !empty($indicator_district)): ?>
                <?php echo e($indicator_district); ?> -
                <?php endif; ?>
                Indicator Classification
            </h1>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="colored-strips"></div>
        <div class="modal-body">
            <div class="action-bar-area">
                <div class="dropdowns-area">
                    <div class="dropdowns-item">
                        <div class="labeled-dropdown">
                            <label for="">
                                <span>Year:</span>
                                
                                <select name="year" id="year" onchange="updateDistrict()">
                                    <?php if(isset($reportingYears) && !empty($reportingYears) && count($reportingYears)>0): ?>
                                    <?php $__currentLoopData = $reportingYears; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $year): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($year['year']); ?>" <?php echo e(old('year',$selectedYear) == $year['year'] ? 'selected' : ''); ?>><?php echo e($year['id']); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                            </label>
                        </div>
                    </div>
                    <div class="dropdowns-item">
                        <div class="labeled-dropdown">
                            <label for="">
                                <span>District:</span>
                                
                                <select name="district" id="districtId" onchange="updateDistrict()">
                                    <?php if(isset($allDistricts) && !empty($allDistricts) && count($allDistricts) > 0): ?>
                                        <?php
                                            $regions = $allDistricts->groupBy('region'); // Group districts by region
                                        ?>
                                        <?php $__currentLoopData = $regions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region => $districts): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <optgroup label="<?php echo e($region); ?> Region">
                                                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($district->id); ?>" <?php echo e($district->district_name == $indicator_district ? 'selected' : ''); ?>>
                                                        <?php echo e($district->district_name); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </optgroup>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endif; ?>
                                </select>
                                
                            </label>
                        </div>
                    </div>
                </div>
            </div>
            <div id="sunrise-graph" style="width: 100%; max-width: 1400px; min-height: 100vh; height: 700px; margin: 0 auto;"></div>
            <div class="performance-view__grid">
                <div class="pv-grid-item">
                    <div class="pv-card">
                        <div class="pv-card-header success">
                            <div class="pv-card-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-star-fill" viewBox="0 0 16 16">
                                    <path d="M3.612 15.443c-.386.198-.824-.149-.746-.592l.83-4.73L.173 6.765c-.329-.314-.158-.888.283-.95l4.898-.696L7.538.792c.197-.39.73-.39.927 0l2.184 4.327 4.898.696c.441.062.612.636.282.95l-3.522 3.356.83 4.73c.078.443-.36.79-.746.592L8 13.187l-4.389 2.256z" />
                                </svg>
                            </div>
                            <h6>Best Performers - (<?php echo e(count($best_permonace)); ?>)</h6>
                        </div>
                        <div class="pv-card-body">
                            <table class="pv-table">
                                <thead>
                                    <tr>
                                        <th>Indicator</th>
                                        <th>Input Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(isset($best_permonace) && !empty($best_permonace) && count($best_permonace)>0): ?>
                                    <?php $__currentLoopData = $best_permonace; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $best_permonace_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($best_permonace_data['indicator_number']); ?>: <?php echo e($best_permonace_data['indicator_name']); ?></td>
                                        <td><?php echo e($best_permonace_data['indicator_value']); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td>No data</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="pv-grid-item">
                    <div class="pv-card">
                        <div class="pv-card-header danger">
                            <div class="pv-card-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-exclamation-circle-fill" viewBox="0 0 16 16">
                                    <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0M8 4a.905.905 0 0 0-.9.995l.35 3.507a.552.552 0 0 0 1.1 0l.35-3.507A.905.905 0 0 0 8 4m.002 6a1 1 0 1 0 0 2 1 1 0 0 0 0-2" />
                                </svg>
                            </div>
                            <h6>Requires Attention - (<?php echo e(count($require_attention)); ?>)</h6>
                        </div>
                        <div class="pv-card-body">
                            <table class="pv-table">
                                <thead>
                                    <tr>
                                        <th>Indicator</th>
                                        <th>Input Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(isset($require_attention) && !empty($require_attention) && count($require_attention)>0): ?>
                                    <?php $__currentLoopData = $require_attention; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $require_attention_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($require_attention_data['indicator_number']); ?>: <?php echo e($require_attention_data['indicator_name']); ?></td>
                                        <td><?php echo e($require_attention_data['indicator_value']); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td>No data</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="pv-grid-item">
                    <div class="pv-card">
                        <div class="pv-card-header muted">
                            <div class="pv-card-icon">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-exclamation-triangle-fill" viewBox="0 0 16 16">
                                    <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5m.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2" />
                                </svg>
                            </div>
                            <h6>Requires Immediate Action - (<?php echo e(count($require_immidiate_action)); ?>)</h6>
                        </div>
                        <div class="pv-card-body">
                            <table class="pv-table">
                                <thead>
                                    <tr>
                                        <th>Indicator</th>
                                        <th>Input Value</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if(isset($require_immidiate_action) && !empty($require_immidiate_action) && count($require_immidiate_action)>0): ?>
                                    <?php $__currentLoopData = $require_immidiate_action; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $require_immidiate_action_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($require_immidiate_action_data['indicator_number']); ?>: <?php echo e($require_immidiate_action_data['indicator_name']); ?></td>
                                        <td><?php echo e($require_immidiate_action_data['indicator_value']); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                    <tr>
                                        <td>No data</td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
</div>

<div class="modal fade themized-popup" id="indicatorClassificationInnerPopup" tabindex="-1"
aria-labelledby="indicatorClassificationInnerPopupLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
        <div class="modal-content">
            <div class="colored-strips"></div>
            <div class="modal-header">
                <h1 class="modal-title fs-5" id="indicatorClassificationInnerPopupLabel" style="color: white"></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="colored-strips"></div>
            <div class="modal-body">
                <table class="pv-table">
                    <thead>
                        <tr>
                            <th>Indicator</th>
                            <th>Input Value</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Data will be inserted dynamically here -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer"></div>
        </div>
    </div>
</div>

<script>
    <?php
    if (isset($sunrise_best_performance) && !empty($sunrise_best_performance)) {
        $best_permonace = "[" . $sunrise_best_performance . "]";
    } else {
        $best_permonace = "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]";
    }
    if (isset($sunrise_require_attention) && !empty($sunrise_require_attention)) {
        $require_attention = "[" . $sunrise_require_attention . "]";
    } else {
        $require_attention = "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]";
    }
    if (isset($sunrise_require_immidiate_action) && !empty($sunrise_require_immidiate_action)) {
        $require_immidiate_action = "[" . $sunrise_require_immidiate_action . "]";
    } else {
        $require_immidiate_action =  "[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]";
    }
    if (isset($max_value) && !empty($max_value)) {
        $max_value = $max_value;
    } else {
        $max_value = 10;
    }
    $not_applicable_14 = "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0," . $max_value . ", 0, 0,0]";
    $not_applicable_17 = "[0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, " . $max_value . "]";
    ?>

    $(document).ready(function() {
        const xAxisLabels = [{
                img: "<?php echo e(asset('assets/images/goals/goal_1.jpg')); ?>",
                title: "No Poverty",
                id: 1,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_2.jpg')); ?>",
                title: "Zero hunger",
                id: 2,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_3.jpg')); ?>",
                title: "Good health & well-being",
                id: 3,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_4.jpg')); ?>",
                title: "Quality education",
                id: 4,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_5.jpg')); ?>",
                title: "Gender equality",
                id: 5,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_6.jpg')); ?>",
                title: "Clean water & sanitation",
                id: 6,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_7.jpg')); ?>",
                title: "Affordable & clean energy",
                id: 7,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_8.jpg')); ?>",
                title: "Decent work & economic growth",
                id: 8,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_9.jpg')); ?>",
                title: "Industry, Innovation & Infrastructure",
                id: 9,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_10.jpg')); ?>",
                title: "Reduced inequality",
                id: 10,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_11.jpg')); ?>",
                title: "Sustainable cities and communities",
                id: 11,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_12.jpg')); ?>",
                title: "Responsible consumption and production",
                id: 12,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_13.jpg')); ?>",
                title: "Climate action",
                id: 13,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_14.jpg')); ?>",
                title: "Life below water",
                id: 14,
                class: "disabled-goal",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_15.jpg')); ?>",
                title: "Life on land",
                id: 15,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_16.jpg')); ?>",
                title: "Peace, justice & strong institutions",
                id: 16,
                class: "",
            },
            {
                img: "<?php echo e(asset('assets/images/goals/goal_17.jpg')); ?>",
                title: "Partnership for the Goals",
                id: 17,
                class: "disabled-goal",
            },
        ];

        const sunriseCategories = [];

        for (let index = 0; index < xAxisLabels.length; index++) {
            const element = xAxisLabels[index];
            
            sunriseCategories.push(
                `<div class="label_wrapper ${element.class}">
      <img class="label_img" src="${element.img}" />
      <div class="label_text">${element.title}</div>
    </div>`
            );
        }

        Highcharts.chart(
            "sunrise-graph", {
                exporting: {
                    // buttons: {
                    //     contextButton: {
                    //         menuItems: Highcharts.getOptions().exporting.buttons.contextButton.menuItems.filter(
                    //             (item) => item !== "viewFullscreen"
                    //         ),
                    //     },
                    // },
                    enabled: false // This disables the chart menu
                },
                chart: {
                    polar: true,
                    type: "column",
                    marginBottom: -350,
                },
                title: {
                    text: "",
                },
                legend: {
                    // margin: 20, // Add bottom margin to legends
                    y: -100, // Adjust the legend position upwards
                },
                pane: {
                    startAngle: -90,
                    endAngle: 90,
                    size: "85%", // Adjust size to allow for proper spacing
                },
                xAxis: {
                    tickInterval: 20,
                    min: 0,
                    max: 340,
                    //categories: sunriseCategories,
                    // gridLineWidth: 0,
                    // gridLineColor: "transparent",
                    lineWidth: 0,
                    tickmarkPlacement: "on", // Adjust tickmark placement for better alignment
                    labels: {
                        useHTML: true,
                        distance: 40,
                        formatter: function() {
                            return sunriseCategories[this.value / 20];
                        },
                        // allowOverlap: true,
                        style: {
                            // width: "140px", // Adjust label width if necessary
                            textAlign: "center", // Center align text
                            zIndex: 0,
                        },
                    },
                },
                yAxis: {
                    min: -10,
                    // gridLineWidth: 0,
                    labels: {
                        enabled: false,
                        zIndex: 0,
                        // allowOverlap: true,
                    },
                },
                plotOptions: {
                    series: {
                        stacking: "normal",
                        pointStart: 0,
                        pointInterval: 20,
                        cursor: "pointer",
                        point: {
                            events: {
                            click: function () {

                                
                                // Added the click event so that when the user clicks no the bars then the pop up model is loaded
                                const goalIndex = (this.x - this.series.options.pointStart) / this.series.options.pointInterval;

                                // Get the category and goal name
                                const category = this.series.name; // e.g., "Best Performers"
                                const goalName = xAxisLabels[goalIndex].title;
                                const goalId = xAxisLabels[goalIndex].id;
                                // Determine the data based on goal and category
                                let columnData = [];
                                let barColor = ''; // to send the barcolor according to the category
                                if (category === "Best Performers") {
                                    columnData = <?php echo json_encode($best_permonace); ?>;
                                    barColor = "#62AA24";
                                } else if (category === "Requires Attention") {
                                    columnData = <?php echo json_encode($require_attention); ?>;
                                    barColor = "#FDD617";
                                } else if (category === "Requires Immediate Action") {
                                    columnData = <?php echo json_encode($require_immidiate_action); ?>;
                                    barColor = "#D8191E";
                                }

                                // Pass goal and data to the modal
                                openModal(goalName, category, columnData, goalId, barColor);
                            },
                            },
                        },
                    },
                    column: {
                        pointStart: 10,
                        pointInterval: 20,
                        stacking: "normal",
                        borderWidth: 0,
                        borderColor: "transparent",
                        // pointPadding: 0.05,
                        groupPadding: 0.05,
                        pointPadding: 0,
                        // groupPadding: 0,
                        pointPlacement: "on", // Change to 'on' for alignment
                    },
                },
                series: [{
                        type: "column",
                        name: "Goal 14 - Not Applicable",
                        data: <?php echo $not_applicable_14; ?>,
                        color: "#ccc", // Grey color for the background
                        zIndex: 999999999,
                        // enableMouseTracking: false, // This disables interactions such as tooltips for this series
                        // showInLegend: false, // Optional: Hide from legend
                        tooltip: {
                            pointFormatter: function() {
                                return '<span style="color:#000;">Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.</span>';
                            },
                            headerFormat: "", // Remove header
                            footerFormat: "", // Remove footer
                            formatter: function() {
                                // Prevent the default tooltip
                                return false;
                            },
                        },
                    },
                    {
                        type: "column",
                        name: "Goal 17 - Not Applicable",
                        data: <?php echo $not_applicable_17; ?>,
                        color: "#ccc", // Grey color for the background
                        zIndex: 99999999,
                        // enableMouseTracking: false, // This disables interactions such as tooltips for this series
                        // showInLegend: false, // Optional: Hide from legend
                        tooltip: {
                            pointFormatter: function() {
                                return '<span style="color:#000;">Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.</span>';
                            },
                            headerFormat: "", // Remove header
                            footerFormat: "", // Remove footer
                            formatter: function() {
                                // Prevent the default tooltip
                                return false;
                            },
                        }
                    },
                    {
                        type: "column",
                        name: "Best Performers",
                        data: <?php echo $best_permonace; ?>,
                        color: "#62AA24",
                        tooltip: {
                            headerFormat: "", // Remove header
                            footerFormat: "", // Remove footer
                            zIndex: 99999,
                        },
                    },
                    {
                        type: "column",
                        name: "Requires Attention",
                        data: <?php echo $require_attention; ?>,
                        color: "#FDD617",
                        tooltip: {
                            headerFormat: "", // Remove header
                            footerFormat: "", // Remove footer
                            zIndex: 99999,
                        },
                    },
                    {
                        type: "column",
                        name: "Requires Immediate Action",
                        data: <?php echo $require_immidiate_action; ?>,
                        color: "#D8191E",
                        tooltip: {
                            headerFormat: "", // Remove header
                            footerFormat: "", // Remove footer
                            zIndex: 99999,
                        },
                    },
                ],
                responsive: {
                    rules: [{
                        condition: {
                            maxWidth: 565,
                        },
                        chartOptions: {
                            chart: {
                                marginBottom: 0,
                            },
                            pane: {
                                size: "75%", // Adjust size to allow for proper spacing
                            },
                        },
                    }, ],
                },
            },
            function(chart) {
                // Calculate center position
                var centerX = chart.plotLeft + chart.plotWidth * 0.5;
                var centerY = chart.plotTop + chart.plotHeight * 0.5 - 45;
                var width = 223; // Width of the image
                var height = 150; // Height of the image

                let mobileMedia = window.matchMedia("(max-width: 565px)");

                if (mobileMedia.matches) {
                    centerY = chart.plotTop + chart.plotHeight * 0.5 - 17;
                    width = 60; // Width of the image
                    height = 40; // Height of the image
                }

                chart.renderer
                    .image(
                        "<?php echo e(asset('assets/images/semi-sgd.png')); ?>",
                        centerX - width / 2,
                        centerY - height / 2,
                        width,
                        height
                    )
                    .attr({
                        zIndex: 10, // Ensures the image is above most chart elements
                    })
                    .add();
            }
        );
    });

    /**
     * BOC
     * Task Id: #156381 Implement a click event on the sunrise graph to show respective indicators on the screen.
     * This function is used to fetch data from the server and populate the modal with the fetched data.
     * @author Almaaz Ahmed
     * @date 17-12-2024
     */
    function openModal(goalName, category, data, goalId, barColor) {
        $('.loader').show();
        $('body').addClass('blur');

        // Fetch district-related information
        const districtSelect = document.getElementById('districtId');
        const districtName = districtSelect.options[districtSelect.selectedIndex].text;
        const districtId = districtSelect.value;

        const year = document.getElementById('year').options[document.getElementById('year').selectedIndex].text;
        // Make AJAX request
        $.ajax({
            url: "<?php echo e(route('public.dashboard.sunrise_graph_data')); ?>",
            type: "POST",
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                district_id: districtId,
                year: year,
                goal_name: goalName,
                category: category,
                goal_id: goalId,
            },
            success: function(response) {
                // Update the background color dynamically for the header and the footer of the modal
                const barColor2 = barColor || '#ffc107'; // Default color if barColor is not available
                document.querySelector('.themized-popup .modal-header').style.backgroundColor = barColor2;
                document.querySelector('.themized-popup .modal-footer').style.backgroundColor = barColor2;



                const tableBody = $("#indicatorClassificationInnerPopup tbody");
                tableBody.empty(); // Clear existing table rows before populating new data

                if (response.data && response.data.length > 0) {
                    // Loop through the fetched data and append rows to the table
                    response.data.forEach((item) => {
                        console.log(item);
                        
                        const row = `<tr>
                                        <td>${item.indicator_number}: ${item.indicator_name}</td>
                                        <td>${item.indicator_value != null ? item.indicator_value : ''  }</td>
                                    </tr>`;
                        tableBody.append(row);
                    });
                } else {
                    // If no data is available, append a "No Data" row
                    tableBody.append(
                        `<tr><td colspan="2" class="text-center">No data available</td></tr>`
                    );
                }

                // Hide the loader and remove blur after successful population
                $('.loader').fadeOut('slow');
                $('body').removeClass('blur');
                // Add blur effect to the background
                var blur = document.getElementById('blur');
                blur.classList.toggle('active');
            },

            error: function(error) {
                console.error("Error occurred:", error);
            }
        });

        // Update the modal title dynamically
        $('#indicatorClassificationInnerPopupLabel').text(
            `${districtName} - ${goalName}, ${category}`
        );

        // Open the modal
        $("#indicatorClassificationInnerPopup").modal("show");
    }

    /**
     * BOC
     * Task 156546-Create a tab titled as Analysis and Interpretation in the burger menu and Adding Year and District Filter
     * This function is used to update the sunrise graph when the district is changed or the year is changed.
     * @author Almaaz Ahmed
     * @date 17-12-2024
     */
    function updateDistrict(){
        const district_id = document.getElementById('districtId').value;
        const year = document.getElementById('year').value;
        showIndicatorDetailsforDistrict(year, district_id);
    }

    // Close the modal when the close button is clicked
    $(document).on('click', '.btn-close', function() {
        var closebtn = document.getElementById('blur');
        closebtn.classList.remove('active');
    });

    // Remove the active class when clicking outside the modal
    $(document).on('click', function(event) {
        var modalContent = $('.modal-fullscreen'); // Target the modal content
        var blurDiv = document.getElementById('blur');

        // Check if the click is outside the modal-content
        if (!modalContent.is(event.target) && modalContent.has(event.target).length === 0) {
            blurDiv.classList.remove('active'); // Remove active class
        }
    });
</script><?php /**PATH /var/www/html/sdg_jk/resources/views/public_dashboard/district_indicator_year_bise_data.blade.php ENDPATH**/ ?>