<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Create User', 'custom_css' =>''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('header'); ?>
<?php echo $__env->make('layouts.header.admin_page_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('sidebar'); ?>
<?php echo $__env->make('layouts.sidebar.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footer'); ?>
<?php echo $__env->make('layouts.footer.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('loader'); ?>
<?php echo $__env->make('layouts.other.loader', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">

            <?php if($errors->any()): ?>
            <ul class="alert alert-warning">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
            <?php endif; ?>

            <div class="card">
                <div class="card-header">
                    <h4>Create User
                        <a href="<?php echo e(url('users')); ?>" class="btn btn-danger float-end">Back</a>
                    </h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(url('users')); ?>" method="POST" class="validate_form" id="validatejs">
                        <?php echo csrf_field(); ?>
                        <div class="mb-3">
                            <label for="">Username</label>
                            <input type="text" name="username" class="form-control" value="<?php echo e(old('username')); ?>" placeholder="Enter Username" data-rule-required="true"/>
                            <?php $__errorArgs = ['username'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="mb-3">
                            <label for="">Email Address</label>
                            <input type="email" name="email_address" class="form-control" value="<?php echo e(old('email_address')); ?>" placeholder="Enter Email Address" data-rule-required="true" data-rule-email="true"/>
                            <?php $__errorArgs = ['email_address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="mb-3">
                            <label for="">Password</label>
                            <input type="text" name="password" id="passwd" class="form-control" placeholder="Enter Password" data-rule-passwd="true" />
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3">
                            <label for="">Roles</label>
                            <select name="role" id="role" class="form-select" data-rule-required="true">
                                <option value="">Select Role</option>
                                <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($role); ?>" <?php echo e(old('role') == $role ? 'selected' : ''); ?>><?php echo e($role); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['role'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="mb-3 d-none" id="department-section">
                            <label for="">Department</label>
                            <select name="department_id" id="department_id" class="form-select">
                                <option value="">Select Department</option>
                                <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($department->id); ?>" <?php echo e(old('department_id') == $department->id ? 'selected' : ''); ?>><?php echo e($department->department_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['department_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="mb-3 d-none" id="district-section">
                            <label for="">District</label>
                            <select name="district_id" id="district_id" class="form-select">
                                <option value="">Select District</option>
                                <?php $__currentLoopData = $districts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $district): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($district->id); ?>" <?php echo e(old('district_id') == $district->id ? 'selected' : ''); ?>><?php echo e($district->district_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['district_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<!-- Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/libs.min.js')); ?>"></script>

<!-- External Library Bundle Script -->
<script src="<?php echo e(asset('assets/js/core/external.min.js')); ?>"></script>

<!-- App Script -->
<script src="<?php echo e(asset('assets/js/hope-ui.js')); ?>" defer></script>


<script src="<?php echo e(asset('assets/js/validation.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/jquery.validate.js')); ?>" defer></script>
<script>
    function encryptPassword(e, form) {
        e.preventDefault(); // Prevent the form from submitting immediately

        // Get the password and confirm password field values
        var passwordInput = document.getElementById('passwd');

        var password = passwordInput.value;

        // Encrypt the password using your custom XOR + base64 encoding method
        var encodedPassword = encodePassword(password);

        // Set the encrypted values back to the input fields
        passwordInput.value = encodedPassword;

        // Optionally, toggle password visibility
        var input = $('#passwd');
        if (input.attr("type") === "text") {
            input.attr("type", "password");
        }

        // Now submit the form
        form.submit();
    }

    // Function to encode the password
    function encodePassword(password) {
        var encoded = "";
        var passwordStr = btoa(btoa(password)); // Double base64 encoding

        // XOR encryption with number 10
        for (var i = 0; i < passwordStr.length; i++) {
            var a = passwordStr.charCodeAt(i);
            var b = a ^ 10; // Bitwise XOR with number 10
            encoded += String.fromCharCode(b);
        }

        return btoa(encoded); // Final base64 encoding
    }
</script>

<script>
    $(document).ready(function () {
        $(".validate_form").validate({
            errorClass: "text-danger",
            submitHandler: function (form, event) {
                encryptPassword(event, form);
            }
        });

        // BOC: Added the script to show/hide the department/district dropdowns. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193
        // Handle role change to show/hide department/district dropdowns
        $('#role').change(function() {
            var selectedRole = $(this).val();
            $('#department-section').addClass('d-none');
            $('#district-section').addClass('d-none');
            
            if (selectedRole === 'Department-User' || selectedRole === 'Department-Approver' || selectedRole === 'Department-HOD') {
                $('#department-section').removeClass('d-none');
            } else if (selectedRole === 'District-User' || selectedRole === 'District-Approver' || selectedRole === 'District-HOD') {
                $('#district-section').removeClass('d-none');
            }
        });
        // EOC: Added the script to show/hide the department/district dropdowns. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193
    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.main_content.admin_pages_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/sdg_jk/resources/views/admin_pages/access-control/user/create.blade.php ENDPATH**/ ?>