<?php

use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\DistrictController;
use App\Http\Controllers\IndicatorController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\PublicDashboardController;
use App\Http\Controllers\TargetController;
use App\Http\Controllers\IndicatorDataEntriesController;
use App\Http\Controllers\UtifIndicatorListingController;
use App\Http\Controllers\DifIndicatorListingController;
use App\Http\Controllers\GraphDashboardController;
use App\Http\Controllers\ExportReportController;
use App\Http\Controllers\ImportRawDataController;
use App\Http\Controllers\DashboardInputController;
use App\Http\Controllers\GoalComparisionWithIndiaController;
use App\Http\Controllers\SideBarController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

// Route for SDG home landing page
Route::get('/', function () {
    return view('index');
})->name('index');

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------ START: Public Dashboard ------------------------------------------------//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
Route::get('/district_indicator_framework/{goalId?}/{districtCode?}', function ($goalId = null, $districtCode = null) {
    $publicDashboardController = resolve(PublicDashboardController::class);
    if ($goalId != null && $districtCode != null) {
        return $publicDashboardController->index($goalId, $districtCode);
    } else {
        return $publicDashboardController->index();
    }
})->name('district_indicator_framework');

Route::get('/dashboard', [PublicDashboardController::class,'index'])->name('dashboard');

// updated the below routes for and added the controller
Route::get('/about-us', [SideBarController::class, 'aboutUs'])->name('about_us');

Route::get('/whats-new', [SideBarController::class, 'whatsNew'])->name('whats_new');

Route::get('/contact-us', [SideBarController::class, 'contactUs'])->name('contact_us');

Route::get('/resources-publications',[SideBarController::class, 'publication'])->name('publications');

Route::get('/public-resources', [SideBarController::class, 'resources'])->name('resources');
// EOC

Route::get('/back', function () {
    return redirect()->back();
})->name('back');

Route::post('/public-dashboard/district-sdg-score-for-goal', [PublicDashboardController::class, 'districtSdgScoreForGoalAndDefaultDistrict'])
    ->name('public.dashboard.district_sdg_score_for_goal');

Route::post('/public-dashboard/district-indicators-for-year', [PublicDashboardController::class, 'district_indicators_for_year'])
    ->name('public.dashboard.district_indicators_for_year');

Route::post('/public-dashboard/goal-indicator-data', [PublicDashboardController::class, 'goal_indicator_data'])
    ->name('public.dashboard.goal_sdg_indicators_data');

    // Route for getting the data for the graph
Route::post('/public-dashboard/sunrise-graph-data', [PublicDashboardController::class, 'sunrise_graph_data'])
    ->name('public.dashboard.sunrise_graph_data');

Route::get('/public-dashboard/comparison_sdg_india', [PublicDashboardController::class, 'show_comparison_sdg_india'])
    ->name('public.dashboard.comparison_sdg_india');

    Route::get('/goals/publiPageComparisionData', [GoalComparisionWithIndiaController::class, 'getPublicPageComparisonData'])->name('public_page_comparison_data');
    // Route to handle form submission for save or update
    Route::post('/save-or-update-goal-comparison', [DashboardInputController::class, 'saveOrUpdate'])
    ->name('saveOrUpdateGoalComparison');

Route::post('/public-dashboard/division-district-goals', [PublicDashboardController::class, 'division_district_goals'])
    ->name('public.dashboard.division_district_goals');

Route::post('/public-dashboard/division-district-goal-indicators', [PublicDashboardController::class, 'division_district_goal_indicators'])
    ->name('public.dashboard.division_district_goal_indicators');

Route::get('/public-dashboard/call_procedures', [PublicDashboardController::class, 'call_procedures']);

Route::get('/view-pdf/{filename}', function ($filename) {
    $path = storage_path('app/public/pdfs/' . $filename);

    if (!file_exists($path)) {
        abort(404, 'File not found');
    }

    return Response::file($path, ['Content-Type' => 'application/pdf']);
})->name('view.pdf');

Route::get('/download/{filename}', function ($filename) {
    $filePath = storage_path("app/public/pdfs/" . $filename); // Adjust the path if necessary

    if (!file_exists($filePath)) {
        abort(404, "File not found");
    }

    return response()->download($filePath);
})->name('download.file');

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------ END: Public Dhasboard --------------------------------------------------//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Routes for User login functionality
Auth::routes();
Route::get('/signup', function () {
    return view('auth.login');
});


/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------ START: Admin Pages Section ---------------------------------------------//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// BOC - Cache Control Header: This ensures that when a user tries to access any protected page, it won't be cached, and pressing the back button won't allow them to see a stale page. BY ALMAAZ AHMED ON 20-MARCH-2025 #159048
Route::middleware(['auth','Cors', 'FilterInputs','prevent.cache','block.methods','check.session'])->group(
    function () {
        // Routes for resource controller of District master 
        Route::resource('districts', DistrictController::class)->except(['show']);
        Route::get('districts/{districtId}/{action}/delete', [DistrictController::class, 'destroy']);
        Route::get('districts/export', [DistrictController::class, 'exportDistricts']);

        // Routes for resource controller of Target master
        Route::resource('targets', TargetController::class)->except(['show']);
        Route::get('targets/{targetId}/{action}/delete', [TargetController::class, 'destroy']);
        Route::get('targets/export', [TargetController::class, 'exportTargets']);

        // Route for the dashboard Input controller
        Route::get('/dashboard_input', [DashboardInputController::class, 'index'])->name('dashboard_input');
        Route::get('/goals/comparisionData', [GoalComparisionWithIndiaController::class, 'getcomparisionData'])->name('comparisionData');
        // Routes for resource controller of Department master
        Route::resource('departments', DepartmentController::class)->except(['show']);
        Route::get('departments/{departmentId}/{action}/delete', [DepartmentController::class, 'destroy']);
        Route::get('departments/export', [DepartmentController::class, 'exportDepartments']);

        // Routes for resource controller of Indicators master
        Route::resource('indicators', IndicatorController::class)->except(['show']);
        Route::get('indicators/{indicatorsId}/{action}/delete', [IndicatorController::class, 'destroy']);
        Route::get('indicators/export', [IndicatorController::class, 'exportIndicators'])->name('indicators.export');
        Route::post('/indicators/targets', [IndicatorController::class, 'getTargets'])->name('indicators.targets');
        Route::get('indicators/filter', [IndicatorController::class, 'index'])->name('indicators.filter');

        // Routes for Permissions
        Route::resource('permissions', PermissionController::class);
        Route::get('permissions/{permissionId}/delete', [PermissionController::class, 'destroy']);

        // Routes for Roles actions
        Route::resource('roles', RoleController::class);
        Route::get('roles/{roleId}/delete', [RoleController::class, 'destroy']);
        Route::get('roles/{roleId}/give-permissions', [RoleController::class, 'addPermissionToRole'])->name('roles.give-permissions');
        Route::put('roles/{roleId}/give-permissions', [RoleController::class, 'givePermissionToRole']);


        // Route for user controller
        Route::resource('users', UserController::class);
        Route::get('users/{userId}/delete', [UserController::class, 'destroy']);
        Route::get('/change-password', [UserController::class, 'changePassword'])->name('password.change');
        Route::post('/updatePassword', [UserController::class, 'updatePassword'])->name('updatePassword');

        // Route for Indicator-data-entries functionality.
        Route::get('/indicator-data-entries', [IndicatorDataEntriesController::class, 'index'])->name('indicator_data_entries');
        Route::get('indicator-data-entries/filter', [IndicatorDataEntriesController::class, 'index'])->name('indicator_data_entries.filter');
        Route::post('indicator-data-entries/update-indicator-value', [IndicatorDataEntriesController::class, 'updateIndicatorValue'])->name('indicator-data-entries.update-indicator-value');
        Route::post('indicator-data-entries.approve-disapprove', [IndicatorDataEntriesController::class, 'indicatorValueApproveAdisapprove'])->name('indicator-data-entries.approve-disapprove');
        Route::get('indicator-data-entries/export', [IndicatorDataEntriesController::class, 'exportIndicatorDataEntries'])->name('indicator_data_entries.export');

        // Route for Admin dashboard (the defalut page)
        Route::get('/graph-dashboard', [GraphDashboardController::class, 'index'])->name('graph_dashboard');
        Route::get('graph-dashboard/filter', [GraphDashboardController::class, 'index'])->name('graph_dashboard.filter');
        Route::get('graph-dashboard/get-indicators', [GraphDashboardController::class, 'getIndicators'])->name('graph_dashboard.get_indicators');
        Route::get('graph-dashboard/get-indicators-graph-data', [GraphDashboardController::class, 'getIndicatorsGraphData'])->name('graph_dashboard.get_indicator_graph_data');

        //Route for UTIF listing on switch to list button
        Route::get('/utif-indicator-listing', [UtifIndicatorListingController::class, 'index'])->name('utif_indicator_listing');
        Route::get('utif-indicator-listing/filter', [UtifIndicatorListingController::class, 'index'])->name('utif_indicator_listing.filter');

        //Route for DIF listing on Switch to list button
        Route::get('/dif-indicator-listing', [DifIndicatorListingController::class, 'index'])->name('dif_indicator_listing');
        Route::get('dif-indicator-listing/filter', [DifIndicatorListingController::class, 'index'])->name('dif_indicator_listing.filter');

        //Route for Export Reports
        Route::get('/export-reports', [ExportReportController::class, 'index'])->name('export_report');
        Route::get('/export-reports-form', [ExportReportController::class, 'exportData'])->name('export_report.export_data');

        Route::get('/import-export-reports', [ImportRawDataController::class, 'index'])->name('import_export');
        Route::get('/import-export-reports/DownloadIndicatorsRawData', [ImportRawDataController::class, 'downloadIndicatorsRawData'])->name('import_export.download_indicators_raw_data');
        Route::post('/import-export-reports/ImportIndicatorsRawData', [ImportRawDataController::class, 'importIndicatorsRawData'])->name('import_export.import_indicators_raw_data');
    }
);
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//------------------------------------------------ END: Admin Pages Section -----------------------------------------------//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////