@extends('layouts.main_content.public_page_layout')

@section('head')
    @include('layouts.head.public_page_head', [
        'title' => 'SDG J&K - Dashboard',
        'custom_css' => 'assets/css/gallery.css',
    ])
@endsection

@section('header')
    @include('layouts.header.public_page_header')
@endsection

@section('sidebar')
    @include('layouts.sidebar.public_page_sidebar')
@endsection

@section('footer')
    @include('layouts.footer.footer')
@endsection

@section('loader')
    @include('layouts.other.loader')
@endsection

@section('public_content')
    <section class="gallery-banner-section">
        <div class="gallery-banner-area">
            <h1>What's New & Gallery</h1>
        </div>
    </section>
    <!-- /Banner Section -->

    <!-- What's New Section -->
    <section class="what-new-section">
        <div class="what-new-area">
            <h2 class="section-heading">What's New</h2>
            <div class="what-new-list-area">
                <ul class="what-new-list">
                    <li>
                        <a href="{{ route('view.pdf', ['filename' => 'UT & District Indicator Framework 2023.pdf']) }}"
                            target="_blank" class="news-card">
                            <div class="news-card-image">
                                <img src="{{ asset('assets/images/gallery-pdg.png') }}" alt="What's New" />
                            </div>
                            <div class="news-card-content">
                                <h3 class="news-card-title">
                                    UT & District Indicator Framework 2023
                                </h3>
                            </div>
                        </a>
                    </li>
                    {{-- <li>
            <a href="#" class="news-card">
              <div class="news-card-image">
                <img src="assets/images/new-2.png" alt="What's New" />
              </div>
              <div class="news-card-content">
                <h3 class="news-card-title">
                  Lorem ipsum dolor sit amet consectetur, adipisicing
                  elit. Doloribus nesciunt et nulla?
                </h3>
                <p class="news-card-para">
                  Lorem ipsum dolor sit amet consectetur adipisicing
                  elit. Recusandae magnam officia molestiae nostrum
                  sequi, aut et perferendis commodi iusto minima
                  consequuntur ab eligendi corrupti error reiciendis!
                  Voluptatibus temporibus porro optio?
                </p>
              </div>
            </a>
          </li>
          <li>
            <a href="#" class="news-card">
              <div class="news-card-image">
                <img src="assets/images/new-3.png" alt="What's New" />
              </div>
              <div class="news-card-content">
                <h3 class="news-card-title">
                  Lorem ipsum dolor sit amet consectetur, adipisicing
                  elit. Doloribus nesciunt et nulla?
                </h3>
                <p class="news-card-para">
                  Lorem ipsum dolor sit amet consectetur adipisicing
                  elit. Recusandae magnam officia molestiae nostrum
                  sequi, aut et perferendis commodi iusto minima
                  consequuntur ab eligendi corrupti error reiciendis!
                  Voluptatibus temporibus porro optio?
                </p>
              </div>
            </a>
          </li> --}}
                </ul>
            </div>
        </div>
    </section>
    <!-- /What's New Section -->

    <!-- Gallery Section -->
    <section class="gallery-section">
        <div class="gallery-area">
            <h2 class="section-heading">Gallery</h2>
            <div class="gallery-layout">
                {{-- <div class="gallery-item">
          <a href="#">
            <img src="assets/images/g1.png" />
          </a>
        </div>

        <div class="gallery-item gallery-nested-layout">
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g12.png" />
            </a>
          </div>
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g13.jpg" />
            </a>
          </div>
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g14.jpg" />
            </a>
          </div>
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g15.png" />
            </a>
          </div>
        </div>

        <div class="gallery-item gallery-nested-layout">
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g2.png" />
            </a>
          </div>
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g3.png" />
            </a>
          </div>
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g4.png" />
            </a>
          </div>
          <div class="gallery-item">
            <a href="#">
              <img src="assets/images/g11.png" />
            </a>
          </div>
        </div>

        <div class="gallery-item">
          <a href="#">
            <img src="assets/images/g5.jpg" />
          </a>
        </div> --}}

                <div class="gallery-item">
                    <a href="{{asset('assets/images/g10.jpg')}}" target="_blank">
                        <img src="{{asset('assets/images/g10.jpg')}}" />
                    </a>
                </div>

                <div class="gallery-item gallery-nested-layout">
                    <div class="gallery-item">
                        <a href="{{ asset('assets/images/g6.jpg') }}" target="_blank">
                            <img src="{{ asset('assets/images/g6.jpg') }}" />
                        </a>
                    </div>
                    <div class="gallery-item">
                        <a href="{{asset('assets/images/g7.jpg')}}" target="_blank">
                            <img src="{{asset('assets/images/g7.jpg')}}" />
                        </a>
                    </div>
                    <div class="gallery-item">
                        <a href="{{asset('assets/images/g8.jpg')}}" target="_blank">
                            <img src="{{asset('assets/images/g8.jpg')}}" />
                        </a>
                    </div>
                    <div class="gallery-item">
                        <a href="{{asset('assets/images/g9.jpg')}}" target="_blank">
                            <img src="{{asset('assets/images/g9.jpg')}}" />
                        </a>
                    </div>
                </div>

            </div>
        </div>
        @include('layouts.other.indicator_modal')
    </section>
    {{-- <section>
    <div class="cs-public-banner">
        <img src="assets/images/whats-next-banner.png" alt="What's New" class="cs-public-banner-img" />
        <div class="cs-public-banner-overlay container">
            <h2>What's New</h2>
        </div>
    </div>
</section>
<section>
    <div class="container">
        <div class="row">
            <div class="col-lg-4 col-md-6">
                <a href="#" class="card new__card">
                    <div class="card-body">
                        <div class="img-area">
                            <img src="assets/images/new-1.png" />
                        </div>
                        <div class="content-area">
                            <h2 class="new_title">
                                Lorem ipsum dolor sit amet consectetur. Ut mus sapien
                                elit a massa fermentum.
                            </h2>
                            <div class="new_para">
                                Lorem ipsum dolor sit amet consectetur.
                            </div>
                            <button type="button" class="btn btn-success">
                                View
                            </button>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-4 col-md-6">
                <a href="#" class="card new__card">
                    <div class="card-body">
                        <div class="img-area">
                            <img src="assets/images/new-3.png" />
                        </div>
                        <div class="content-area">
                            <h2 class="new_title">
                                Lorem ipsum dolor sit amet consectetur. Ut mus sapien
                                elit a massa fermentum.
                            </h2>
                            <div class="new_para">
                                Lorem ipsum dolor sit amet consectetur.
                            </div>
                            <button type="button" class="btn btn-success">
                                View
                            </button>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-4 col-md-6">
                <a href="#" class="card new__card">
                    <div class="card-body">
                        <div class="img-area">
                            <img src="assets/images/new-4.png" />
                        </div>
                        <div class="content-area">
                            <h2 class="new_title">
                                Lorem ipsum dolor sit amet consectetur. Ut mus sapien
                                elit a massa fermentum.
                            </h2>
                            <div class="new_para">
                                Lorem ipsum dolor sit amet consectetur.
                            </div>
                            <button type="button" class="btn btn-success">
                                View
                            </button>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-4 col-md-6">
                <a href="#" class="card new__card">
                    <div class="card-body">
                        <div class="img-area">
                            <img src="assets/images/new-5.png" />
                        </div>
                        <div class="content-area">
                            <h2 class="new_title">
                                Lorem ipsum dolor sit amet consectetur. Ut mus sapien
                                elit a massa fermentum.
                            </h2>
                            <div class="new_para">
                                Lorem ipsum dolor sit amet consectetur.
                            </div>
                            <button type="button" class="btn btn-success">
                                View
                            </button>
                        </div>
                    </div>
                </a>
            </div>
            <div class="col-lg-4 col-md-6">
                <a href="#" class="card new__card">
                    <div class="card-body">
                        <div class="img-area">
                            <img src="assets/images/new-2.png" />
                        </div>
                        <div class="content-area">
                            <h2 class="new_title">
                                Lorem ipsum dolor sit amet consectetur. Ut mus sapien
                                elit a massa fermentum.
                            </h2>
                            <div class="new_para">
                                Lorem ipsum dolor sit amet consectetur.
                            </div>
                            <button type="button" class="btn btn-success">
                                View
                            </button>
                        </div>
                    </div>
                </a>
            </div>
        </div>
    </div>
    @include('layouts.other.indicator_modal')
</section> --}}
@endsection
@push('script')
    <script src="{{ asset('assets/js/core/libs.min.js') }}"></script>
    <script src="{{ asset('assets/js/hope-ui.js') }}" defer></script>
    <script>
        $(document).ready(function() {
            $('.loader').fadeOut('slow');
        });
    </script>
@endpush
