{{--  
 BOC
 Task #156541 
 Purpose I have updated the page so to show the data related to the district. This is the modal that will be shown when the user clicks on the district on the public dashboard page. and selects the goal.
 @author Almaaz Ahmed
 @date 18-12-2024 
--}}
<div class="modal-dialog modal-fullscreen">
    <div id="loading">
        <div class="loader simple-loader">
            <div class="loader-body">
                <img src="{{asset('assets/images/sdg-loader.gif')}}" alt="Loading..." />
            </div>
        </div>
    </div>
    <div class="modal-content">
        <div class="modal-header">
            <h1 class="modal-title fs-5" id="indicator2Label">
                Performance of Indicator
            </h1>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="colored-strips"></div>
        <div class="modal-body">
            @if(isset($singleGoaldata) && !empty($singleGoaldata))
            @if($singleGoaldata['goal_id'] == '14' || $singleGoaldata['goal_id'] == '17')
            <div class="invalid-indicator-wrapper">
                <div class="ii__image">
                    @php
                    $goal_id = $singleGoaldata['goal_id'];
                    $goal_name = $singleGoaldata['goal_name'];
                    @endphp
                    <img src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal_name}}" />
                </div>
                <h2 class="invalid-indicator-msg">
                    @if($singleGoaldata['goal_id'] == '14')
                    Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                    @elseif($singleGoaldata['goal_id'] == '17')
                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                    @endif
                </h2>
            </div>
            @else
            <div class="sidebar-table-wrapper">
                <div class="sidebar-table__content-area">
                    <div class="stca__img-area">
                        @if(isset($singleGoaldata) && !empty($singleGoaldata))
                        @php
                        $goal_id = $singleGoaldata['goal_id'];
                        $goal_name = $singleGoaldata['goal_name'];
                        @endphp
                        <input type="hidden" value="{{$goal_id}}" id="goal_id" />
                        <img src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal_name}}" />
                        @endif
                    </div>
                    <div class="stca__badge-wrapper" data-content="score-board">
                        <div class="stca__badge">
                            <div class="stca__badge-left">Time Period</div>
                            <div class="stca__badge-right">
                                <div class="form-group cs-form-group mb-0">
                                    <select name="" id="year_dropdown" class="form-select border-0 bg-transparent">
                                        @if(isset($financialyears) && count($financialyears) > 0)
                                        @foreach($financialyears as $year)
                                        <option value="{{$year->reporting_year_base}}" {{$selected_year == $year->reporting_year_base?'Selected':''}}>{{$year->reporting_year}}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>
                        
                    </div>
                </div>
                <div class="sidebar-table__table-content-area" data-toggle-tab>
                    <div class="st__action-wrapper">
                        <nav class="cs-tabs-nav">
                            <button class="btn active" data-toggle-tab-btn="1">
                                Districts
                            </button>
                        </nav>
                        <span style="color: #000000;">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                            </svg>
                            These are the raw values provided from the source.
                        </span>
                    </div>
                    <div>
                        <div data-toggle-tab-content="1">
                            <div class="table-indicators" style="max-height: calc(100vh - 170px)">
                                <table class="table cs-table-2 cs-table-sticky-header table-striped mb-0" role="grid">
                                    <thead>
                                        <tr>
                                            <th style="min-width: 500px;">Indicator</th>
                                            <th>Unit</th>
                                            @if(isset($allDistricts) && count($allDistricts) > 0)
                                            @foreach($allDistricts as $district)
                                            <th>{{$district['district_name']}}</th>
                                            @endforeach
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @if(isset($goal_dif_indicator_data) && count($goal_dif_indicator_data) > 0)
                                        @foreach($goal_dif_indicator_data as $indicator)
                                        <tr>
                                            <td>
                                                {{$indicator['indicator_number']}}: {{$indicator['indicator_name']}}
                                            </td>
                                            <td>{{$indicator['unit']}}</td>
                                            @foreach($allDistricts as $district)
                                            @if(in_array($district->id, array_keys($indicator)))
                                            <td>
                                                <span>
                                                    @if(!empty($indicator[$district->id]['comment']))
                                                        <span>
                                                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                                            <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                        </svg>
                                                        {{$indicator[$district->id]['comment']}}
                                                        </span>
                                                    @else 
                                                        @if(!empty($indicator[$district->id]['value']))
                                                            {{$indicator[$district->id]['value']}}
                                                        @else
                                                            N/A
                                                        @endif
                                                    @endif
                                                </span>
                                            </td>
                                            @else
                                            <td><span>N/A</span></td>
                                            @endif
                                            @endforeach
                                        </tr>
                                        @endforeach
                                        @else
                                        <tr>
                                            <td colspan="21" class="text">No data available</td>
                                        </tr>
                                        @endif
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
            @endif
        </div>
    </div>
</div>
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<script>
    //#endregion
    $(document).ready(function() {
        $('#year_dropdown').on('change', function() {
            var year = $(this).val();
            var goal_id = $('#goal_id').val();
            var utif_years = $('#utif_years').val(); // get the selected value of the dropdown
            $('.loader').show();
            $.ajax({
                url: "{{ route('public.dashboard.goal_sdg_indicators_data') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    goal_id: goal_id,
                    year: year,
                    utif_year: utif_years,
                    area: 'district_index'
                },
                success: function(response) {
                    $('#goal_indicator_score').html(response);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                }
            });
        });

        $('#utif_years').on('change', function() {
            var utif_years = $(this).val();
            var goal_id = $('#goal_id').val();
            var dif_year = $('#year_dropdown').val(); // get the selected value of the dropdown
            $('.loader').show();
            $.ajax({
                url: "{{ route('public.dashboard.goal_sdg_indicators_data') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    goal_id: goal_id,
                    utif_year: utif_years,
                    year: dif_year
                },
                success: function(response) {
                    $('#goal_indicator_score').html(response);
                    let clickedTab = 2;
                    $('[data-toggle-tab-btn]').removeClass("active");
                    $('[data-toggle-tab-btn="2"]').addClass("active");
                    $('[data-toggle-tab-content]').addClass("d-none");
                    $('[data-toggle-tab-content="' + clickedTab + '"]').removeClass("d-none");

                    if (clickedTab == 2) {
                        $('[data-content="know-calculation-btn"]').addClass("d-none");
                        $('[data-content="score-board"]').addClass("d-none");
                        $('[data-content="ut-score-board"]').removeClass("d-none");
                    } else {
                        $('[data-content="know-calculation-btn"]').removeClass("d-none");
                        $('[data-content="score-board"]').removeClass("d-none");
                        $('[data-content="ut-score-board"]').addClass("d-none");
                    }
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');

                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                }
            });
        });
    });
</script>