<div class="modal-dialog modal-fullscreen">
    <div id="loading">
        <div class="loader simple-loader">
            <div class="loader-body">
                <img src="{{asset('assets/images/sdg-loader.gif')}}" alt="Loading..." />
            </div>
        </div>
    </div>
    <div class="modal-content">
        <div class="modal-header">
            <h1 class="modal-title fs-5" id="indicator4Label">
                @if(isset($district_data->district_name) && !empty($district_data->district_name))
                {{$district_data->district_name}} -
                @endif
                Goal wise Score
            </h1>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="colored-strips"></div>
        <div class="modal-body">
            <div class="gws__wrapper">
                <div class="gws__goals-scale">
                    <div class="gws__goals-scale-body">

                        @if((isset($datagoal) && !empty($datagoal)) && (isset($district_data->id) && !empty($district_data->id)))
                        @foreach($datagoal as $goal)
                        @php
                        $goal_id = $goal['goal_id'];
                        @endphp
                        <img role="button" src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal['goal_name']}}" data-bs-target="#division-district-goal-indicators" data-bs-toggle="modal" onclick="showGoalIndicatorOfdivisionDistrict('{{$goal_id}}','{{$district_data->id}}')" />
                        @endforeach
                        @endif
                    </div>
                </div>
                <div class="gws__sidebar-table">
                    @if(isset($district_data->district_name) && !empty($district_data->district_name))
                    @php
                    $image = asset('assets/images/big-districts/dist_'.$district_data->id.'.jpg');
                    @endphp
                    @else
                    @php
                    $image = '';
                    @endphp
                    @endif
                    <div class="gws__sidebar modal-columns-height" style="background-image: url({{$image}});">
                        <div class="gws__badge-container">
                            <div class="gws__badge">
                                <h6>Overall Composite Score</h6>
                                <div class="gws__badge-value">
                                    @php $baseyear = explode('-', $time_period)[0]; @endphp
                                    @if($composite_score!=0)
                                    @if(in_array($district_data->id, array_keys($composite_score)))
                                    @if(isset($composite_score) && isset($composite_score[$district_data->id]['year'][$baseyear]['score']) && $composite_score[$district_data->id]['year'][$baseyear]['score'])
                                    {{$composite_score[$district_data->id]['year'][$baseyear]['score']}}
                                    @if($composite_score[$district_data->id]['year'][$baseyear]['trend'] =='up')
                                    <img src="{{asset('assets/images/arrow-up.svg')}}" style="width: 20px;" />
                                    @elseif($composite_score[$district_data->id]['year'][$baseyear]['trend'] =='down')
                                    <img src="{{asset('assets/images/arrow-down.svg')}}" style="width: 20px;" />
                                    @elseif($composite_score[$district_data->id]['year'][$baseyear]['trend'] =='straight')
                                    <img src="{{asset('assets/images/arrow-straight.svg')}}" style="width: 20px;" />
                                    @endif
                                    @else
                                    0
                                    @endif
                                    @else
                                    0
                                    @endif
                                    @else
                                    0
                                    @endif
                                </div>
                            </div>
                            <div class="gws__badge">
                                <h6>Time Period</h6>
                                <div class="gws__badge-value">{{$time_period}}</div>
                            </div>
                        </div>
                    </div>
                    <div class="gws__table-wrapper">
                        <div class="table-responsive modal-columns-height">
                            <table class="table cs-table-2 cs-table-sticky-header table-striped mb-0" role="grid">
                                <colgroup>
                                    <col style="width: 100%" />
                                    <col style="width: 120px; min-width: 120px" />
                                    <col style="width: 120px; min-width: 120px" />
                                    <col style="width: 120px; min-width: 120px" />
                                </colgroup>
                                <thead>
                                    <tr>
                                        <th>Goal</th>
                                        @if(isset($reportingYears) && !empty($reportingYears))
                                        @foreach($reportingYears as $year)
                                        <th>{{$year['id']}}</th>
                                        @endforeach
                                        @endif
                                    </tr>
                                </thead>
                                <tbody>
                                    @if(isset($division_district_goals) && count($division_district_goals) > 0)
                                    @foreach($division_district_goals as $division_district_goal)
                                    @if(isset($division_district_goal) && count($division_district_goal) > 0)
                                    @if(isset($datagoal) && !empty($datagoal))
                                    @foreach($datagoal as $goal)
                                    @if(in_array($goal['goal_id'], array_keys($division_district_goal)))
                                    <tr>
                                        <td>
                                            @php
                                            $goal_id = $goal['goal_id'];
                                            @endphp
                                            <div class="avatar-text" role="button" data-bs-target="#division-district-goal-indicators" data-bs-toggle="modal" onclick="showGoalIndicatorOfdivisionDistrict('{{$goal_id}}','{{$district_data->id}}')">
                                                <img src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal['goal_name']}}" />
                                                <p>{{$goal['goal_name']}}</p>
                                            </div>
                                        </td>
                                        @foreach($reportingYears as $year)
                                        @if(in_array($year['year'], array_keys($division_district_goal[$goal['goal_id']]['year'])))
                                        @if(isset($division_district_goal[$goal['goal_id']]['year'][$year['year']]) && !empty($division_district_goal[$goal['goal_id']]['year'][$year['year']]))
                                        <td>
                                            <div class="cs-tag cs-tag-{{$division_district_goal[$goal['goal_id']]['year'][$year['year']]['score_category_name']}}">{{$division_district_goal[$goal['goal_id']]['year'][$year['year']]['score']}}</div>
                                            @if($division_district_goal[$goal['goal_id']]['year'][$year['year']]['trend']=='up')
                                            <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Improved" />
                                            @elseif($division_district_goal[$goal['goal_id']]['year'][$year['year']]['trend']=='down')
                                            <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Declined" />
                                            @elseif($division_district_goal[$goal['goal_id']]['year'][$year['year']]['trend']=='straight')
                                            <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                                            @endif
                                        </td>
                                        @else
                                        <td>
                                            <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                        </td>
                                        @endif
                                        @else
                                        <td>
                                            <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                        </td>
                                        @endif
                                        @endforeach
                                    </tr>
                                    @else
                                    <tr>
                                        <td>
                                            @php
                                            $goal_id = $goal['goal_id'];
                                            @endphp
                                            <div class="avatar-text" role="button" data-bs-target="#division-district-goal-indicators" data-bs-toggle="modal" onclick="showGoalIndicatorOfdivisionDistrict('{{$goal_id}}','{{$district_data->id}}')">
                                                <img src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal['goal_name']}}" />
                                                <p>{{$goal['goal_name']}}</p>
                                            </div>
                                        </td>
                                        @foreach($reportingYears as $year)
                                        <td>
                                            <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                        </td>
                                        @endforeach
                                    </tr>
                                    @endif
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="{{count($reportingYears)+1}}" class="text-center">No data found</td>
                                    </tr>
                                    @endif
                                    @else
                                    <tr>
                                        <td colspan="{{count($reportingYears)+1}}" class="text-center">No data found</td>
                                    </tr>
                                    @endif
                                    @endforeach
                                    @else
                                    <tr>
                                        <td colspan="4" class="text-center">No data found</td>
                                    </tr>
                                    @endif
                                </tbody>
                            </table>
                        </div>
                        <div class="trend-score-chart">
                            <p class="trend-score-chart__title">Trend:</p>
                            <div class="trend-score-chart__list">
                                <div class="trend-score-chart__list-item">
                                    <p class="trend-score-chart__item-title">Improved</p>
                                    <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Improved" />
                                </div>
                                <div class="trend-score-chart__list-item">
                                    <p class="trend-score-chart__item-title">No Change</p>
                                    <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                                </div>
                                <div class="trend-score-chart__list-item">
                                    <p class="trend-score-chart__item-title">Dropped</p>
                                    <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Dropped" />
                                </div>
                                <div class="trend-score-chart__list-item">
                                    <p class="trend-score-chart__item-title">No Data</p>
                                    <img src="{{asset('assets/images/dual-circle.svg')}}" alt="Dropped" />
                                </div>
                            </div>
                        </div>
                        <div class="gws-chart-area">
                            <div class="color-indicator-charts mt-3">
                                <div class="color-indicator__item">
                                    <div class="ci__color ci__color-skyblue"></div>
                                    <div class="ci__title">Achiever (100)</div>
                                </div>
                                <div class="color-indicator__item">
                                    <div class="ci__color ci__color-green"></div>
                                    <div class="ci__title">Front Runner (65 - 99)</div>
                                </div>
                                <div class="color-indicator__item">
                                    <div class="ci__color ci__color-yellow"></div>
                                    <div class="ci__title">Performer (50 - 64)</div>
                                </div>
                                <div class="color-indicator__item">
                                    <div class="ci__color ci__color-red"></div>
                                    <div class="ci__title">Aspirant (0 - 49)</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>