<div class="modal-dialog modal-fullscreen">
    <div id="loading">
        <div class="loader simple-loader">
            <div class="loader-body">
                <img src="{{asset('assets/images/sdg-loader.gif')}}" alt="Loading..." />
            </div>
        </div>
    </div>
    <div class="modal-content">
        <div class="modal-header" style="padding-right: 65px; position: relative;">
            <h1 class="modal-title fs-5" id="indicator1Label">
                @if(isset($district_data) && !empty($district_data))
                {{$district_data->district_name}} - {{$goal_data['goal_name']}} - Performance by Indicator
                @endif
            </h1>
            <div class="district-disputed-icon-div">
                <span class="district-disputed-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                        <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                    </svg>
                    These are the raw values provided from the source.
                </span>
            </div>
            <button type="button" class="btn-close" data-bs-target="#division-district-model" data-bs-toggle="modal" style="position: absolute; right: 20px;"></button>
        </div>
        <div class="colored-strips"></div>
        <div class="modal-body">
            @if(isset($goal_data) && !empty($goal_data))
            @php
            $goal_id = $goal_data['goal_id'];
            @endphp
            <input type="hidden" value="{{$goal_id}}" id="goal_id" />
            <input type="hidden" value="{{$district_data->id}}" id="district_id" />
            @if($goal_data['goal_id'] == '14' || $goal_data['goal_id'] == '17')
            <div class="invalid-indicator-wrapper">
                <div class="ii__image">
                    @php
                    $goal_id = $goal_data['goal_id'];
                    $goal_name = $goal_data['goal_name'];
                    @endphp
                    <img src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal_name}}" />
                </div>
                <h2 class="invalid-indicator-msg">
                    @if($goal_data['goal_id'] == '14')
                    Goal 14 Life under Water: <br>This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                    @elseif($goal_data['goal_id'] == '17')
                    Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                    @endif
                </h2>
            </div>
            @else
            <div class="sidebar-table-wrapper">
                <div class="sidebar-table__content-area">
                    <div class="stca__img-area">
                        @if(isset($goal_data) && !empty($goal_data))
                        @php
                        $goal_id = $goal_data['goal_id'];
                        $goal_name = $goal_data['goal_name'];
                        @endphp
                        <img src="{{asset('assets/images/goals/goal_'.$goal_id.'.jpg')}}" alt="{{$goal_name}}" />
                        @endif
                    </div>
                    <div class="stca__badge-wrapper">
                        <div class="stca__badge">
                            <div class="stca__badge-left">Score</div>
                            <div class="stca__badge-right">
                                @if(isset($score) && !empty($score))
                                @if(isset($goal_data) && !empty($goal_data))
                                @php
                                $goal_id = $goal_data['goal_id'];
                                @endphp
                                @if(in_array($district_data->id, array_keys($score)) && in_array($goal_id, array_keys($score[$district_data->id])) && in_array('year', array_keys($score[$district_data->id][$goal_id])) && in_array($time_period, array_keys($score[$district_data->id][$goal_id]['year'])))
                                {{$score[$district_data->id][$goal_id]['year'][$time_period]['score']}}
                                @endif
                                <div class="stca-tag">
                                    @if(in_array($district_data->id, array_keys($score)) && in_array($goal_id, array_keys($score[$district_data->id])) && in_array('year', array_keys($score[$district_data->id][$goal_id])) && in_array($time_period, array_keys($score[$district_data->id][$goal_id]['year'])))
                                    @if($score[$district_data->id][$goal_id]['year'][$time_period]['trend']=='up')
                                    <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Improved" />
                                    @elseif($score[$district_data->id][$goal_id]['year'][$time_period]['trend']=='down')
                                    <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Dropped" />
                                    @else
                                    <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                                    @endif
                                    @endif
                                </div>
                                @endif
                                @endif
                            </div>
                        </div>
                        <div class="stca__badge">
                            <div class="stca__badge-left">Time Period</div>
                            <div class="stca__badge-right">
                                <div class="form-group cs-form-group mb-0">
                                    <select name="" id="dif_years" class="form-select border-0 bg-transparent">
                                        @if(!empty($pairYears))
                                        @foreach($pairYears as $year)
                                        @php
                                            $filter_year = $year;
                                            $filter_year = explode('-', $filter_year);
                                            $filter_year = $filter_year[0];
                                        @endphp
                                        <option value="{{$year}}" {{$selectedPair == $year?'Selected':''}}>{{$filter_year}}-{{$filter_year+2}}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div>
                            <span class="district-disputed-icon-mobile">
                            <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                            </svg>
                            These are the raw values provided from the source.
                            </span>
                        </div>
                    </div>
                </div>
                <div class="sidebar-table__table-content-area">
                    <div class="table-responsive-district-divsion" style="max-height: calc(100vh - 235px)">
                        <table class="table cs-table-2 cs-table-sticky-header table-striped mb-0" role="grid">
                            <colgroup>
                                <col style="width: 100%" />
                                <col style="width: 50px; min-width: 50px" />
                                <col style="width: 150px; min-width: 150px" />
                                <col style="width: 160px; min-width: 160px" />
                                <col style="width: 130px; min-width: 130px" />
                                <col style="width: 130px; min-width: 130px" />
                            </colgroup>
                            <thead>
                                <tr>
                                    <th>Indicator</th>
                                    <th>Unit</th>
                                    <th>Baseline Year</th>
                                    <th>Baseline Value</th>
                                    @if(isset($diflastThreeYears) && count($diflastThreeYears) > 0)
                                    @foreach(array_slice($diflastThreeYears, 1) as $year)
                                    <th>{{$year}}</th>
                                    @endforeach
                                    @endif
                                </tr>
                            </thead>
                            <tbody>
                                @if(isset($division_district_goal_indicators) && count($division_district_goal_indicators) > 0)
                                    @foreach($division_district_goal_indicators as $indicator)
                                    <tr>
                                        <td>
                                            <p>
                                                {{ $indicator['indicator_number'] }}: {{ $indicator['indicator_name'] }}
                                            </p>
                                        </td>
                                        <td>{{$indicator['unit']}}</td>
                                        <td>{{$indicator['baseline_year']}}</td>
                                        <td>{{$indicator['baseline_value']}}</td>
                                        @if(isset($dif_years) && count($dif_years) > 0)
                                            @foreach(array_slice($dif_years, 1) as $year)
                                                @if(in_array($year, array_keys($indicator)))
                                                    @if(isset($indicator[$year]))
                                                    <td>
                                                        <span>
                                                            @if(isset($indicator[$year]['comment']) && !empty($indicator[$year]['comment']))
                                                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-info-circle-fill" viewBox="0 0 16 16" style="color: #136a9f;">
                                                                    <path d="M8 16A8 8 0 1 0 8 0a8 8 0 0 0 0 16m.93-9.412-1 4.705c-.07.34.029.533.304.533.194 0 .487-.07.686-.246l-.088.416c-.287.346-.92.598-1.465.598-.703 0-1.002-.422-.808-1.319l.738-3.468c.064-.293.006-.399-.287-.47l-.451-.081.082-.381 2.29-.287zM8 5.5a1 1 0 1 1 0-2 1 1 0 0 1 0 2"/>
                                                                </svg>
                                                                {{ $indicator[$year]['comment'] }}
                                                            @else
                                                                @if(isset($indicator[$year]['score']) && !empty($indicator[$year]['score']))
                                                                    {{ $indicator[$year]['score'] }}
                                                                    @if(isset($indicator[$year]['trend']))
                                                                    @if($indicator[$year]['trend'] == 'up')
                                                                        <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Increased" />
                                                                    @elseif($indicator[$year]['trend'] == 'down')
                                                                        <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Dropped" />
                                                                    @else
                                                                        <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                                                                    @endif
                                                        @endif
                                                                @else
                                                                    <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                                                @endif
                                                            @endif
                                                        </span>
                                                    </td>
                                                    @else
                                                    <td>
                                                        <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                                    </td>
                                                    @endif
                                                @else
                                                <td>
                                                    <img src="{{asset('assets/images/dual-circle.svg')}}" alt="No Data" />
                                                </td>
                                                @endif
                                            @endforeach
                                        @else
                                        <td colspan="{{count($reportingYears)}}">No data available</td>
                                        @endif
                                    </tr>
                                    @endforeach
                                @else
                                <tr>
                                    <td colspan="9" class="text-center">No data available</td>
                                </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                    <div class="trend-score-chart">
                        <p class="trend-score-chart__title">Trend:</p>
                        <div class="trend-score-chart__list">
                            <div class="trend-score-chart__list-item">
                                <p class="trend-score-chart__item-title">Improved</p>
                                <img src="{{asset('assets/images/arrow-up.svg')}}" alt="Improved" />
                            </div>
                            <div class="trend-score-chart__list-item">
                                <p class="trend-score-chart__item-title">No Change</p>
                                <img src="{{asset('assets/images/arrow-straight.svg')}}" alt="No Change" />
                            </div>
                            <div class="trend-score-chart__list-item">
                                <p class="trend-score-chart__item-title">Dropped</p>
                                <img src="{{asset('assets/images/arrow-down.svg')}}" alt="Dropped" />
                            </div>
                            <div class="trend-score-chart__list-item">
                                <p class="trend-score-chart__item-title">No Data</p>
                                <img src="{{asset('assets/images/dual-circle.svg')}}" alt="Dropped" />
                            </div>
                        </div>
                    </div>
                    <div class="gws-chart-area">
                        <div class="color-indicator-charts mt-3">
                            <div class="color-indicator__item">
                                <div class="ci__color ci__color-skyblue"></div>
                                <div class="ci__title">Achiever (100)</div>
                            </div>
                            <div class="color-indicator__item">
                                <div class="ci__color ci__color-green"></div>
                                <div class="ci__title">Front Runner (65 - 99)</div>
                            </div>
                            <div class="color-indicator__item">
                                <div class="ci__color ci__color-yellow"></div>
                                <div class="ci__title">Performer (50 - 64)</div>
                            </div>
                            <div class="color-indicator__item">
                                <div class="ci__color ci__color-red"></div>
                                <div class="ci__title">Aspirant (0 - 49)</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
            @endif
        </div>
    </div>
</div>
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<script>
    $(document).ready(function() {
        $('#dif_years').change(function() {
            var dif_year = $(this).val();
            var goal_id = $('#goal_id').val();
            var district_id = $('#district_id').val();
            $('.loader').show();
            $.ajax({
                url: "{{ route('public.dashboard.division_district_goal_indicators') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    dif_year: dif_year,
                    goal_id: goal_id,
                    district_id: district_id
                },
                success: function(response) {
                    $('#division-district-goal-indicators').html(response);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                },
                error: function(xhr) {
                    console.log(xhr.responseText);
                    // Hide loader and remove blur from page
                    $('.loader').hide();
                    $('body').removeClass('blur');
                }
            });

        });
    });
</script>