@section('sidebar')
<div class="sidebar-header d-flex align-items-center justify-content-start">
    <a href="{{url('dashboard')}}" class="navbar-brand">
        <!--Logo start-->
        <div class="logo-main">
            <div class="logo-normal sdg-main-logo">
                <img src="{{asset('assets/images/sdg-wheel-logo.png')}}" alt="SDG Wheel" />
            </div>
            <div class="logo-mini sdg-main-logo-mini">
                <img src="{{asset('assets/images/sdg-wheel-logo.png')}}" alt="SDG Wheel" />
            </div>
        </div>
        <!--logo End-->

        <h4 class="logo-title sdg-main-logo-title">
            <div class="logo-title__sm">SDG</div>
            <div class="logo-title__md">JAMMU & KASHMIR</div>
        </h4>
    </a>
    <div class="sidebar-toggle" data-toggle="sidebar" data-active="true">
        <i class="icon">
            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M4.25 12.2744L19.25 12.2744" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M10.2998 18.2988L4.2498 12.2748L10.2998 6.24976" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
            </svg>
        </i>
    </div>
</div>
<div class="sidebar-body pt-0 data-scrollbar">
    <div class="sidebar-list">
        <!-- Sidebar Menu Start -->
        <ul class="navbar-nav iq-main-menu" id="sidebar-menu">
            @can('View Dashboard')
            <li class="nav-item">
                <a class="nav-link @if(request()->routeIs('graph_dashboard') || request()->routeIs('graph_dashboard.filter') || request()->routeIs('utif_indicator_listing') || request()->routeIs('utif_indicator_listing.filter') || request()->routeIs('dif_indicator_listing') || request()->routeIs('dif_indicator_listing.filter'))active @endif" aria-current="page" href="{{route('graph_dashboard')}}">
                    <i class="icon">
                        <svg width="74" height="74" viewBox="0 0 74 74" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-20">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M0.527733 70.8299C0.527733 70.083 0.824415 69.3668 1.35251 68.8387C1.88061 68.3106 2.59686 68.0139 3.3437 68.0139H70.927C71.6739 68.0139 72.3901 68.3106 72.9182 68.8387C73.4463 69.3668 73.743 70.083 73.743 70.8299C73.743 71.5767 73.4463 72.293 72.9182 72.8211C72.3901 73.3492 71.6739 73.6459 70.927 73.6459H3.3437C2.59686 73.6459 1.88061 73.3492 1.35251 72.8211C0.824415 72.293 0.527733 71.5767 0.527733 70.8299Z" fill="currentColor" />
                            <path d="M20.2395 34.222H8.97566C7.42044 34.222 6.15969 35.4828 6.15969 37.038V70.8297C6.15969 72.3849 7.42044 73.6456 8.97566 73.6456H20.2395C21.7948 73.6456 23.0555 72.3849 23.0555 70.8297V37.038C23.0555 35.4828 21.7948 34.222 20.2395 34.222Z" fill="currentColor" />
                            <path d="M42.7674 0.430664H31.5035C29.9483 0.430664 28.6875 1.69142 28.6875 3.24664V70.8299C28.6875 72.3852 29.9483 73.6459 31.5035 73.6459H42.7674C44.3226 73.6459 45.5833 72.3852 45.5833 70.8299V3.24664C45.5833 1.69142 44.3226 0.430664 42.7674 0.430664Z" fill="currentColor" />
                            <path d="M65.2951 17.3263H54.0312C52.476 17.3263 51.2152 18.587 51.2152 20.1423V70.8297C51.2152 72.385 52.476 73.6457 54.0312 73.6457H65.2951C66.8503 73.6457 68.1111 72.385 68.1111 70.8297V20.1423C68.1111 18.587 66.8503 17.3263 65.2951 17.3263Z" fill="currentColor" />
                        </svg>
                    </i>
                    <span class="item-name">Dashboard</span>
                </a>
            </li>
            @endcan
            @can('View Indicator')
            <li class="nav-item">
                <a class="nav-link graph_dashboard @if(request()->routeIs('indicators.index') || request()->routeIs('indicators.create') ||request()->routeIs('indicators.edit') || request()->routeIs('indicators.filter')) active @endif" aria-current="page" href="{{url('indicators')}}">
                    <i class="icon">
                        <svg width="91" height="114" viewBox="0 0 91 114" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-20">
                            <path d="M51.5834 40.3889H82.559L51.5834 9.41325V40.3889ZM12.1598 0.965332H57.2153L91.007 34.757V102.34C91.007 105.328 89.8202 108.193 87.7078 110.305C85.5955 112.417 82.7304 113.604 79.7431 113.604H12.1598C9.17239 113.604 6.30738 112.417 4.19499 110.305C2.0826 108.193 0.895874 105.328 0.895874 102.34V12.2292C0.895874 5.97776 5.9083 0.965332 12.1598 0.965332ZM17.7917 102.34H29.0556V68.5486H17.7917V102.34ZM40.3195 102.34H51.5834V57.2848H40.3195V102.34ZM62.8472 102.34H74.1111V79.8125H62.8472V102.34Z" fill="currentColor" />
                        </svg>
                    </i>
                    <span class="item-name">Indicators</span>
                </a>
            </li>
            @endcan
            @can('View Indicator Data Entry')
            <li class="nav-item">
                <a class="nav-link @if(request()->routeIs('indicator_data_entries') || request()->routeIs('indicator_data_entries.filter'))active @endif" aria-current="page" href="{{route('indicator_data_entries')}}">
                    <i class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" fill="currentColor" class="bi bi-database-add" viewBox="0 0 16 16">
                            <path d="M12.5 16a3.5 3.5 0 1 0 0-7 3.5 3.5 0 0 0 0 7m.5-5v1h1a.5.5 0 0 1 0 1h-1v1a.5.5 0 0 1-1 0v-1h-1a.5.5 0 0 1 0-1h1v-1a.5.5 0 0 1 1 0" />
                            <path d="M12.096 6.223A5 5 0 0 0 13 5.698V7c0 .289-.213.654-.753 1.007a4.5 4.5 0 0 1 1.753.25V4c0-1.007-.875-1.755-1.904-2.223C11.022 1.289 9.573 1 8 1s-3.022.289-4.096.777C2.875 2.245 2 2.993 2 4v9c0 1.007.875 1.755 1.904 2.223C4.978 15.71 6.427 16 8 16c.536 0 1.058-.034 1.555-.097a4.5 4.5 0 0 1-.813-.927Q8.378 15 8 15c-1.464 0-2.766-.27-3.682-.687C3.356 13.875 3 13.373 3 13v-1.302c.271.202.58.378.904.525C4.978 12.71 6.427 13 8 13h.027a4.6 4.6 0 0 1 0-1H8c-1.464 0-2.766-.27-3.682-.687C3.356 10.875 3 10.373 3 10V8.698c.271.202.58.378.904.525C4.978 9.71 6.427 10 8 10q.393 0 .774-.024a4.5 4.5 0 0 1 1.102-1.132C9.298 8.944 8.666 9 8 9c-1.464 0-2.766-.27-3.682-.687C3.356 7.875 3 7.373 3 7V5.698c.271.202.58.378.904.525C4.978 6.711 6.427 7 8 7s3.022-.289 4.096-.777M3 4c0-.374.356-.875 1.318-1.313C5.234 2.271 6.536 2 8 2s2.766.27 3.682.687C12.644 3.125 13 3.627 13 4c0 .374-.356.875-1.318 1.313C10.766 5.729 9.464 6 8 6s-2.766-.27-3.682-.687C3.356 4.875 3 4.373 3 4" />
                        </svg>
                    </i>
                    <span class="item-name">Indicators Data Entries</span>
                </a>
            </li>
            @endcan
            @can('View Import Data')
            <li class="nav-item">
                <a class="nav-link {{ request()->routeIs('import_export') ? 'active' : '' }}" aria-current="page" href="{{route('import_export')}}">
                    <i class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-arrow-up icon-20" viewBox="0 0 16 16">
                            <path d="M8.5 11.5a.5.5 0 0 1-1 0V7.707L6.354 8.854a.5.5 0 1 1-.708-.708l2-2a.5.5 0 0 1 .708 0l2 2a.5.5 0 0 1-.708.708L8.5 7.707z" />
                            <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2M9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5z" />
                        </svg>
                    </i>
                    <span class="item-name">Import Raw Data</span>
                </a>
            </li>
            @endcan
            @can('View Export Data')
            <li class="nav-item">
                <a class="nav-link @if(request()->routeIs('export_report') || request()->routeIs('export_report.export_data')) active @endif" aria-current="page" href="{{route('export_report')}}">
                    <i class="icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-file-earmark-arrow-down icon-20" viewBox="0 0 16 16">
                            <path d="M8.5 6.5a.5.5 0 0 0-1 0v3.793L6.354 9.146a.5.5 0 1 0-.708.708l2 2a.5.5 0 0 0 .708 0l2-2a.5.5 0 0 0-.708-.708L8.5 10.293z" />
                            <path d="M14 14V4.5L9.5 0H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h8a2 2 0 0 0 2-2M9.5 3A1.5 1.5 0 0 0 11 4.5h2V14a1 1 0 0 1-1 1H4a1 1 0 0 1-1-1V2a1 1 0 0 1 1-1h5.5z" />
                        </svg>
                    </i>
                    <span class="item-name">Export Report</span>
                </a>
            </li>
            @endcan
            @can('View District')
            <li class="nav-item">
                @php
                $user_area_management = 'false';
                @endphp
                @if(request()->routeIs('districts.index')
                || request()->routeIs('districts.create')
                || request()->routeIs('districts.edit')
                ||request()->routeIs('users.index')
                || request()->routeIs('users.create')
                || request()->routeIs('users.edit')
                ||request()->routeIs('roles.index')
                || request()->routeIs('roles.create')
                || request()->routeIs('roles.edit')
                || request()->routeIs('roles.give-permissions')
                ||request()->routeIs('permissions.index')
                || request()->routeIs('permissions.create')
                || request()->routeIs('permissions.edit')
                || request()->routeIs('departments.index')
                || request()->routeIs('departments.create')
                || request()->routeIs('departments.edit')
                || request()->routeIs('targets.index')
                || request()->routeIs('targets.create')
                || request()->routeIs('targets.edit')
                || request()->routeIs('dashboard_input')
                )
                @php
                $user_area_management = 'true';
                @endphp
                @endif
                <a class="nav-link collapsed" data-bs-toggle="collapse" href="#user-area-management" role="button" aria-expanded="{{$user_area_management}}" aria-controls="user-area-management">
                    <i class="icon">
                        <svg width="119" height="107" viewBox="0 0 119 107" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-20">
                            <path fill-rule="evenodd" clip-rule="evenodd" d="M38.0161 21.5776C38.0161 15.9763 40.2412 10.6044 44.2019 6.64367C48.1627 2.68294 53.5346 0.457825 59.1359 0.457825C64.7372 0.457825 70.1091 2.68294 74.0698 6.64367C78.0306 10.6044 80.2557 15.9763 80.2557 21.5776C80.2557 27.1789 78.0306 32.5508 74.0698 36.5115C70.1091 40.4723 64.7372 42.6974 59.1359 42.6974C53.5346 42.6974 48.1627 40.4723 44.2019 36.5115C40.2412 32.5508 38.0161 27.1789 38.0161 21.5776ZM80.2557 38.4734C80.2557 33.9924 82.0358 29.6949 85.2043 26.5263C88.3729 23.3577 92.6704 21.5776 97.1515 21.5776C101.633 21.5776 105.93 23.3577 109.099 26.5263C112.267 29.6949 114.047 33.9924 114.047 38.4734C114.047 42.9545 112.267 47.252 109.099 50.4206C105.93 53.5892 101.633 55.3693 97.1515 55.3693C92.6704 55.3693 88.3729 53.5892 85.2043 50.4206C82.0358 47.252 80.2557 42.9545 80.2557 38.4734ZM4.22444 38.4734C4.22444 33.9924 6.00453 29.6949 9.17312 26.5263C12.3417 23.3577 16.6392 21.5776 21.1203 21.5776C25.6013 21.5776 29.8988 23.3577 33.0674 26.5263C36.236 29.6949 38.0161 33.9924 38.0161 38.4734C38.0161 42.9545 36.236 47.252 33.0674 50.4206C29.8988 53.5892 25.6013 55.3693 21.1203 55.3693C16.6392 55.3693 12.3417 53.5892 9.17312 50.4206C6.00453 47.252 4.22444 42.9545 4.22444 38.4734ZM27.0901 68.7057C30.5247 63.3206 35.2616 58.8885 40.8628 55.8191C46.4641 52.7498 52.7488 51.1423 59.1359 51.1453C64.4852 51.1404 69.7753 52.2654 74.6597 54.4465C79.5442 56.6277 83.9129 59.8159 87.4799 63.8023C91.0469 67.7888 93.7317 72.4837 95.3586 77.5797C96.9855 82.6756 97.5178 88.0577 96.9206 93.3736C96.8476 94.034 96.6198 94.6679 96.2558 95.2237C95.8917 95.7796 95.4017 96.2417 94.8255 96.5725C83.9646 102.804 71.6576 106.075 59.1359 106.057C46.6139 106.076 34.3065 102.806 23.4463 96.5725C22.8701 96.2417 22.38 95.7796 22.016 95.2237C21.652 94.6679 21.4242 94.034 21.3512 93.3736C20.4053 84.7377 22.4295 76.0372 27.0901 68.7057Z" fill="currentColor" />
                            <path d="M20.1741 63.8397C14.6196 72.4136 12.0317 82.5733 12.8075 92.7597C9.42555 92.2469 6.09932 91.4173 2.87275 90.2816L2.22507 90.0564C1.64721 89.8513 1.14121 89.483 0.768362 88.9962C0.395514 88.5094 0.171814 87.9249 0.124357 87.3136L0.068038 86.6321C-0.159465 83.8047 0.184934 80.9604 1.08068 78.269C1.97643 75.5775 3.40518 73.0941 5.28166 70.9669C7.15814 68.8397 9.44391 67.1123 12.0026 65.8878C14.5612 64.6632 17.3403 63.9667 20.1741 63.8397ZM105.464 92.7597C106.24 82.5733 103.652 72.4136 98.0976 63.8397C100.931 63.9667 103.71 64.6632 106.269 65.8878C108.828 67.1123 111.114 68.8397 112.99 70.9669C114.867 73.0941 116.295 75.5775 117.191 78.269C118.087 80.9604 118.431 83.8047 118.204 86.6321L118.147 87.3136C118.099 87.924 117.875 88.5072 117.502 88.9929C117.129 89.4786 116.624 89.846 116.047 90.0507L115.399 90.276C112.206 91.4024 108.888 92.2415 105.464 92.7597Z" fill="currentColor" />
                        </svg>
                    </i>
                    <span class="item-name">Roles and Responsibilities</span>
                    <i class="right-icon">
                        <svg class="icon-18" xmlns="http://www.w3.org/2000/svg" width="18" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path>
                        </svg>
                    </i>
                </a>
                <ul class="sub-nav collapse" id="user-area-management" data-bs-parent="#sidebar-menu">
                    @can('View User')
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('users.index') || request()->routeIs('users.create') || request()->routeIs('users.edit')) active @endif" href="{{url('users')}}">
                            <i class="icon">
                                <svg width="89" height="94" viewBox="0 0 89 94" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-16">
                                    <path d="M44.5434 0.867676C38.9421 0.867676 33.5702 3.09279 29.6095 7.05352C25.6488 11.0142 23.4236 16.3861 23.4236 21.9875C23.4236 27.5888 25.6488 32.9607 29.6095 36.9214C33.5702 40.8821 38.9421 43.1072 44.5434 43.1072C50.1447 43.1072 55.5166 40.8821 59.4774 36.9214C63.4381 32.9607 65.6632 27.5888 65.6632 21.9875C65.6632 16.3861 63.4381 11.0142 59.4774 7.05352C55.5166 3.09279 50.1447 0.867676 44.5434 0.867676ZM22.0157 54.3711C16.4143 54.3711 11.0424 56.5962 7.08172 60.557C3.12099 64.5177 0.895874 69.8896 0.895874 75.4909V82.1817C0.895874 86.4281 3.97091 90.0438 8.16108 90.7253C32.2545 94.662 56.8323 94.662 80.9258 90.7253C82.9537 90.3951 84.7981 89.3544 86.1291 87.7891C87.4601 86.2239 88.1909 84.2363 88.191 82.1817V75.4909C88.191 69.8896 85.9659 64.5177 82.0051 60.557C78.0444 56.5962 72.6725 54.3711 67.0712 54.3711H65.1563C64.1144 54.3711 63.0781 54.5401 62.0926 54.8555L57.2153 56.4493C48.9812 59.1371 40.1057 59.1371 31.8716 56.4493L26.9943 54.8555C26.0068 54.5341 24.9747 54.3706 23.9361 54.3711H22.0157Z" fill="currentColor" />
                                </svg>
                            </i>
                            <span class="item-name">Users</span>
                        </a>
                    </li>
                    @endcan
                    @can('View Role')
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('roles.index') || request()->routeIs('roles.create') || request()->routeIs('roles.edit') || request()->routeIs('roles.give-permissions')) active @endif" href="{{url('roles')}}">
                            <i class="icon">
                                <svg width="113" height="96" viewBox="0 0 113 96" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-16">
                                    <path d="M79.3749 95.8742L77.6853 87.4263C76.559 86.957 75.5039 86.4651 74.5202 85.9508C73.5365 85.4364 72.5265 84.8018 71.4902 84.0472L63.3239 86.5815L57.692 77.0072L64.1687 71.3753C63.981 70.0612 63.8871 68.8409 63.8871 67.7145C63.8871 66.5881 63.981 65.3679 64.1687 64.0538L57.692 58.4218L63.3239 48.8475L71.4902 51.3819C72.5227 50.631 73.5327 49.9983 74.5202 49.4839C75.5077 48.9695 76.5627 48.4758 77.6853 48.0027L79.3749 39.5548H90.6388L92.3284 48.0027C93.4548 48.4721 94.5117 48.9883 95.4992 49.5515C96.4867 50.1147 97.4948 50.8187 98.5235 51.6635L106.69 48.8475L112.322 58.7034L105.845 64.3354C106.033 65.4617 106.127 66.6351 106.127 67.8553C106.127 69.0756 106.033 70.2489 105.845 71.3753L112.322 77.0072L106.69 86.5815L98.5235 84.0472C97.491 84.7981 96.4829 85.4326 95.4992 85.9508C94.5155 86.4689 93.4585 86.9607 92.3284 87.4263L90.6388 95.8742H79.3749ZM0.52774 90.2423V74.4729C0.52774 71.3753 1.3256 68.4654 2.92132 65.7433C4.51703 63.0212 6.72288 60.9562 9.53885 59.5482C14.326 57.1077 19.7233 55.0427 25.7307 53.3531C31.7381 51.6635 38.3556 50.8187 45.5833 50.8187H47.5545C48.1177 50.8187 48.6808 50.9126 49.244 51.1003C46.5219 57.8586 45.3955 64.57 45.8649 71.2345C46.3342 77.899 48.587 84.2349 52.6232 90.2423H0.52774ZM85.0069 78.9784C88.1044 78.9784 90.7571 77.8764 92.9648 75.6725C95.1725 73.4685 96.2745 70.8158 96.2708 67.7145C96.267 64.6132 95.165 61.9624 92.9648 59.7622C90.7646 57.562 88.112 56.4581 85.0069 56.4506C81.9018 56.4431 79.251 57.547 77.0546 59.7622C74.8581 61.9775 73.7543 64.6282 73.743 67.7145C73.7317 70.8008 74.8356 73.4535 77.0546 75.6725C79.2736 77.8914 81.9243 78.9934 85.0069 78.9784ZM45.5833 45.1868C39.3881 45.1868 34.0847 42.9809 29.673 38.5692C25.2614 34.1575 23.0555 28.8541 23.0555 22.659C23.0555 16.4639 25.2614 11.1604 29.673 6.74875C34.0847 2.33706 39.3881 0.131218 45.5833 0.131218C51.7784 0.131218 57.0818 2.33706 61.4935 6.74875C65.9052 11.1604 68.111 16.4639 68.111 22.659C68.111 28.8541 65.9052 34.1575 61.4935 38.5692C57.0818 42.9809 51.7784 45.1868 45.5833 45.1868Z" fill="currentColor" />
                                </svg>
                            </i>
                            <span class="item-name">Roles</span>
                        </a>
                    </li>
                    @endcan
                    @can('View District')
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('districts.index') || request()->routeIs('districts.create') || request()->routeIs('districts.edit')) active @endif" href="{{url('districts')}}">
                            <i class="icon">
                                <svg width="103" height="114" viewBox="0 0 103 114" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-16">
                                    <path d="M85.3749 79.5269C92.3867 82.5062 96.6388 86.4148 96.6388 90.7007C96.6388 100.033 76.4652 107.597 51.5833 107.597C26.7014 107.597 6.52773 100.033 6.52773 90.7007C6.52773 86.4204 10.7798 82.5006 17.7916 79.5269" stroke="currentColor" stroke-width="11.2639" stroke-linecap="round" stroke-linejoin="round" />
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M55.7397 88.8703L55.7678 88.8422L55.8354 88.7633L56.0889 88.4817L57.0238 87.4342C61.7036 82.1044 66.1169 76.5464 70.2476 70.7805C73.8633 65.7118 77.5691 59.9672 80.3907 54.262C83.1503 48.6864 85.375 42.5532 85.375 36.8819C85.375 16.7589 70.6305 0.58963 51.5833 0.58963C32.5361 0.58963 17.7916 16.7533 17.7916 36.8819C17.7916 42.5532 20.0163 48.6864 22.7759 54.262C25.5975 59.9672 29.309 65.7118 32.9134 70.7805C37.3201 76.9261 42.0481 82.8347 47.0777 88.4817L47.3312 88.7633L47.3988 88.8422L47.4269 88.8703C47.9546 89.4474 48.5967 89.9083 49.3123 90.2237C50.0279 90.539 50.8013 90.7018 51.5833 90.7018C52.3653 90.7018 53.1387 90.539 53.8543 90.2237C54.5699 89.9083 55.212 89.4474 55.7397 88.8703ZM51.5833 23.1174C48.5959 23.1174 45.7309 24.3041 43.6185 26.4165C41.5061 28.5289 40.3194 31.3939 40.3194 34.3813C40.3194 37.3687 41.5061 40.2337 43.6185 42.3461C45.7309 44.4584 48.5959 45.6452 51.5833 45.6452C54.5707 45.6452 57.4357 44.4584 59.5481 42.3461C61.6605 40.2337 62.8472 37.3687 62.8472 34.3813C62.8472 31.3939 61.6605 28.5289 59.5481 26.4165C57.4357 24.3041 54.5707 23.1174 51.5833 23.1174Z" fill="currentColor" />
                                </svg>
                            </i>
                            <span class="item-name">Districts</span>
                        </a>
                    </li>
                    @endcan
                    @can('View Department')
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('departments.index') || request()->routeIs('departments.create') || request()->routeIs('departments.edit')) active @endif" href="{{url('departments')}}">
                            <i class="icon">
                                <svg width="80" height="74" viewBox="0 0 80 74" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-16">
                                    <path fill-rule="evenodd" clip-rule="evenodd" d="M37.0312 0.353378C34.7907 0.353378 32.642 1.24342 31.0577 2.82771C29.4734 4.41201 28.5833 6.56077 28.5833 8.80129V14.4332C28.582 16.4306 29.2885 18.3638 30.5773 19.8897C31.8661 21.4157 33.6538 22.4356 35.6233 22.7685V32.737H17.3194C14.7055 32.737 12.1986 33.7754 10.3503 35.6238C8.50193 37.4721 7.46354 39.979 7.46354 42.5929V51.1535C5.49412 51.4864 3.70634 52.5063 2.41755 54.0323C1.12875 55.5582 0.422311 57.4914 0.423616 59.4888V65.1207C0.423616 67.3612 1.31366 69.51 2.89795 71.0943C4.48224 72.6786 6.631 73.5686 8.87153 73.5686H14.5035C16.744 73.5686 18.8928 72.6786 20.477 71.0943C22.0613 69.51 22.9514 67.3612 22.9514 65.1207V59.4888C22.9527 57.4914 22.2462 55.5582 20.9575 54.0323C19.6687 52.5063 17.8809 51.4864 15.9115 51.1535V42.5929C15.9115 42.2195 16.0598 41.8614 16.3238 41.5973C16.5879 41.3333 16.946 41.185 17.3194 41.185H35.6233V51.1535C33.6538 51.4864 31.8661 52.5063 30.5773 54.0323C29.2885 55.5582 28.582 57.4914 28.5833 59.4888V65.1207C28.5833 67.3612 29.4734 69.51 31.0577 71.0943C32.642 72.6786 34.7907 73.5686 37.0312 73.5686H42.6632C44.9037 73.5686 47.0525 72.6786 48.6368 71.0943C50.2211 69.51 51.1111 67.3612 51.1111 65.1207V59.4888C51.1124 57.4914 50.406 55.5582 49.1172 54.0323C47.8284 52.5063 46.0406 51.4864 44.0712 51.1535V41.185H62.375C62.7484 41.185 63.1065 41.3333 63.3706 41.5973C63.6346 41.8614 63.783 42.2195 63.783 42.5929V51.1535C61.8135 51.4864 60.0258 52.5063 58.737 54.0323C57.4482 55.5582 56.7417 57.4914 56.743 59.4888V65.1207C56.743 67.3612 57.6331 69.51 59.2174 71.0943C60.8017 72.6786 62.9504 73.5686 65.1909 73.5686H70.8229C73.0634 73.5686 75.2122 72.6786 76.7965 71.0943C78.3808 69.51 79.2708 67.3612 79.2708 65.1207V59.4888C79.2721 57.4914 78.5657 55.5582 77.2769 54.0323C75.9881 52.5063 74.2003 51.4864 72.2309 51.1535V42.5929C72.2309 39.979 71.1925 37.4721 69.3442 35.6238C67.4958 33.7754 64.9889 32.737 62.375 32.737H44.0712V22.7685C46.0406 22.4356 47.8284 21.4157 49.1172 19.8897C50.406 18.3638 51.1124 16.4306 51.1111 14.4332V8.80129C51.1111 6.56077 50.2211 4.41201 48.6368 2.82771C47.0525 1.24342 44.9037 0.353378 42.6632 0.353378H37.0312Z" fill="currentColor" />
                                </svg>
                            </i>
                            <span class="item-name">Departments</span>
                        </a>
                    </li>
                    @endcan
                    @can('View Dashboard-Input')
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('dashboard_input')) active @endif" href="{{route('dashboard_input')}}">
                            <i class="icon">
                                <svg width="74" height="74" viewBox="0 0 74 74" fill="none" xmlns="http://www.w3.org/2000/svg"
                                class="icon-20">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                    d="M0.527733 70.8299C0.527733 70.083 0.824415 69.3668 1.35251 68.8387C1.88061 68.3106 2.59686 68.0139 3.3437 68.0139H70.927C71.6739 68.0139 72.3901 68.3106 72.9182 68.8387C73.4463 69.3668 73.743 70.083 73.743 70.8299C73.743 71.5767 73.4463 72.293 72.9182 72.8211C72.3901 73.3492 71.6739 73.6459 70.927 73.6459H3.3437C2.59686 73.6459 1.88061 73.3492 1.35251 72.8211C0.824415 72.293 0.527733 71.5767 0.527733 70.8299Z"
                                    fill="currentColor"></path>
                                <path
                                    d="M20.2395 34.222H8.97566C7.42044 34.222 6.15969 35.4828 6.15969 37.038V70.8297C6.15969 72.3849 7.42044 73.6456 8.97566 73.6456H20.2395C21.7948 73.6456 23.0555 72.3849 23.0555 70.8297V37.038C23.0555 35.4828 21.7948 34.222 20.2395 34.222Z"
                                    fill="currentColor"></path>
                                <path
                                    d="M42.7674 0.430664H31.5035C29.9483 0.430664 28.6875 1.69142 28.6875 3.24664V70.8299C28.6875 72.3852 29.9483 73.6459 31.5035 73.6459H42.7674C44.3226 73.6459 45.5833 72.3852 45.5833 70.8299V3.24664C45.5833 1.69142 44.3226 0.430664 42.7674 0.430664Z"
                                    fill="currentColor"></path>
                                <path
                                    d="M65.2951 17.3263H54.0312C52.476 17.3263 51.2152 18.587 51.2152 20.1423V70.8297C51.2152 72.385 52.476 73.6457 54.0312 73.6457H65.2951C66.8503 73.6457 68.1111 72.385 68.1111 70.8297V20.1423C68.1111 18.587 66.8503 17.3263 65.2951 17.3263Z"
                                    fill="currentColor"></path>
                                </svg>
                            </i>
                            <span class="item-name">Dashboard Input</span>
                        </a>
                    </li>
                    @endcan
                    @can('View Target')
                    <li class="nav-item">
                        <a class="nav-link @if(request()->routeIs('targets.index') || request()->routeIs('targets.create') ||request()->routeIs('targets.edit')) active @endif" href="{{url('targets')}}">
                            <i class="icon">
                                <svg width="75" height="74" viewBox="0 0 75 74" fill="none" xmlns="http://www.w3.org/2000/svg" class="icon-16">
                                    <path d="M57.1111 3.60492C57.1121 3.04724 56.9475 2.50182 56.6381 2.03781C56.3288 1.5738 55.8886 1.21209 55.3734 0.998541C54.8583 0.784992 54.2913 0.729218 53.7444 0.838291C53.1975 0.947363 52.6953 1.21637 52.3014 1.61121L41.0375 12.8751C40.7762 13.1371 40.5691 13.448 40.428 13.7901C40.2869 14.1322 40.2146 14.4988 40.2153 14.8688V30.5988L36.042 34.7665C35.2072 34.5449 34.3326 34.518 33.4857 34.6877C32.6388 34.8574 31.8421 35.2193 31.1571 35.7454C30.4721 36.2716 29.917 36.9479 29.5346 37.7224C29.1522 38.4969 28.9527 39.3488 28.9514 40.2125C28.9518 41.014 29.1232 41.8062 29.4543 42.5362C29.7853 43.2661 30.2683 43.917 30.8711 44.4453C31.4738 44.9736 32.1824 45.3672 32.9494 45.5997C33.7165 45.8322 34.5243 45.8983 35.3189 45.7937C36.1136 45.689 36.8767 45.4159 37.5573 44.9926C38.238 44.5694 38.8205 44.0058 39.2658 43.3394C39.7112 42.673 40.0092 41.9192 40.1399 41.1285C40.2706 40.3377 40.231 39.5281 40.0238 38.7539L44.1971 34.5806H59.9271C60.2971 34.5813 60.6637 34.509 61.0058 34.3679C61.3479 34.2268 61.6588 34.0197 61.9208 33.7583L73.1847 22.4945C73.5795 22.1006 73.8485 21.5984 73.9576 21.0515C74.0667 20.5046 74.0109 19.9376 73.7973 19.4224C73.5838 18.9073 73.2221 18.4671 72.7581 18.1577C72.2941 17.8484 71.7486 17.6838 71.191 17.6848H57.1111V3.60492ZM68.0596 35.5831C68.2699 37.0924 68.375 38.6356 68.375 40.2125C68.3742 47.0939 66.2725 53.8109 62.351 59.4655C58.4295 65.1201 52.8752 69.4427 46.4306 71.8553C39.9861 74.2679 32.9586 74.6554 26.2879 72.9661C19.6171 71.2769 13.6211 67.5913 9.10161 62.4022C4.58211 57.2131 1.75455 50.7679 0.997051 43.9284C0.239548 37.0889 1.5882 30.1811 4.86267 24.1288C8.13714 18.0765 13.1813 13.1681 19.3208 10.0601C25.4602 6.95201 32.4022 5.79239 39.2184 6.73628L37.0614 8.89331C36.276 9.67769 35.653 10.6092 35.2278 11.6345C34.8026 12.6598 34.5836 13.7588 34.5833 14.8688C29.5708 14.8688 24.6709 16.3552 20.5031 19.14C16.3354 21.9248 13.087 25.8829 11.1688 30.5139C9.25057 35.1449 8.74868 40.2407 9.72657 45.1569C10.7045 50.0731 13.1182 54.5889 16.6626 58.1333C20.207 61.6777 24.7228 64.0914 29.639 65.0693C34.5552 66.0472 39.651 65.5453 44.282 63.6271C48.9129 61.7089 52.8711 58.4605 55.6559 54.2928C58.4407 50.125 59.9271 45.2251 59.9271 40.2125C62.1668 40.2106 64.3142 39.3192 65.8969 37.7345L68.0596 35.5831ZM34.5833 20.5007C30.6847 20.5007 26.8736 21.6568 23.6321 23.8228C20.3905 25.9887 17.864 29.0673 16.372 32.6692C14.8801 36.271 14.4897 40.2344 15.2503 44.0581C16.0109 47.8818 17.8883 51.3941 20.645 54.1509C23.4017 56.9076 26.914 58.785 30.7378 59.5456C34.5615 60.3062 38.5249 59.9158 42.1267 58.4239C45.7286 56.9319 48.8071 54.4054 50.9731 51.1638C53.1391 47.9222 54.2951 44.1112 54.2951 40.2125H46.5287L45.8247 40.9165C45.6893 43.0802 44.9324 45.1588 43.6449 46.9029C42.3574 48.647 40.5939 49.9825 38.5661 50.7491C36.5383 51.5158 34.3324 51.681 32.213 51.2249C30.0937 50.7688 28.1509 49.7108 26.618 48.1779C25.0851 46.6449 24.0271 44.7022 23.571 42.5829C23.1149 40.4635 23.2801 38.2576 24.0467 36.2298C24.8134 34.202 26.1489 32.4385 27.893 31.151C29.6371 29.8635 31.7157 29.1066 33.8793 28.9712L34.5833 28.2672V20.5007Z" fill="currentColor" />
                                </svg>
                            </i>
                            <span class="item-name">Targets</span>
                        </a>
                    </li>
                    @endcan
                </ul>
            </li>
            @endcan
        </ul>
        <!-- Sidebar Menu End -->
    </div>
</div>
<div class="sidebar-footer"></div>
@endsection