@extends('layouts.main_content.login_page_layout')

@section('head')
@include('layouts.head.login_page_head',['title' => 'SDG J&K - Login'])
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="wrapper sign-in-wrapper">
  <div class="sign-in__grid-area">
    <div class="sign-in__banner-area">
      <div class="sign-in__banner-content">
        <h1 class="sign-in__banner-title">JAMMU & KASHMIR</h1>
        <h2 class="sign-in__banner-subtitle">SDG Index & Dashboard</h2>

        <div class="sign-in__banner-images-grid">
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_1.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_2.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_3.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_4.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_5.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_6.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_7.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_8.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_9.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_10.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_11.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_12.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_13.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_14.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_15.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_16.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goals/goal_17.jpg')}}" />
          </div>
          <div class="sign-in__banner-images-grid-item">
            <img src="{{asset('assets/images/goal-sdg.png')}}" />
          </div>
        </div>
      </div>
    </div>
    <div class="sign-in__form-area">
      <div class="sign-in__form-wrapper">
        <header class="sign-in__header">
          <div class="sign-in__header-left">
            <img src="{{asset('assets/images/niti.png')}}" alt="Niti Aayog" />
          </div>
          <div class="sign-in__header-center">
          </div>
          <div class="sign-in__header-right">
            <img src="{{asset('assets/images/satyamev.png')}}" alt="Satyamev Jayate" />
          </div>
        </header>
        <div class="sign-in__form-content">
          <h2 class="sign-in__form-title">Login</h2>
          <form id="login-form" method="POST" action="{{ route('login') }}">
            @csrf
            <div class="form-group">
              <label class="form-label" for="email">{{ __('Username') }}</label>
              <input id="email" type="text" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ old('email') }}" autocomplete="Username" autofocus data-rule-mandatory="true" />

              @error('email')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
            <div class="form-group">
              <div class="pwd-label">
                <label class="form-label" for="pwd">{{ __('Password') }}</label>
                <span class="toggle-hide-pwd" role="button" data-pwd-target="1">
                  <svg width="1.3em" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M9.80327 15.2526C10.4277 15.6759 11.1888 15.9319 11.9987 15.9319C14.1453 15.9319 15.8919 14.1696 15.8919 12.0037C15.8919 11.1866 15.6382 10.4186 15.2186 9.78855L14.1551 10.8617C14.3307 11.1964 14.4283 11.5902 14.4283 12.0037C14.4283 13.3525 13.3354 14.4551 11.9987 14.4551C11.5889 14.4551 11.1986 14.3567 10.8668 14.1795L9.80327 15.2526ZM18.4288 6.54952C19.8436 7.84907 21.0438 9.60149 21.9415 11.7083C22.0195 11.8954 22.0195 12.112 21.9415 12.2892C19.8534 17.1921 16.1358 20.1259 11.9987 20.1259H11.9889C10.1058 20.1259 8.30063 19.5056 6.71018 18.3735L4.81725 20.2834C4.67089 20.4311 4.4855 20.5 4.30011 20.5C4.11472 20.5 3.91957 20.4311 3.78297 20.2834C3.53903 20.0373 3.5 19.6435 3.69515 19.358L3.72442 19.3186L18.1556 4.75771C18.1751 4.73802 18.1946 4.71833 18.2044 4.69864L18.2044 4.69863C18.2239 4.67894 18.2434 4.65925 18.2532 4.63957L19.1704 3.71413C19.4631 3.42862 19.9217 3.42862 20.2046 3.71413C20.4974 3.99964 20.4974 4.4722 20.2046 4.75771L18.4288 6.54952ZM8.09836 12.0075C8.09836 12.2635 8.12764 12.5195 8.16667 12.7558L4.55643 16.3984C3.5807 15.2564 2.7318 13.8781 2.05854 12.293C1.98049 12.1158 1.98049 11.8992 2.05854 11.7122C4.14662 6.80933 7.86419 3.88534 11.9916 3.88534H12.0013C13.3966 3.88534 14.7529 4.22007 16.0018 4.85015L12.7429 8.13841C12.5087 8.09903 12.255 8.0695 12.0013 8.0695C9.84494 8.0695 8.09836 9.83177 8.09836 12.0075Z" fill="currentColor"></path>
                  </svg>
                  Hide
                </span>
              </div>
              <input type="password" id="pwd" data-toggle-pwd="1" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="current-password" data-rule-required="true" />
              @error('password')
              <span class="invalid-feedback" role="alert">
                <strong>{{ $message }}</strong>
              </span>
              @enderror
            </div>
            <!-- Add reCAPTCHA widget below the login button -->
            <div class="g-recaptcha mt-3 mb-3" data-sitekey="{{ config('services.google_recaptcha.site') }}" data-callback="recaptchaCallback"></div>

            <span id="recaptcha-error" class="help-block" style="color: red; display: none;"></span>
            @error('g-recaptcha-response')
            <span class="text-danger" role="alert">
              <strong>@if(isset(session('errors')->get('g-recaptcha-response')[1]) && !empty(session('errors')->get('g-recaptcha-response')[1])){{ session('errors')->get('g-recaptcha-response')[1] }} @else {{ session('errors')->get('g-recaptcha-response')[0] }} @endif</strong>
            </span>
            @enderror

            @error('captcha')
            <span class="invalid-feedback" role="alert">
              <strong>{{ $message }}</strong>
            </span>
            @enderror
            <!-- Add reCAPTCHA widget below the login button -->
            <button type="submit" class="btn btn-primary w-100">
              Login
              <svg width="1.3em" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M19.75 11.7256L4.75 11.7256" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M13.7002 5.70124L19.7502 11.7252L13.7002 17.7502" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
              </svg>
            </button>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
@endsection

@push('script')
<!-- Library Bundle Script -->
<script src="assets/js/core/libs.min.js"></script>

<!-- App Script -->
<script src="assets/js/hope-ui.js" defer></script>

<script src="{{ asset('assets/js/jquery.js')}}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}"></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{ asset('assets/js/encrypt.js') }}"></script>

<script src="https://www.google.com/recaptcha/api.js" async defer></script>

<script>
  $(document).ready(function() {
    $("[data-pwd-target]").click(function() {
      var target = $(this).data("pwd-target");
      var input = $(`[data-toggle-pwd="${target}"]`);
      if (input.attr("type") === "password") {
        input.attr("type", "text");
        $(this).html(
          `<svg width="1.3em" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path fill-rule="evenodd" clip-rule="evenodd" d="M8.09756 12C8.09756 14.1333 9.8439 15.8691 12 15.8691C14.1463 15.8691 15.8927 14.1333 15.8927 12C15.8927 9.85697 14.1463 8.12121 12 8.12121C9.8439 8.12121 8.09756 9.85697 8.09756 12ZM17.7366 6.04606C19.4439 7.36485 20.8976 9.29455 21.9415 11.7091C22.0195 11.8933 22.0195 12.1067 21.9415 12.2812C19.8537 17.1103 16.1366 20 12 20H11.9902C7.86341 20 4.14634 17.1103 2.05854 12.2812C1.98049 12.1067 1.98049 11.8933 2.05854 11.7091C4.14634 6.88 7.86341 4 11.9902 4H12C14.0683 4 16.0293 4.71758 17.7366 6.04606ZM12.0012 14.4124C13.3378 14.4124 14.4304 13.3264 14.4304 11.9979C14.4304 10.6597 13.3378 9.57362 12.0012 9.57362C11.8841 9.57362 11.767 9.58332 11.6597 9.60272C11.6207 10.6694 10.7426 11.5227 9.65971 11.5227H9.61093C9.58166 11.6779 9.56215 11.833 9.56215 11.9979C9.56215 13.3264 10.6548 14.4124 12.0012 14.4124Z" fill="currentColor"></path></svg> Show`
        );
      } else {
        input.attr("type", "password");
        $(this).html(`<svg width="1.3em" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.80327 15.2526C10.4277 15.6759 11.1888 15.9319 11.9987 15.9319C14.1453 15.9319 15.8919 14.1696 15.8919 12.0037C15.8919 11.1866 15.6382 10.4186 15.2186 9.78855L14.1551 10.8617C14.3307 11.1964 14.4283 11.5902 14.4283 12.0037C14.4283 13.3525 13.3354 14.4551 11.9987 14.4551C11.5889 14.4551 11.1986 14.3567 10.8668 14.1795L9.80327 15.2526ZM18.4288 6.54952C19.8436 7.84907 21.0438 9.60149 21.9415 11.7083C22.0195 11.8954 22.0195 12.112 21.9415 12.2892C19.8534 17.1921 16.1358 20.1259 11.9987 20.1259H11.9889C10.1058 20.1259 8.30063 19.5056 6.71018 18.3735L4.81725 20.2834C4.67089 20.4311 4.4855 20.5 4.30011 20.5C4.11472 20.5 3.91957 20.4311 3.78297 20.2834C3.53903 20.0373 3.5 19.6435 3.69515 19.358L3.72442 19.3186L18.1556 4.75771C18.1751 4.73802 18.1946 4.71833 18.2044 4.69864L18.2044 4.69863C18.2239 4.67894 18.2434 4.65925 18.2532 4.63957L19.1704 3.71413C19.4631 3.42862 19.9217 3.42862 20.2046 3.71413C20.4974 3.99964 20.4974 4.4722 20.2046 4.75771L18.4288 6.54952ZM8.09836 12.0075C8.09836 12.2635 8.12764 12.5195 8.16667 12.7558L4.55643 16.3984C3.5807 15.2564 2.7318 13.8781 2.05854 12.293C1.98049 12.1158 1.98049 11.8992 2.05854 11.7122C4.14662 6.80933 7.86419 3.88534 11.9916 3.88534H12.0013C13.3966 3.88534 14.7529 4.22007 16.0018 4.85015L12.7429 8.13841C12.5087 8.09903 12.255 8.0695 12.0013 8.0695C9.84494 8.0695 8.09836 9.83177 8.09836 12.0075Z" fill="currentColor"></path> </svg> Hide`);
      }
    });

    const form = document.querySelector('form');
    const recaptchaError = document.querySelector('#recaptcha-error');

    form.addEventListener('submit', function(event) {
      const recaptchaResponse = document.querySelector('[name="g-recaptcha-response"]').value;
      if (!recaptchaResponse) {
        event.preventDefault();
        recaptchaError.textContent = 'Please complete the reCAPTCHA.';
        recaptchaError.style.display = 'block';
      } else {
        recaptchaError.textContent = '';
        recaptchaError.style.display = 'none';
      }
    });
    $.validator.setDefaults({
      ignore: []
    });
    $("#login-form").validate({
      errorClass: "text-danger",
      rules: {
        'g-recaptcha-response': {
          required: function() {
            if (grecaptcha.getResponse() == '') {
              $('#recaptcha-error').text('Please complete the reCAPTCHA.');
              $('#recaptcha-error').show();
              return true;
            } else {
              $('#recaptcha-error').hide();
              return false;
            }
          }
        }
      },
      messages: {
        'g-recaptcha-response': {
          required: ''
        }
      },
      submitHandler: function(form) {
        // Get the password input element
        var passwordInput = document.getElementById("pwd");
        var password = passwordInput.value;

        var encoded = "";
        var passwordStr = btoa(btoa(password));

        for (var i = 0; i < passwordStr.length; i++) {
          var a = passwordStr.charCodeAt(i);
          var b = a ^ 10; // bitwise XOR with any number, e.g. 123
          encoded += String.fromCharCode(b);
        }

        var passwordEncoded = btoa(encoded);
        passwordInput.value = passwordEncoded;
        var input = $('#pwd');
        if (input.attr("type") === "text") {
          input.attr("type", "password");
          $(this).html(`<svg width="1.3em" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"> <path fill-rule="evenodd" clip-rule="evenodd" d="M9.80327 15.2526C10.4277 15.6759 11.1888 15.9319 11.9987 15.9319C14.1453 15.9319 15.8919 14.1696 15.8919 12.0037C15.8919 11.1866 15.6382 10.4186 15.2186 9.78855L14.1551 10.8617C14.3307 11.1964 14.4283 11.5902 14.4283 12.0037C14.4283 13.3525 13.3354 14.4551 11.9987 14.4551C11.5889 14.4551 11.1986 14.3567 10.8668 14.1795L9.80327 15.2526ZM18.4288 6.54952C19.8436 7.84907 21.0438 9.60149 21.9415 11.7083C22.0195 11.8954 22.0195 12.112 21.9415 12.2892C19.8534 17.1921 16.1358 20.1259 11.9987 20.1259H11.9889C10.1058 20.1259 8.30063 19.5056 6.71018 18.3735L4.81725 20.2834C4.67089 20.4311 4.4855 20.5 4.30011 20.5C4.11472 20.5 3.91957 20.4311 3.78297 20.2834C3.53903 20.0373 3.5 19.6435 3.69515 19.358L3.72442 19.3186L18.1556 4.75771C18.1751 4.73802 18.1946 4.71833 18.2044 4.69864L18.2044 4.69863C18.2239 4.67894 18.2434 4.65925 18.2532 4.63957L19.1704 3.71413C19.4631 3.42862 19.9217 3.42862 20.2046 3.71413C20.4974 3.99964 20.4974 4.4722 20.2046 4.75771L18.4288 6.54952ZM8.09836 12.0075C8.09836 12.2635 8.12764 12.5195 8.16667 12.7558L4.55643 16.3984C3.5807 15.2564 2.7318 13.8781 2.05854 12.293C1.98049 12.1158 1.98049 11.8992 2.05854 11.7122C4.14662 6.80933 7.86419 3.88534 11.9916 3.88534H12.0013C13.3966 3.88534 14.7529 4.22007 16.0018 4.85015L12.7429 8.13841C12.5087 8.09903 12.255 8.0695 12.0013 8.0695C9.84494 8.0695 8.09836 9.83177 8.09836 12.0075Z" fill="currentColor"></path> </svg> Hide`);
        } 
        // Submit the form
        form.submit();
      }
    });
  });

  function recaptchaCallback() {
    const recaptchaError = document.querySelector('#recaptcha-error');
    recaptchaError.textContent = '';
    recaptchaError.style.display = 'none';
  }
</script>
@endpush