@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Target Listing', 'custom_css' => 'assets/css/add-indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if(session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    <div class="card">
        <div class="card-header cs-card-header">
            <h1 class="page-title">Targets</h1>
            <div class="card-header-action">
                @can('Export Target')
                <a href="{{url('targets/export')}}" class="btn btn-success btn-sm">
                    Export
                </a>
                @endcan
                @can('Create Target')
                <a href="{{url('targets/create')}}" class="btn btn-primary btn-sm">
                    Add New Target
                </a>
                @endcan
            </div>
        </div>
        <div class="card-body">
            <!-- <div class="graph-filters-strip">
                <div class="filters-area">
                    <div class="form-group cs-form-group">
                        <label for="" class="form-label">Goal</label>
                        <select name="" id="" class="form-select form-select-sm">
                            <option value="">-- Select Goal --</option>
                        </select>
                    </div>
                    <div class="form-group cs-form-group">
                        <label for="" class="form-label">Target</label>
                        <select name="" id="" class="form-select form-select-sm">
                            <option value="">-- Select Target --</option>
                        </select>
                    </div>
                </div>
            </div> -->
            <div class="table-responsive">
                <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                    <colgroup>
                        <col style="width: 950px; max-width:950px;" />
                        <col style="width: 250px; max-width:250px;" />
                        <col style="width: 150px; max-width:150px;" />
                        <col />
                    </colgroup>
                    <thead>
                        <tr>
                            <th>Target Name</th>
                            <th>Goal</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($targets as $target)
                        <tr>
                            <td class="p-3">
                                {{$target->target_name}}
                            </td>
                            <td>{{$target->goal_name}}</td>
                            <td><span class="{{$target->status =='Active'?'text-success':'text-danger'}}">{{$target->status =='Active'?'Active':'Inactive'}}</span></td>
                            <td>
                                <a href="{{url('targets/'.$target->target_id.'/edit')}}" class="cs-icon-edit" data-icon-toggle-title="Edit Target">
                                    <i class="bi bi-pencil-square"></i>
                                </a>
                                @if($target->status == 'Active')
                                <a href="javascript:void(0);" class="cs-icon-delete" data-icon-toggle-title="Discontinue Target" onclick="confirmAction('{{$target->target_id}}','inactive')">
                                    <i class="bi bi-x-lg"></i>
                                </a>
                                @else
                                <a href="javascript:void(0);" class="cs-icon-save" data-icon-toggle-title="Activate Target" onclick="confirmAction('{{$target->target_id}}','active')">
                                    <i class="bi bi-check-lg"></i>
                                </a>
                                @endif
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <nav>
                <ul class="pagination">
                    {{ $targets->links('pagination.bootstrap-4') }}
                </ul>
            </nav>
        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

<script src="{{asset('assets/js/sweetAlert.js')}}"></script>

<script>
    function confirmAction(targetId, action) {
        var url = 'targets/' + targetId + '/' + action + '/delete';
        if (action != '') {
            if (action == 'inactive') {
                var prompt = 'Are you sure to discontinue this Target?';
            } else {
                var prompt = 'Are you sure to activate this Target?';
            }
        } else {
            Swal('Error', 'Action not found', 'error');
        }
        Swal.fire({
            title: prompt,
            text: '',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, do it!'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        })
    }
</script>
@endpush