@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Indicator', 'custom_css' => 'assets/css/add-indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Target</h1>
        </div>
        <div class="card-body">
            <form>
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="goal">Select Goal <em>*</em></label>
                                <select name="goal" id="goal" class="form-select">
                                    <option value="">-- Select Goal --</option>
                                    <option value="">Goal 1</option>
                                    <option value="">Goal 2</option>
                                    <option value="">Goal 3</option>
                                </select>
                            </div>
                        </div>
                        <div class="w-100"></div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-id">Target Id <em>*</em></label>
                                <input type="text" class="form-control" id="target-id" placeholder="Enter Target Id" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-name">Target Name <em>*</em></label>
                                <input type="text" class="form-control" id="target-name" placeholder="Enter Target Name" />
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <button type="reset" class="btn btn-muted me-2">
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
@endpush