@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Indicator Listing', 'custom_css' => 'assets/css/indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    <div class="page-content">
        @if (session('success'))
        <div class="alert alert-success" id="alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
        <div class="alert alert-danger" id="alert-danger">{{ session('error') }}</div>
        @endif
        <div class="card">
            <div class="card-header cs-card-header">
                <h1 class="page-title">Indicators Data Entries</h1>
                <div class="card-header-action">
                    @can('Export Indicator Data Entry')
                    @php
                    $url_parameters = [];
                    if(request()->has('goal')) {
                    $url_parameters['goal'] = request('goal');
                    }
                    if(request()->has('target')) {
                    $url_parameters['target'] = request('target');
                    }
                    if(request()->has('type')) {
                    $url_parameters['type'] = request('type');
                    }
                    if(request()->has('district')) {
                    $url_parameters['district'] = request('district');
                    }
                    if(request()->has('department')) {
                    $url_parameters['department'] = request('department');
                    }
                    @endphp

                    <a href="{{route('indicator_data_entries.export', $url_parameters)}}" class="btn btn-success btn-sm me-4">
                        Export
                    </a>
                    @endcan
                </div>
            </div>
            <div class="card-body">
                <form action="{{route('indicator_data_entries.filter')}}" method="GET" style="width: 100%;" id="filter-form">
                    <div class="graph-filters-strip">
                        <div class="filters-area">
                            @if(request('goal'))
                            <input type="hidden" name="goal" value="{{ request('goal') }}">
                            @endif
                            <div class="form-group cs-form-group">
                                <label for="target" class="form-label">Target</label>
                                <select name="target" id="target" class="form-select form-select-sm">
                                    <option value="">-- Select Target --</option>
                                    @foreach($targets as $target)
                                    <option value="{{$target->target_id}}" {{ request('target') == $target->target_id ? 'selected' : '' }}>{{$target->target_number.': '.$target->target_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @if(auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Super Admin'))
                            <div class="form-group cs-form-group">
                                <label for="type" class="form-label">Indicator Type</label>
                                <select name="type" id="type" class="form-select form-select-sm" data-field="indicator-type">
                                    <option value="utif" {{ request('type') == 'utif' ? 'selected' : '' }}>UTIF</option>
                                    <option value="dif" {{ request('type') == 'dif' ? 'selected' : '' }}>DIF</option>
                                </select>
                            </div>
                            <div class="form-group cs-form-group @if(request('type') == 'dif')d-none @endif" data-field="dept-column">
                                <label for="department" class="form-label">Department</label>
                                <select name="department" id="department" class="form-select form-select-sm">
                                    <option value="">--Select Department--</option>
                                    @foreach($departments as $department)
                                    <option value="{{$department->id}}" {{ request('department') == $department->id ? 'selected' : '' }}>{{$department->department_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group cs-form-group @if(request('type') !='dif')d-none @endif" data-field="district-column">
                                <label for="district" class="form-label">District</label>
                                <select name="district" id="district" class="form-select form-select-sm">
                                    <option value="">--Select District--</option>
                                    @foreach($districts as $district)
                                    <option value="{{$district->id}}" {{ request('district') == $district->id ? 'selected' : '' }}>{{$district->district_name}}</option>
                                    @endforeach
                                </select>
                            </div>
                            @endif
                            <div class="form-group cs-form-group" data-field="status-column">
                                <label for="status" class="form-label">Status</label>
                                <select name="status" id="status" class="form-select form-select-sm">
                                    <option value="">--Select Status--</option>
                                    <option value="Pending" {{ request('status') == 'Pending' ? 'selected' : '' }}>Pending</option>
                                    <option value="Sent_for_level_one_approval" {{ request('status') == 'Sent_for_level_one_approval' ? 'selected' : '' }}>Level 1 Approval Pending</option>
                                    <option value="Approved" {{ request('status') == 'Approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="Disapproved" {{ request('status') == 'Disapproved' ? 'selected' : '' }}>Disapproved</option>
                                    <option value="Sent_for_hod_approval" {{ request('status') == 'Sent_for_hod_approval' ? 'selected' : '' }}>Approval Pending by HOD</option>
                                    <option value="Sent_for_admin_approval" {{ request('status') == 'Sent_for_admin_approval' ? 'selected' : '' }}>Approval Pending by Admin</option>
                                </select>
                            </div>
                            <div class="form-group cs-form-group form-group-btn-lg">
                                <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">
                                    Submit
                                </button>
                                <a href="{{ url('indicator-data-entries') }}" class="btn btn-danger btn-sm ms-2 pt-2 pb-2 ps-3 pe-3">Clear Filter</a>
                            </div>
                        </div>
                    </div>
                </form>
                <div class="table-responsive" style="max-height: calc(100vh - 235px)">
                    <table class="table table-sm cs-table-sticky-header cs-table cs-table-border-x">
                        <colgroup>
                            <col style="width: 100px; min-width: 100px" ; />
                            <col style="width: 350px; min-width: 350px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col style="width: 150px; min-width: 150px" />
                            <col style="width: 110px; min-width: 110px" />
                            <col style="width: 150px; min-width: 150px" />
                            <col style="width: 150px; min-width: 150px" />
                            <col style="width: 120px; min-width: 120px" />
                            <col style="width: 100px; min-width: 100px" />
                            <col />
                        </colgroup>
                        <thead>
                            <tr>
                                <th>Sr No.</th>
                                <th>Indicator Name</th>
                                <th>Unit</th>
                                <th>Value Type</th>
                                <th>Baseline Value</th>
                                <th>Baseline Year</th>
                                <th>Target 2030</th>
                                <th>Time Period (Current Year)</th>
                                @if(!empty($type) && $type == 'dif')
                                <th>District</th>
                                @else
                                <th>Department</th>
                                @endif
                                @can('Update Indicator Data Entry')
                                <th>Data Value (Current Year)</th>
                                @endcan
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @if(isset($indicators) && count($indicators) > 0)
                            @foreach($indicators as $indicator)
                            <tr>
                                <td>{{ ($indicators->currentPage() - 1) * $indicators->perPage() + $loop->iteration }}</td>
                                <td>{{$indicator->indicator_number}}: {{$indicator->indicator_name}}</td>
                                <td>{{$indicator->unit}}</td>
                                <td>@if(!empty($indicator->value_type)){{$indicator->value_type}} @else <img src="{{asset('assets/images/dual-circle.svg')}}" style="margin-left: 5px;" alt="No Data" /> @endif</td>
                                <td>@if(!empty($indicator->baseline_value)){{$indicator->baseline_value}} @else <img src="{{asset('assets/images/dual-circle.svg')}}" style="margin-left: 5px;" alt="No Data" /> @endif</td>
                                <td>@if(!empty($indicator->baseline_year)){{$indicator->baseline_year}} @else <img src="{{asset('assets/images/dual-circle.svg')}}" style="margin-left: 5px;" alt="No Data" /> @endif</td>
                                <td>@if(!empty($indicator->target_value)){{$indicator->target_value}} @else <img src="{{asset('assets/images/dual-circle.svg')}}" style="margin-left: 5px;" alt="No Data" /> @endif</td>
                                <td>@if(!empty($indicator->reporting_year)){{$indicator->reporting_year}} @else <img src="{{asset('assets/images/dual-circle.svg')}}" style="margin-left: 5px;" alt="No Data" /> @endif</td>
                                <td>
                                    @if(!empty($indicator->district_name))
                                    {{$indicator->district_name}}
                                    @else
                                    {{$indicator->department_name}}
                                    @endif
                                </td>
                                @can('Update Indicator Data Entry')
                                <td>
                                    <div class="form-group cs-form-group mb-0">
                                        @php
                                        $inputdisable = '';
                                        $user = auth()->user();
                                        @endphp
                                        @if($user->hasRole('District-User') || $user->hasRole('Department-User')|| $user->hasRole('District-Approver') || $user->hasRole('Department-Approver') || $user->hasRole('District-HOD') || $user->hasRole('Department-HOD'))
                                            @if(((strtolower($indicator->status) == 'approved') && $indicator->update_count >= 3))
                                                @php
                                                $inputdisable = 'disabled';
                                                @endphp
                                            @endif
                                            @if((strtolower($indicator->status) == 'sent_for_hod_approval' || strtolower($indicator->status) == 'sent_for_admin_approval') && ($user->hasRole('District-User') || $user->hasRole('Department-User') || $user->hasRole('District-Approver') || $user->hasRole('Department-Approver')))
                                                @php
                                                $inputdisable = 'disabled';
                                                @endphp
                                            @endif
                                            @if(strtolower($indicator->status) == 'sent_for_admin_approval' && ($user->hasRole('District-Approver') || $user->hasRole('Department-Approver') || $user->hasRole('District-HOD') || $user->hasRole('Department-HOD')))
                                                @php
                                                $inputdisable = 'disabled';
                                                @endphp
                                            @endif
                                        @endif
                                        <input type="number" name="data_value" id="indicator_data_entry_id_{{$indicator->indicator_data_entries_id}}" class="form-control form-control-sm" value="{{$indicator->indicator_value}}" oninput="validateInput(this,'{{$indicator->indicator_data_entries_id}}','{{$indicator->unit}}')" {{$inputdisable}} />
                                        <span id="error_{{$indicator->indicator_data_entries_id}}" class="text-danger"></span>
                                        <span id="status_success_indicator_{{$indicator->indicator_data_entries_id}}" class="text-success"></span>
                                        <span id="status_error_indicator_{{$indicator->indicator_data_entries_id}}" class="text-danger"></span>
                                    </div>
                                </td>
                                @endcan
                                <td>
                                    @if($indicator->status == 'Sent_for_level_one_approval')
                                        @php
                                        $text = 'Sent For Level 1 Approval';
                                        $class = 'text-warning';
                                        @endphp
                                    @elseif($indicator->status == 'Sent_for_hod_approval')
                                        @php
                                        $text = 'Sent For HOD Approval';
                                        $class = 'text-warning';
                                        @endphp
                                    @elseif($indicator->status == 'Sent_for_admin_approval')
                                        @php
                                        $text = 'Sent For Admin Approval';
                                        $class = 'text-warning';
                                        @endphp
                                    @elseif($indicator->status == 'Approved')
                                        @php
                                        $text = 'Approved';
                                        $class = 'text-success';
                                        @endphp
                                    @elseif($indicator->status == 'Disapproved')
                                        @php
                                        $text = 'Disapproved';
                                        $class = 'text-danger';
                                        @endphp
                                    @else($indicator->status == 'Pending')
                                        @php
                                        $text = 'Pending';
                                        $class = 'text-primary';
                                        @endphp
                                    @endif
                                    <div class="status-wrapper">
                                        <span class="{{ $class }}" id="status_indicator_{{ $indicator->indicator_data_entries_id }}">{{ $text }}</span>
                                    
                                        @if($indicator->status == 'Disapproved' && $indicator->disapproval_reason != null)
                                            <button id="comment_{{ $indicator->indicator_data_entries_id }}"
                                                    class="comment-icon-button"
                                                    data-icon-toggle-title="View Comment"
                                                    onclick="displayComment('{{ $indicator->indicator_data_entries_id }}', 'showComment', '{{ addslashes($indicator->disapproval_reason) }}')">
                                                <img src="{{ asset('assets/images/icons8-comment-32-black.png') }}" alt="comment" height="15px" width="15px" />
                                            </button>
                                        @endif
                                    </div>                                    
                                </td>
                                <td>
                                    <div class="cs-icons-wrapper">

                                        @php
                                        $disable = '';
                                        $approve = 'approve';
                                        $disapprove = 'disapprove';
                                        $user = auth()->user();
                                        @endphp
                                        @if ($user->hasRole('District-User') || $user->hasRole('Department-User')|| $user->hasRole('District-Approver') || $user->hasRole('Department-Approver') || $user->hasRole('District-HOD') || $user->hasRole('Department-HOD'))
                                            @if(empty($indicator->indicator_value) || (!empty($indicator->status) && (strtolower($indicator->status) == 'approved'  || strtolower($indicator->status) == 'completed') && $indicator->update_count>=3))
                                                @php
                                                $disable = 'disabled';
                                                @endphp
                                            @endif
                                        @else
                                            @if(empty($indicator->indicator_value))
                                                @php
                                                $disable = 'disabled';
                                                @endphp
                                            @endif
                                        @endif

                                        @can('Update Indicator Data Entry')
                                        <button id="save-button_{{$indicator->indicator_data_entries_id}}" class="cs-icon-save cs-icon" {{$disable}} {{$inputdisable}} data-icon-toggle-title="Save" onclick="save('{{$indicator->indicator_data_entries_id}}')">
                                            <i class="bi bi-file-earmark-check"></i>
                                        </button>
                                        @endcan

                                        @can('Approve Indicator Data Entry')
                                        <button id="approve_{{$indicator->indicator_data_entries_id}}" class="cs-icon-approve cs-icon" {{$disable}} {{$inputdisable}} data-icon-toggle-title="Approve" onclick="markApproveDisapprove('{{$indicator->indicator_data_entries_id}}','{{$approve}}')">
                                            <svg width="1em" height="1em" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M13 7.70747C12.52 10.1073 10.7105 12.367 8.17148 12.872C6.93314 13.1186 5.64856 12.9682 4.50065 12.4423C3.35274 11.9164 2.40002 11.0417 1.77814 9.94279C1.15626 8.8439 0.896932 7.57681 1.03708 6.32196C1.17722 5.06711 1.70969 3.88845 2.55868 2.95383C4.30002 1.03585 7.24033 0.507885 9.64019 1.46783" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.84058 6.7475L7.24044 9.14736L13.0001 2.90771" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </button>
                                        @endcan

                                        @can('Disapprove Indicator Data Entry')
                                        <button id="disapprove_{{$indicator->indicator_data_entries_id}}" class="cs-icon-disapprove cs-icon" {{$disable}} {{$inputdisable}} data-icon-toggle-title="Disapprove" onclick="markApproveDisapprove('{{$indicator->indicator_data_entries_id}}','{{$disapprove}}')">
                                            <svg width="1em" height="1em" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                <path d="M7 13C10.3137 13 13 10.3137 13 7C13 3.68629 10.3137 1 7 1C3.68629 1 1 3.68629 1 7C1 10.3137 3.68629 13 7 13Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.75 4.75L9.25 9.25M9.25 4.75L4.75 9.25" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </button>
                                        @endcan
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                            @else
                            <tr>
                                <td colspan="11">
                                @if(request('goal') == 14)
                                    Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.
                                @else
                                    @if(request('goal') == 17)
                                        Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.
                                    @else
                                        No record found
                                    @endif
                                @endif
                                </td>
                            </tr>
                            @endif
                        </tbody>
                    </table>
                </div>
                <nav>
                    <ul class="pagination">
                        {{$indicators->appends(request()->query())->links('pagination.bootstrap-4')}}
                    </ul>
                </nav>
            </div>
        </div>
    </div>
    @include('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter','defalut_goal_id'=> $default_goal])
</div>
<div id="disapprovalModal" class="disapproval-modal">
    <div class="disapproval-modal-content">
        <span class="close">&times;</span>
        <h2>Enter Disapproval Reason</h2>
        <textarea id="disapprovalReason" rows="5" maxlength="250" placeholder="Please enter disapproval reason here in max 250 characters"></textarea>
        <button id="submitDisapproval" class="btn btn-primary">Submit</button>
    </div>
</div>
{{-- Modal to display comments --}}
<div id="showComment" class="disapproval-modal hidden">
    <div class="disapproval-modal-content">
        <span class="close">&times;</span>
        <h2 class="modal-title">Reason For Disapproval</h2>
        <p id="comment" class="disapproval-reason"></p>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

<script src="{{asset('assets/js/indicator.js')}}"></script>

<script src="{{asset('assets/js/plugins/select2.js')}}"></script>

<script src="{{asset('assets/js/sweetAlert.js')}}"></script>
<script>
    $('#target').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#district').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#department').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#type').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    $('#status').select2({
        tags: true,
        tokenSeparators: [',', ' ']
    });

    document.getElementById('filter-form').addEventListener('submit', function(event) {
        event.preventDefault();

        var formData = new FormData(event.target);
        var searchParams = new URLSearchParams(formData);

        if (searchParams.get('type') == 'dif') {
            searchParams.delete('department');
        } else if (searchParams.get('type') == 'utif') {
            searchParams.delete('district');
        }

        window.location = window.location.pathname + '?' + searchParams.toString();
    });

    function validateInput(input, indicator_data_entry_id, unit) {
        var errorSpan = document.getElementById('status_error_indicator_' + indicator_data_entry_id);
        var saveButton = document.getElementById('save-button_' + indicator_data_entry_id);
        var approveButton = document.getElementById('approve_' + indicator_data_entry_id);
        var disapproveButton = document.getElementById('disapprove_' + indicator_data_entry_id);
        var successElement = document.getElementById('status_success_indicator_' + indicator_data_entry_id);
        var input = input.value;
        var unit = unit;
        input = Number(input);
        errorSpan.textContent = '';
        successElement.textContent = '';
        if (unit == 'Percentage' && input > 100) {
            errorSpan.textContent = '';
            errorSpan.textContent = 'Indicator value can not be greater than 100% for Percentage unit';
            saveButton.classList.add('inactive');
            saveButton.disabled = true;
            saveButton.addEventListener('click', preventClick);
            if (approveButton !== null) {
                approveButton.disabled = true;
                approveButton.addEventListener('click', preventClick);
            }
            if (disapproveButton !== null) {
                disapproveButton.disabled = true;
                disapproveButton.addEventListener('click', preventClick);
            }
        }else if(unit == 'Percentage' && input < 0){
            errorSpan.textContent = '';
            errorSpan.textContent = 'Indicator value can not be less than 0% for Percentage unit';
            saveButton.classList.add('inactive');
            saveButton.disabled = true;
            saveButton.addEventListener('click', preventClick);
            if (approveButton !== null) {
                approveButton.disabled = true;
                approveButton.addEventListener('click', preventClick);
            }
            if (disapproveButton !== null) {
                disapproveButton.disabled = true;
                disapproveButton.addEventListener('click', preventClick);
            }
        } else {
            errorSpan.textContent = '';
            saveButton.classList.remove('inactive');
            saveButton.disabled = false;
            approveButton.disabled = false;
            disapproveButton.disabled = false;
            saveButton.removeEventListener('click', preventClick);
            approveButton.removeEventListener('click', preventClick);
            disapproveButton.removeEventListener('click', preventClick);
        }
    }

    function save(indicator_data_entry_id, confirmOverride = false) {
        var inputValue = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id).value;
        var saveButton = document.getElementById('save-button_' + indicator_data_entry_id);
        var approveButton = document.getElementById('approve_' + indicator_data_entry_id);
        var disapproveButton = document.getElementById('disapprove_' + indicator_data_entry_id);
        var successElement = document.getElementById('status_success_indicator_' + indicator_data_entry_id);
        var errorElement = document.getElementById('status_error_indicator_' + indicator_data_entry_id);
        var statusElement = document.getElementById('status_indicator_' + indicator_data_entry_id);
        var inputElement = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id);

        if (inputValue === '') {
            successElement.textContent = '';
            errorElement.textContent = 'Indicator value can not be empty';
            return;
        }

        if (isNaN(inputValue)) {
            successElement.textContent = '';
            errorElement.textContent = 'Indicator value must be a number';
            return;
        }

        $.ajax({
            url: '{{ route("indicator-data-entries.update-indicator-value") }}',
            type: 'POST',
            data: {
                _token: '{{ csrf_token() }}',
                indicator_data_entry_id: indicator_data_entry_id,
                indicator_value: inputValue,
                confirm_override: confirmOverride ? 1 : 0
            },
            success: function(response) {
                // Handle the warning modal if the value is greater than 20%
                if (response.status === 'error') {
                    Swal.fire({
                        title: 'Are you sure?',
                        text: response.message,
                        icon: 'warning',
                        showCancelButton: true,
                        confirmButtonColor: '#3085d6',
                        cancelButtonColor: '#d33',
                        confirmButtonText: 'Save Anyway'
                    }).then((result) => {
                        if (result.isConfirmed) {
                            // Call save function again with confirmOverride set to true
                            save(indicator_data_entry_id, true);
                        }
                    });
                    return;
                }

                if (response.status === 'success') {
                    successElement.textContent = '';
                    errorElement.textContent = '';
                    successElement.textContent = response.message;
                    statusElement.textContent = response.indicator_status;

                    const existingCommentBtn = document.getElementById('comment_' + response.indicator_data_entries_id);
                    if (existingCommentBtn) {
                        existingCommentBtn.remove();
                    }

                    if (response.indicator_status == 'Approved') {
                        statusElement.className = '';
                        statusElement.classList.add('text-success');
                    } else {
                        statusElement.classList.remove('text-primary');
                    }

                    if (response.input_disable == 'yes') {
                        inputElement.disabled = true;
                        saveButton.disabled = true;
                    }
                } else {
                    successElement.textContent = '';
                    errorElement.textContent = response.message;
                    if (response.input_disable == 'yes') {
                        inputElement.disabled = true;
                        saveButton.disabled = true;
                    }
                }
            },
            error: function(response) {
                successElement.textContent = '';
                errorElement.textContent = response.responseJSON.message;
            }
        });
    }

    function preventClick(event) {
        event.preventDefault();
        event.stopPropagation();
    }

    function markApproveDisapprove(indicator_data_entry_id, action) {
        var inputValue = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id).value;
        var successElement = document.getElementById('status_success_indicator_' + indicator_data_entry_id);
        var errorElement = document.getElementById('status_error_indicator_' + indicator_data_entry_id);
        successElement.textContent = '';
        errorElement.textContent = '';

        if (inputValue === '') {
            errorElement.textContent = 'Indicator value can not be empty';
            return;
        }

        if (isNaN(inputValue) || inputValue > 100) {
            successElement.textContent = '';
            errorElement.textContent = '';
            errorElement.textContent = 'Indicator value must be a number less than or equal to 100';
            return;
        }
        if (action === '') {
            var modal = document.getElementById('disapprovalModal');
            modal.style.display = 'none';
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'You can not approve/disapprove this entry',
            });
            return false;
        }

        var statusElement = document.getElementById('status_indicator_' + indicator_data_entry_id);
        var inputElement = document.getElementById('indicator_data_entry_id_' + indicator_data_entry_id);
        var saveButton = document.getElementById('save-button_' + indicator_data_entry_id);
        var approveButton = document.getElementById('approve_' + indicator_data_entry_id);
        var disapproveButton = document.getElementById('disapprove_' + indicator_data_entry_id);

        if (action === 'approve') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'You want to approve this entry?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, approve it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    $.ajax({
                        url: '{{ route("indicator-data-entries.approve-disapprove") }}',
                        type: 'POST',
                        data: {
                            _token: '{{ csrf_token() }}',
                            indicator_data_entry_id: indicator_data_entry_id,
                            indicator_value: inputValue,
                            action: action // 'approve' or 'disapprove'
                        },
                        success: function(response) {
                            if (response.status === 'success') {
                                const existingCommentBtn = document.getElementById('comment_' + response.indicator_data_entries_id);
                                if (existingCommentBtn) {
                                    existingCommentBtn.remove();
                                }
                                successElement.textContent = '';
                                errorElement.textContent = '';
                                statusElement.textContent = response.indicator_status;
                                if (response.indicator_status == 'Approved') {
                                    statusElement.className = '';
                                    statusElement.classList.add('text-success');
                                } else {
                                    statusElement.classList.remove('text-primary');
                                }
                                if (response.input_disable == 'yes') {
                                    inputElement.disabled = true;
                                    saveButton.disabled = true;
                                    approveButton.disabled = true;
                                    disapproveButton.disabled = true;
                                }
                                Swal.fire({
                                    icon: 'success',
                                    title: 'Success',
                                    text: response.message,
                                });
                            } else {
                                successElement.textContent = '';
                                errorElement.textContent = '';
                                if (response.input_disable == 'yes') {
                                    inputElement.disabled = true;
                                    saveButton.disabled = true;
                                    approveButton.disabled = true;
                                    disapproveButton.disabled = true;
                                }
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.message,
                                });
                            }
                        },
                        error: function(response) {
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: response.responseJSON.message,
                            });
                        }
                    });
                }
            });
        }

        // If action is 'disapprove', show popup with input field
        else if (action === 'disapprove') {
            Swal.fire({
                title: 'Are you sure?',
                text: 'You want to disapprove this entry?',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, disapprove it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    // Show modal
                    var modal = document.getElementById('disapprovalModal');
                    modal.style.display = 'block';

                    // Close modal when clicking on close button or outside modal
                    var closeBtn = document.querySelector('.close');
                    window.onclick = function(event) {
                        if (event.target == modal) {
                            modal.style.display = 'none';
                        }
                    };
                    closeBtn.onclick = function() {
                        modal.style.display = 'none';
                    };

                    // Handle ESC key press to close modal
                    document.addEventListener('keydown', function(event) {
                        if (event.key === 'Escape') {
                            modal.style.display = 'none';
                        }
                    });

                    // Submit disapproval reason
                    var submitBtn = document.getElementById('submitDisapproval');
                    submitBtn.onclick = function() {
                        var disapprovalReason = document.getElementById('disapprovalReason').value.trim();
                        if (disapprovalReason === '') {
                            modal.style.display = 'none';
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Disapproval reason can not be empty',
                            });
                            return;
                        } else if (disapprovalReason.length > 250) {
                            modal.style.display = 'none';
                            Swal.fire({
                                icon: 'error',
                                title: 'Error',
                                text: 'Disapproval reason must be less than 250 characters',
                            });
                            return;
                        }

                        // Send AJAX request with disapproval reason
                        $.ajax({
                            url: '{{ route("indicator-data-entries.approve-disapprove") }}',
                            type: 'POST',
                            data: {
                                _token: '{{ csrf_token() }}',
                                indicator_data_entry_id: indicator_data_entry_id,
                                action: action,
                                indicator_value: inputValue,
                                disapproval_reason: disapprovalReason
                            },
                            success: function(response) {
                                if (response.status === 'success') {
                                    modal.style.display = 'none';
                                    statusElement.textContent = response.indicator_status;
                                    if (response.indicator_status == 'Disapproved') {
                                        statusElement.className = '';
                                        statusElement.classList.add('text-danger');
                                        // Clear any existing comment button for this indicator (optional)
                                        const existingCommentBtn = document.getElementById('comment_' + response.indicator_data_entries_id);
                                        if (existingCommentBtn) {
                                            existingCommentBtn.remove();
                                        }

                                        // Only add comment button if disapproval_reason exists and is not empty
                                        if (response.disapproval_reason && response.disapproval_reason.trim() !== '') {
                                            // Create the button element
                                            const commentBtn = document.createElement('button');
                                            commentBtn.id = 'comment_' + response.indicator_data_entries_id;
                                            commentBtn.className = 'comment-icon-button';
                                            commentBtn.setAttribute('data-icon-toggle-title', 'View Comment');
                                            commentBtn.setAttribute('type', 'button');  // good practice for buttons
                                            
                                            // Set onclick attribute to call displayComment with params
                                            // Escape single quotes in disapproval_reason to avoid breaking JS
                                            const escapedReason = response.disapproval_reason.replace(/'/g, "\\'");
                                            commentBtn.setAttribute('onclick', `displayComment('${response.indicator_data_entries_id}', 'showComment', '${escapedReason}')`);
                                            
                                            // Create the img element inside the button
                                            const img = document.createElement('img');
                                            img.src = '{{ asset('assets/images/icons8-comment-32-black.png') }}'; // Adjust if needed
                                            img.alt = 'comment';
                                            img.style.height = '15px';
                                            img.style.width = '15px';
                                            
                                            commentBtn.appendChild(img);

                                            // Append the commentBtn somewhere visible
                                            // For example, next to the statusElement or a container you want
                                            statusElement.parentNode.appendChild(commentBtn);
                                        }
                                    } else {
                                        statusElement.className = '';
                                        statusElement.classList.remove('text-danger');
                                    }
                                    if (response.input_disable == 'yes') {
                                        inputElement.disabled = true;
                                        saveButton.disabled = true;
                                        approveButton.disabled = true;
                                        disapproveButton.disabled = true;
                                    }
                                    Swal.fire({
                                        icon: 'success',
                                        title: 'Success',
                                        text: response.message,
                                    });
                                } else {
                                    modal.style.display = 'none';
                                    if (response.input_disable == 'yes') {
                                        inputElement.disabled = true;
                                    }
                                    Swal.fire({
                                        icon: 'error',
                                        title: 'Error',
                                        text: response.message,
                                    });
                                }
                            },
                            error: function(response) {
                                modal.style.display = 'none';
                                Swal.fire({
                                    icon: 'error',
                                    title: 'Error',
                                    text: response.responseJSON.message,
                                });
                            }
                        });

                        // Close modal after submission
                        modal.style.display = 'none';
                    };

                }
            });
        }

        //#region
        /**
         * Below code handle the height of the SDG goals vertical scrollbar
         * it helps in making the sidebar goals scroll sticky
         */
        window.addEventListener("scroll", () => {
            let drawer = document.querySelector(".goals-drawer");
            let drawerContent = document.querySelector(`.goals-drawer-content`);
            let footer = document.querySelector(".cs-footer");
            let footerTop = footer.getBoundingClientRect().top;
            let drawerBottom = drawer.getBoundingClientRect().bottom;

            if (footerTop < drawerBottom) {
                let diff = 120 + (drawerBottom - footerTop);
                drawerContent.style.height = `calc(100vh - ${diff}px)`;
            } else {
                drawerContent.style.height = `calc(100vh - 120px)`;
            }
        });
        //#endregion
    }

    // Function to display comment in modal
    function displayComment(indicatorId, modalId, comment) {

        // Show modal
        var modal = document.getElementById('showComment');
        modal.style.display = 'block';
        var commentTextArea = document.getElementById('comment');
        commentTextArea.innerText = comment;

        // Close modal when clicking on close button or outside modal
        var closeBtn = document.querySelector('.close');
        window.onclick = function(event) {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        };
        $('.close').click(function() {
            modal.style.display = 'none';
        });

        // Handle ESC key press to close modal
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                modal.style.display = 'none';
            }
        });
    }
</script>
@endpush