@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add Indicator', 'custom_css' => 'assets/css/add-indicator.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">Indicator Framework</h1>
        </div>
        <div class="card-body">
            <form>
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label">Select Indicator Type</label>
                                <div class="form-check-wrapper">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckDefault2" />
                                        <label class="form-check-label" for="flexCheckDefault2">
                                            UTIF
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked" checked="" />
                                        <label class="form-check-label" for="flexCheckChecked">
                                            DIF
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-id">Indicator Id / Number <em>*</em></label>
                                <input type="text" class="form-control" id="indicator-id" placeholder="Enter Indicator Id" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="indicator-name">Indicator Name <em>*</em></label>
                                <input type="text" class="form-control" id="indicator-name" placeholder="Enter Indicator Name" />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="goals">Goals <em>*</em></label>
                                <select class="form-select" id="goals">
                                    <option value="" selected>-- Select Goal --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-no">Target Number <em>*</em></label>
                                <select class="form-select" id="target-no">
                                    <option value="" selected>-- Select Target --</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="assigning-dept">Assign Department <em>*</em></label>
                                <select class="form-select" id="assigning-dept">
                                    <option value="" selected>
                                        -- Select Departments --
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target-unit">Target Unit</label>
                                <input type="text" class="form-control" id="target-unit" placeholder="Enter the Target Unit " />
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="baseline">Baseline</label>
                                <input type="text" class="form-control" id="baseline" placeholder="Enter the Baseline " />
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="target">Target (2030-31)</label>
                                <select class="form-select" id="target">
                                    <option value="" selected>
                                        -- Select Departments --
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="table-responsive">
                                <table class="table table-sm cs-table text-center table-bordered">
                                    <thead>
                                        <tr>
                                            <th>2021-22</th>
                                            <th>2022-23</th>
                                            <th>2023-24</th>
                                            <th>2024-25</th>
                                            <th>2025-26</th>
                                            <th>2026-27</th>
                                            <th>2027-28</th>
                                            <th>2028-29</th>
                                            <th>2029-30</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                            <td>
                                                <div class="form-group cs-form-group mb-0">
                                                    <input type="text" class="form-control form-control-sm" />
                                                </div>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="tags">Tags</label>
                                <select class="form-select" id="tags">
                                    <option value="" selected>Search Tags</option>
                                </select>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <button type="reset" class="btn btn-muted me-2">
                                    Cancel
                                </button>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
@endpush