@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Graph Dashboard', 'custom_css' => 'assets/css/graph-dashboard.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="goals-drawer-wrapper show-drawer" data-goals="drawer-wrapper">
    <div class="page-content">
        @if (session('success'))
        <div class="alert alert-success" id="alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
        <div class="alert alert-danger" id="alert-danger">{{ session('error') }}</div>
        @endif
        @if($indicator_type == 'dif' && empty($indicators))
        <div class="alert alert-danger" id="alert-danger">No indicator available for the selected filter</div>
        @endif
        <div class="card-header cs-card-header">
            <h1 class="page-title">Dashboard</h1>
            <div class="card-header-action pe-2">
                @php
                if($user->hasRole('Admin') || $user->hasRole('Super Admin')) {
                $route = route('dif_indicator_listing');
                }else if($user->hasRole('District-User') || $user->hasRole('District-Approver') || $user->hasRole('District-HOD'))
                {
                $route = route('dif_indicator_listing');
                }else if($user->hasRole('Department-Approver') || $user->hasRole('Department-User') || $user->hasRole('Department-HOD'))
                {
                $route = route('utif_indicator_listing');
                }

                if(!empty(request('goal')))
                {
                $goal = request('goal');
                }else{
                $goal = $default_goal['goal_id'];
                }

                $target = request('target');
                $indicator = request('indicator');
                $department = request('department');
                $district = request('district');

                if(!empty(request('type')))
                {
                $type = request('type');
                }else{
                $type = $indicator_type;
                }

                if($type == 'utif') {
                $route = route('utif_indicator_listing', ['goal' => $goal, 'target' => $target, 'indicator' => $indicator, 'type' => $type, 'department' => $department]);
                } else if($type == 'dif') {
                $route = route('dif_indicator_listing', ['goal' => $goal, 'target' => $target, 'indicator' => $indicator, 'type' => $type, 'district' => $district]);
                } else if (($user->hasRole('Department-Approver') || $user->hasRole('Department-User') || $user->hasRole('Department-HOD'))) {
                $route = route('utif_indicator_listing', ['goal' => $goal, 'target' => $target, 'indicator' => $indicator]);
                } else if(($user->hasRole('District-User') || $user->hasRole('District-Approver')|| $user->hasRole('District-HOD'))) {
                $route = route('dif_indicator_listing', ['goal' => $goal, 'target' => $target, 'indicator' => $indicator]);
                }
                @endphp
                <a href="{{$route}}" class="btn btn-sm btn-success me-5" data-switch-to-list>Switch to List</a>
            </div>
        </div>
        <div class="graph-filters-strip">
            <form id="graph-filter" action="{{route('graph_dashboard.filter')}}" method="GET" style="width: 100%;" id="filter-form">
                <div class="filters-area">
                    <div class="form-group cs-form-group">
                        @if(request('goal') && !empty(request('goal')))
                        <input type="hidden" id="goal" name="goal" value="{{ request('goal') }}">
                        @else
                        <input type="hidden" id="goal" name='goal' value="{{$default_goal['goal_id']}}">
                        @endif
                        <label for="target" class="form-label">Target</label>
                        <select name="target" id="target" class="form-select form-select-sm" onchange="getIndicators();">
                            <option value="">-- Select Target --</option>
                            @foreach($targets as $target)
                            <option value="{{$target->target_id}}" @if((request('target')==$target->target_id) || (!empty($default_target) && $target->target_id == $default_target)) Selected @endif>{{$target->target_number.': '.$target->target_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    @if(auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Super Admin'))
                    <div class="form-group cs-form-group">
                        <label for="type" class="form-label">Indicator Type</label>
                        <select name="type" id="type" class="form-select form-select-sm" data-indicator-type>
                            <option value="dif" {{ request('type') == 'dif' ? 'selected' : '' }}>DIF</option>
                            <option value="utif" {{ request('type') == 'utif' ? 'selected' : '' }}>UTIF</option>
                        </select>
                    </div>
                    <div class="form-group cs-form-group @if(request('type')!='utif')d-none @endif" data-target-filter="utif">
                        <label for="department" class="form-label">Department</label>
                        <select name="department" id="department" class="form-select form-select-sm" data-select="department">
                            <option value="">-- Select Department --</option>
                            @foreach($departments as $department)
                            <option value="{{$department->id}}" @if((request('department')==$department->id) || ($indicator_type == 'utif' && !empty($default_department) && $default_department->count()>0 && $department->id == $default_department['id'])) Selected @endif >{{$department->department_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group cs-form-group @if(!empty(request('type')) && request('type')!='dif')d-none @endif" data-target-filter="dif">
                        <label for="district" class="form-label">District</label>
                        <select name="district" id="district" class="form-select form-select-sm">
                            <option value="">-- Select District --</option>
                            @foreach($districts as $district)
                            <option value="{{$district->id}}" @if((request('district')==$district->id) || ($indicator_type == 'dif' && !empty($default_district) && $default_district->count()>0 && $district->id == $default_district['id'])) Selected @endif >{{$district->district_name}}</option>
                            @endforeach
                        </select>
                    </div>
                    @else
                    <input type="hidden" id="type" name="type" value="{{$indicator_type}}">
                    @if(auth()->user()->hasRole('District-User') || auth()->user()->hasRole('District-Approver') || auth()->user()->hasRole('District-HOD'))
                    <input type="hidden" id="district" name="district" value="{{auth()->user()->district_id}}">
                    @else
                    <input type="hidden" id="department" name="department" value="{{auth()->user()->department_id}}">
                    @endif
                    @endif
                    <div class="form-group cs-form-group">
                        <label for="indicator" class="form-label">Indicator</label>
                        <select name="indicator" id="indicator" class="form-select form-select-sm">
                            @if(empty($indicators))
                            <option value="">No indicator available</option>
                            @else
                            <option value="">-- Select Indicator --</option>
                            @endif
                            @if(!empty($indicators))
                            @foreach($indicators as $indicator)
                            <option value="{{$indicator->id}}" {{ request('indicator') == $indicator->id ? 'selected' : '' }}>{{$indicator->indicator_number}}: {{$indicator->indicator_name}}</option>
                            @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="form-group cs-form-group form-group-btn">
                        <button type="submit" class="btn btn-success btn-sm pt-2 pb-2 ps-3 pe-3">
                            Submit
                        </button>
                        <a href="{{ route('graph_dashboard') }}" class="btn btn-danger btn-sm ms-2 pt-2 pb-2 ps-3 pe-3">Clear Filter</a>
                    </div>
                </div>
            </form>
            @if(auth()->user()->hasRole('Admin') || auth()->user()->hasRole('Super Admin'))
            <input type="hidden" name="include-select2-js" value="yes">
            @endif
        </div>

        <div class="container-fluid p-0">
            <input type="hidden" id="goal_name" name="goal_name" value="{{$default_goal['goal_name']}}">
            <div class="row">
                @if($indicator_type == 'dif')
                <div class="col-12">
                    <div class="graph-card">
                        <div class="graph-card-body">
                            <div id="sdg-goal-{{$default_goal['goal_id']}}" style="height: 450px">
                                <div id="loading-sdg-{{$default_goal['goal_id']}}">
                                    <div class="loader simple-loader" style="position:static !important;">
                                        <div class="loader-body" style="display: flex; justify-content: center; align-items: center; height: 500px;">
                                            <img src="{{asset('assets/images/sdg-loader.gif')}}" alt="Loading..." style="display: block; width: 100px;" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                @if($indicator_type == 'utif' && empty($indicators))
                <div class="col-12">
                    <div class="graph-card">
                        <div class="graph-card-body">
                            <div id="sdg-goal-{{$default_goal['goal_id']}}" style="height: 450px">
                                <div id="loading-sdg-{{$default_goal['goal_id']}}">
                                    <div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">No Indicator available for the selected filters</div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                @endif
                @if(!request('indicator') || empty(request('indicator')))
                @foreach($indicators as $indicator)
                <div class="col-lg-6">
                    <div class="graph-card">
                        <div class="graph-card-body">
                            <div id="indicator-graph-{{$indicator->id}}" style="height:500px">
                                <div id="loading-sdg-indicator-{{$indicator->id}}">
                                    <div class=" loader simple-loader" style="position:static !important;">
                                        <div class="loader-body" style="display: flex; justify-content: center; align-items: center; height: 500px;">
                                            <img src="{{asset('assets/images/sdg-loader.gif')}}" alt="Loading..." style="display: block; width: 100px;" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="graph-card-body-bottom-text">
                                <span class="me-3">Current Value:
                                    @if(!empty($indicator_data))
                                    @if(array_key_exists($indicator->id, $indicator_data))
                                    @if($indicator_data[$indicator->id] !='' && $indicator_data[$indicator->id] != null)
                                    {{ $indicator_data[$indicator->id] }}
                                    @else
                                    no data
                                    @endif
                                    @else
                                    no data
                                    @endif
                                    @else
                                    no data
                                    @endif
                                </span>
                                @if($indicator_type == 'dif')
                                <span>District: @if(!empty($default_district)) {{$default_district['district_name']}} @else N/A @endif</span>
                                @else
                                <span>Department: @if(!empty($default_department)) {{$default_department['department_name']}} @else N/A @endif</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endforeach
                @else
                @if(request('indicator') && !empty(request('indicator')))
                <input type="hidden" id="selected_indicator" name="indicator" value="{{request('indicator')}}">
                @endif
                <div class="col-lg-6">
                    <div class="graph-card">
                        <div class="graph-card-body">
                            <div id="indicator-graph-{{request('indicator')}}" style="height:500px">
                                <div id="loading-sdg-indicator-{{request('indicator')}}" style="display:none;">
                                    <div class=" loader simple-loader" style="position:static !important;">
                                        <div class="loader-body" style="display: flex; justify-content: center; align-items: center; height: 500px;">
                                            <img src="{{asset('assets/images/sdg-loader.gif')}}" alt="Loading..." style="display: block; width: 100px;" />
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="graph-card-body-bottom-text">
                                <span class="me-3">Current Value:
                                    @if(!empty($indicator_data))
                                    @if(array_key_exists(request('indicators'), $indicator_data))
                                    @if($indicator_data[request('indicators')] !='' || $indicator_data[request('indicators')] != null)
                                    {{ $indicator_data[request('indicators')] }}
                                    @else
                                    no data
                                    @endif
                                    @else
                                    no data
                                    @endif
                                    @else
                                    no data
                                    @endif
                                </span>
                                @if($indicator_type == 'dif')
                                <span>District: @if(!empty($default_district)) {{$default_district['district_name']}} @else N/A @endif</span>
                                @else
                                <span>Department: @if(!empty($default_department)) {{$default_department['department_name']}} @else N/A @endif</span>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
    @include('layouts.other.side_goal_filter', ['goals' => $goals,'form_action' => 'indicators.filter', 'defalut_goal_id' => $default_goal['goal_id']])
</div>
@endsection

@push('script')

<!-- Highcharts base library -->
<script src="{{ asset('assets/js/highchart/highchart.js') }}" defer></script>

<!-- Highcharts modules -->
<script src="{{ asset('assets/js/highchart/modules/exporting.js') }}" defer></script>
<script src="{{ asset('assets/js/highchart/modules/export-data.js') }}" defer></script>
<script src="{{ asset('assets/js/highchart/modules/accessibility.js') }}" defer></script>


<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

<!-- Graph Dashboard -->
<script src="{{asset('assets/js/graph-dashboard.js')}}" defer></script>

<script src="{{asset('assets/js/plugins/select2.js')}}"></script>

<script src="{{asset('assets/js/sweetAlert.js')}}"></script>

<script>
    $(document).ready(function() {

        document.getElementById('graph-filter').addEventListener('submit', function(event) {
            event.preventDefault();

            var formData = new FormData(event.target);
            var searchParams = new URLSearchParams(formData);

            if (searchParams.get('type') == 'dif') {
                searchParams.delete('department');
            } else if (searchParams.get('type') == 'utif') {
                searchParams.delete('district');
            }

            window.location = window.location.pathname + '?' + searchParams.toString();
        });
        //#region
        /**
         * Below code handle the height of the SDG goals vertical scrollbar
         * it helps in making the sidebar goals scroll sticky
         */
        window.addEventListener("scroll", () => {
            let drawer = document.querySelector(".goals-drawer");
            let drawerContent = document.querySelector(`.goals-drawer-content`);
            let footer = document.querySelector(".cs-footer");
            let footerTop = footer.getBoundingClientRect().top;
            let drawerBottom = drawer.getBoundingClientRect().bottom;

            if (footerTop < drawerBottom) {
                let diff = 120 + (drawerBottom - footerTop);
                drawerContent.style.height = `calc(100vh - ${diff}px)`;
            } else {
                drawerContent.style.height = `calc(100vh - 120px)`;
            }
        });
        //#endregion

        // Get the district and department IDs
        var districtId = $('#district').val();
        var departmentId = $('#department').val();
        var type = $('#type').val();
        var goal = $('#goal').val();
        var sdg_goal_name = $('#goal_name').val();
        var target = $('#target').val();
        var sdg_graph_flag = 0;

        var selected_indicator_id = $('#selected_indicator').val();
        if (!selected_indicator_id) {
            // Get all the option values (indicator ids)
            var indicatorIds = $('#indicator option').map(function() {
                return $(this).val();
            }).get();

            // Get all the option texts (indicator names)
            indicatorNames = $('#indicator option').map(function() {
                return $(this).text();
            }).get();
        } else {
            var indicatorIds = [selected_indicator_id];
            var indicatorNames = [$('#indicator option:selected').text()];
        }

        if (type == 'dif' && !districtId) {
            $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><br><br><div class="alert alert-danger" id="alert-danger" style="top:100px;">Please Select District to load the Graphs</div>');
            for (var i = 0; i < indicatorIds.length; i++) {
                $("#indicator-graph-" + indicatorIds[i]).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);">' + indicatorNames[i] + '</p><br><br><div class="alert alert-danger" id="alert-danger" style="top:100px;">Please Select District to load the Graphs</div>');
            }

        } else if (type == 'utif' && !departmentId) {
            for (var i = 0; i < indicatorIds.length; i++) {
                $("#indicator-graph-" + indicatorIds[i]).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);">' + indicatorNames[i] + '</p><br><br><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Please Select Department to load the Graphs</div>');
            }
        } else {
            if (goal == '') {
                $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><br><br><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Please Select Goal to load the Graphs</div>');
                for (var i = 0; i < indicatorIds.length; i++) {
                    $("#indicator-graph-" + indicatorIds[i]).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);">' + indicatorNames[i] + '</p><br><br><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Please Select Goal to load the Graphs</div>');
                }
                return;
            } else if (goal == 14) {
                $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.</div>');
            } else if (goal == 17) {
                $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.</div>');
            } else {
                if (type == 'dif') {
                    $.ajax({
                        url: "{{ route('graph_dashboard.get_indicator_graph_data') }}",
                        type: 'GET',
                        data: {
                            indicator: '',
                            type: type,
                            district: districtId,
                            goal: goal,
                            target: target,
                            sdg: 1,
                        },
                        beforeSend: function() {
                            // Show the loader before the request is sent
                            $("#loading-sdg-" + goal).show();
                        },
                        complete: function() {
                            // Hide the loader when the request is complete
                            $("#loading-sdg-" + goal).hide();
                            if (!selected_indicator_id) {
                                sendAjaxRequest(1);
                            } else {
                                sendAjaxRequest(0);
                            }
                        },
                        success: function(response) {
                            if (response && response.status == 'success') {
                                if (sdg_graph_flag == 0) {
                                    if (response.sdg_data && Object.keys(response.sdg_data).length > 0) {
                                        var goal_id = goal;
                                        var goal_name = response.goal_name;
                                        var goal_data = response.sdg_data;
                                        var sdg_start_year = response.sdg_start_year;
                                        var reporting_year = response.reporting_years;
                                        createSdgGraph(goal_id, goal_name, goal_data, sdg_start_year, reporting_year);
                                    } else {
                                        $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Data Not Found</div>');
                                    }
                                    sdg_graph_flag = 1;
                                }
                            } else {
                                $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">' + response.message + '</div>');
                            }

                        },
                        error: function(xhr, status, error) {
                            $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Error: ' + error + '</div>');
                        }
                    });
                } else {
                    if (!selected_indicator_id) {
                        sendAjaxRequest(1);
                    } else {
                        sendAjaxRequest(0);
                    }
                }
            }
        }

        // Function to send AJAX request
        function sendAjaxRequest(index) {
            if (indicatorIds[index] !== "") { // Skip the first two options ("Select Target First" and "Select Indicator")
                $.ajax({
                    url: "{{ route('graph_dashboard.get_indicator_graph_data') }}",
                    type: 'GET',
                    data: {
                        indicator: indicatorIds[index],
                        type: type,
                        district: districtId,
                        department: departmentId,
                        goal: goal,
                        target: target,
                        sdg: 0,
                    },
                    beforeSend: function() {
                        // Show the loader before the request is sent
                        $("#loading-sdg-indicator-" + indicatorIds[index]).show();
                    },
                    complete: function() {
                        if (index < indicatorIds.length - 1) {
                            $("#loading-sdg-indicator-" + indicatorIds[index]).hide();
                            // If there are more requests, send the next one
                            sendAjaxRequest(index + 1);
                        }
                    },
                    success: function(response) {
                        if (response && response.status == 'success') {

                            var indicatorId = indicatorIds[index]
                            var indicatorName = response.indicator_name;
                            var indicator_start_year = response.indicator_start_year;
                            var target_value = response.indicator_target_value;
                            var reporting_years = response.reporting_years;

                            if (response.indicator_graph_data && Object.keys(response.indicator_graph_data).length > 0) {
                                var indicator_graph_data = response.indicator_graph_data;
                                // Create the graph
                                createIndicatorsGraph(indicatorId, indicatorName, indicator_graph_data, indicator_start_year, target_value, reporting_years);
                            } else {
                                $("#indicator-graph-" + indicatorIds[index]).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);">' + indicatorNames[index] + '</p><br><br><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">' + response.message + '</div>');
                            }

                        } else {
                            $("#indicator-graph-" + indicatorIds[index]).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);">' + indicatorNames[index] + '</p><br><br><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">' + response.message + '</div>');
                        }

                    },
                    error: function(xhr, status, error) {
                        if (goal == 14) {
                            $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Goal 14 Life under Water: This particular SDGs does not pertain to J&K as the terrains of J&K are hilly and plain and have no costal areas within its boundaries.</div>');
                        } else if (goal == 17) {
                            $("#sdg-goal-" + goal).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);"><b>Index: SDG Goal ' + goal + ' (' + sdg_goal_name + ')</b></p><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Goal 17 Partnership for the goals: This particular SDG does not pertain to J&K.</div>');
                        } else {
                            $("#indicator-graph-" + indicatorIds[index]).html('<p style="font-size: 16px; color: rgb(51, 51, 51); font-weight: 400; font-family: inherit; fill: rgb(51, 51, 51);">' + indicatorNames[index] + '</p><br><br><div class="alert alert-danger mt-5" id="alert-danger" style="top:100px;">Error: ' + error + '</div>');
                        }
                    }
                });
            } else if (index < indicatorIds.length - 1) {
                // If the current option is empty but there are more options, send the next request
                sendAjaxRequest(index + 1);
            }
        }

        function createSdgGraph(goal_id, goal_name, goal_data, sdg_start_year, reporting_years) {

            var goalData = goal_data.split(",").map(Number);
            //#region for #1 graph
            var years = sdg_start_year.split("-");
            var year = years[0];
            year = parseInt(year);
            // Format the reporting years
            var formattedYears = reporting_years.map(function(yearRange) {
                var years = yearRange.split("-");
                return years[0] + "-" + years[1].substring(2);
            });
            Highcharts.chart("sdg-goal-" + goal_id, {
                title: {
                    text: "Index: SDG Goal " + goal_id + " (" + goal_name + ")",
                    align: "left",
                    style: {
                        fontSize: "16px",
                        fontWeight: "500",
                        fontFamily: "inherit",
                    },
                    marginBottom: 30,
                },

                yAxis: {
                    title: null,
                },

                xAxis: {
                    categories: formattedYears,
                    startOnTick: false,
                    endOnTick: false,
                    tickInterval: 1,
                    minPadding: 0,
                    maxPadding: 0,
                    min: 0,
                    max: formattedYears.length - 1, // Set max to the number of categories - 1
                },

                legend: {
                    layout: "horizontal",
                    align: "left",
                    verticalAlign: "bottom",
                },

                plotOptions: {
                    series: {
                        marker: {
                            symbol: "circle",
                        },
                        label: {
                            connectorAllowed: false,
                        },
                    },
                },

                series: [{
                    name: "Achieved",
                    color: "#FDC010",
                    data: goalData,
                }, ],
            });
            //#endregion
        }

        function createIndicatorsGraph(indicatorId, indicatorName, indicatorData, indicator_start_year, target_value, reporting_years) {
            var indicatorData = indicatorData.split(",").map(Number);
            var target_value = target_value.split(",").map(Number);
            var years = indicator_start_year.split("-");
            var year = parseInt(years[0]);
            // Format the reporting years
            var formattedYears = reporting_years.map(function(yearRange) {
                var years = yearRange.split("-");
                return years[0] + "-" + years[1].substring(2);
            });
            Highcharts.chart("indicator-graph-" + indicatorId, {
                title: {
                    text: indicatorName,
                    align: "left",
                    style: {
                        fontSize: "16px",
                        fontWeight: "500",
                        fontFamily: "inherit",
                    },
                    marginBottom: 30,
                },

                yAxis: {
                    title: null,
                },

                xAxis: {
                    categories: formattedYears,
                    startOnTick: false,
                    endOnTick: false,
                    tickInterval: 1,
                    min: 0,
                },

                legend: {
                    layout: "horizontal",
                    align: "left",
                    verticalAlign: "bottom",
                },

                plotOptions: {
                    series: {
                        marker: {
                            symbol: "circle",
                        },
                        label: {
                            connectorAllowed: false,
                        },
                    },
                },

                series: [{
                        name: "Achieved",
                        color: "#FDC010",
                        data: indicatorData,
                    },
                    {
                        name: "Target",
                        color: "#009900",
                        data: target_value,
                    },
                ],
            });
        }
        $('#type').change(function() {
            getIndicators();
            // Unselect the indicator from the dropdown
            // $('#indicator').val('');
            // $('#target').val('');
        });

        $('#target').select2({
            tokenSeparators: [',', ' ']
        });

        var includeSelect2Js = $('input[name="include-select2-js"]').val();

        if (includeSelect2Js === 'yes') {
            $('#district').select2({
                tokenSeparators: [',', ' ']
            });

            $('#department').select2({
                tokenSeparators: [',', ' ']
            });
        }

        $('#indicator').select2({
            tokenSeparators: [',', ' ']
        });

        $('#type').select2({
            tokenSeparators: [',', ' ']
        });
    });

    function getIndicators() {
        var target = $('#target').val();
        var type = $('#type').val();

        if (target) {
            $.ajax({
                url: "{{ route('graph_dashboard.get_indicators') }}",
                type: 'GET',
                data: {
                    target: target,
                    type: type,
                },
                success: function(response) {
                    if (response && Array.isArray(response)) {
                        var indicators = response;
                        if (indicators.length === 0) {
                            var options = '<option value="">No indicator available</option>';
                        } else {
                            var options = '<option value="">Select Indicator</option>';
                        }

                        indicators.forEach(function(indicator) {
                            options += '<option value="' + indicator.id + '">' + indicator.indicator_number + ': ' + indicator.indicator_name + '</option>';
                        });

                        // Remove old options and add new options
                        $('#indicator').html(options);

                    } else {
                        alert('No indicators returned from server');
                    }
                }
            });
        }
    }
</script>
@endpush