@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Add District', 'custom_css' => ''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif
    @if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
        <li>{{$error}}</li>
        @endforeach
    </ul>
    @endif
    <div class="card">
        <div class="card-header">
            <h1 class="page-title">District</h1>
        </div>
        <div class="card-body">
            <form id="create_district" method="POST" action="@if(!empty($district->id)) {{url('districts/'.$district->id)}} @else {{ url('districts') }} @endif">
                @csrf
                @if(!empty($district->id))
                @method('PUT')
                @endif
                <div class="container-fluid p-0">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="district-name">District Name <em>*</em></label>
                                <input type="text" class="form-control" id="district-name" name="district_name" value="@if(!empty($district)){{$district->district_name !=''?$district->district_name : ''}}@else{{old('district_name')}}@endif" placeholder="Enter District Name" data-rule-required="true" />
                                @error('district_name') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group cs-form-group">
                                <label class="form-label" for="district-code">District Code <em>*</em></label>
                                <input type="text" class="form-control" id="district-code" name="district_code" value="@if(!empty($district)){{$district->district_code !=''?$district->district_code : ''}}@else{{old('district_code')}}@endif" placeholder="Enter District Code" data-rule-required="true" />
                                @error('district_code') <span class="text-danger">{{ $message }}</span> @enderror
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="form-group cs-form-group">
                                <label class="form-label">Division</label>
                                <div class="form-check-wrapper">
                                    @php
                                    $jammu = '';
                                    $kashmir = '';
                                    @endphp
                                    @if(old('division')=='jammu')
                                    @php
                                    $jammu = 'checked';
                                    @endphp
                                    @else
                                    @if(old('division')=='kashmir')
                                    @php
                                    $kashmir = 'checked';
                                    @endphp
                                    @else
                                    @if(!empty($district) && strtolower($district->region) == 'jammu')
                                    @php
                                    $jammu = 'checked';
                                    @endphp
                                    @else
                                    @if(!empty($district) && strtolower($district->region) == 'kashmir')
                                    @php
                                    $kashmir = 'checked';
                                    @endphp
                                    @else
                                    @php
                                    $jammu = 'checked';
                                    @endphp
                                    @endif
                                    @endif
                                    @endif
                                    @endif
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="Jammu" id="flexCheckDefault2" name="division" {{$jammu}} />
                                        <label class="form-check-label" for="flexCheckDefault2">
                                            Jammu
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" value="Kashmir" name="division" id="flexCheckChecked" {{$kashmir}} />
                                        <label class="form-check-label" for="flexCheckChecked">
                                            Kashmir
                                        </label>
                                    </div>
                                    @error('division') <span class="text-danger">{{ $message }}</span> @enderror
                                </div>
                            </div>
                        </div>
                        <div class="col-12">
                            <div class="my-4 d-flex justify-content-end">
                                <a href="{{ url()->previous() }}" class="btn btn-danger me-2">Cancel</a>
                                <button type="submit" class="btn btn-success">
                                    Save
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection
@push('script')
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<script src="{{asset('assets/js/core/external.min.js')}}"></script>
<script src="{{ asset('assets/js/jquery.js')}}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}"></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script>
    $(document).ready(function() {
        $("#create_district").validate({
            errorClass: "text-danger",
            submitHandler: function(form) {
                // If form is valid, submit the form
                form.submit();
            }
        });
    });
</script>
@endpush