{{--
BOC
Task #156544 The Comparison on SDG India Index section should display a detailed comparison of SDG scores with other states.
This page is used to display the comparison of SDG scores with other states. This page is for the admin dashboard
@author Almaaz Ahmed
@date 18-12-2024
 --}}
 @extends('layouts.main_content.admin_pages_layout')

 @section('head')
 @include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - ', 'custom_css' => 'assets/css/dashboard-input.css'])
 @endsection
 
 @section('header')
 @include('layouts.header.admin_page_header')
 @endsection
 
 @section('sidebar')
 @include('layouts.sidebar.sidebar')
 @endsection
 
 @section('footer')
 @include('layouts.footer.footer')
 @endsection
 
 @section('content')
     <!-- Page Content Start -->
     <div class="page-content">
         @if (session('success'))
             <div class="alert alert-success alert-dismissible fade show" role="alert">
                 {{ session('success') }}
                 <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
             </div>
         @endif
 
         @if (session('error'))
             <div class="alert alert-danger alert-dismissible fade show" role="alert">
                 {{ session('error') }}
                 <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
             </div>
         @endif
         <h1 class="page-title mb-3">Dashboard Input</h1>
         <div class="card" data-tab-content="goal">
             <div class="card-body">
                 <p class="text-dark mb-3">
                     Please enter performance in the SDG India Index
                 </p>
                 <div class="container gx-0">
                     <div class="row">
                         <div class="col-lg-5">
                             <form id="add_comparision_data" class="validate_form" method="POST"
                                 action="{{ route('saveOrUpdateGoalComparison') }}">
                                 @csrf
                                 <fieldset data-form="1">
                                     <!-- Hidden field for goal ID -->
                                     <input type="hidden" name="goal_id" id="goal_id" value="all">
 
                                     <div class="form-group cs-form-group">
                                         <label for="year_dropdown" class="form-label">Year <em>*</em></label>
                                         <select name="dashboard_input_goal_year" id="dashboard_input_goal_year"
                                             class="form-select" data-goal-year data-rule-required="true">
                                             <option value="">-- Select Year --</option>
                                             @foreach ($allYears as $year)
                                                 <option value="{{ $year->id }}"
                                                     {{ (request('dashboard_input_goal_year') &&
                                                         request('dashboard_input_goal_year') == $year->reporting_year_base) ||
                                                     (!request('dashboard_input_goal_year') && isset($default_year) && $default_year->id == $year->id)
                                                         ? 'selected'
                                                         : '' }}>
                                                     {{ $year->reporting_year }}
                                                 </option>
                                             @endforeach
                                         </select>
                                         <!-- Display validation error for year -->
                                         @error('dashboard_input_goal_year')
                                             <span class="text-danger">{{ $message }}</span>
                                         @enderror
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="india_score" class="form-label">India Score <em>*</em></label>
                                         <input type="number" name="india_score" id="india_score" class="form-control"
                                             placeholder="Enter India Score" data-field="india"
                                             value="{{ old('india_score', 0) }}" data-rule-mandatorynumber="true" />
                                         <small class="helper-text">Min Value: 0, Max Value: 100</small>
                                         <!-- Display validation error for India Score -->
                                         @error('india_score')
                                             <span class="text-danger">{{ $message }}</span>
                                         @enderror
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="bestPerformingState" class="form-label">Best Performing State
                                             <em>*</em></label>
                                         <select name="bestPerformingState" id="bestPerformingState" class="form-select"
                                             data-field="best-performing-state" data-rule-required="true">
                                             <option value="">-- Select Best Performing State --</option>
                                             @foreach ($allStates as $state)
                                                 <option value="{{ $state->state_name }}">
                                                     {{ $state->state_name }}</option>
                                             @endforeach
                                         </select>
                                         <!-- Display validation error for Best Performing State -->
                                         @error('bestPerformingState')
                                             <span class="text-danger">{{ $message }}</span>
                                         @enderror
                                     </div>
 
                                     <div class="form-group cs-form-group d-none"
                                         data-field-wrapper="best-performing-state-input">
                                         <label for="best_state_score" class="form-label">Best Performing State Score
                                             <em>*</em></label>
                                         <input type="number" name="best_state_score" id="best_state_score"
                                             class="form-control" placeholder="Enter Best Performing State Score"
                                             data-field="best-performing-state-input"
                                             value="{{ old('best_state_score', 0) }}" data-rule-mandatorynumber="true" />
                                         <small class="helper-text">Min Value: 0, Max Value: 100</small>
                                         <!-- Display validation error for Best State Score -->
                                         @error('best_state_score')
                                             <span class="text-danger">{{ $message }}</span>
                                         @enderror
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="bestPerformingUT" class="form-label">Best Performing UT
                                             <em>*</em></label>
                                         <select name="bestPerformingUT" id="bestPerformingUT" class="form-select"
                                             data-field="best-performing-ut" data-rule-required="true">
                                             <option value="">-- Select Best Performing UT --</option>
                                             @foreach ($allUts as $ut)
                                                 <option value="{{ $ut->state_name }}">
                                                     {{ $ut->state_name }}</option>
                                             @endforeach
                                         </select>
                                         <!-- Display validation error for Best Performing State -->
                                         @error('bestPerformingUT')
                                             <span class="text-danger">{{ $message }}</span>
                                         @enderror
                                     </div>
 
                                     <div class="form-group cs-form-group d-none"
                                         data-field-wrapper="best-performing-ut-input">
                                         <label for="best_ut_score" class="form-label">Best Performing UT Score
                                             <em>*</em></label>
                                         <input type="number" name="best_ut_score" id="best_ut_score"
                                             class="form-control" placeholder="Enter Best Performing UT Score"
                                             data-field="best-performing-ut-input"
                                             value="{{ old('best_ut_score', 0) }}" data-rule-mandatorynumber="true" />
                                         <small class="helper-text">Min Value: 0, Max Value: 100</small>
                                         <!-- Display validation error for Best State Score -->
                                         @error('best_ut_score')
                                             <span class="text-danger">{{ $message }}</span>
                                         @enderror
                                     </div>
 
                                     <div class="form-group cs-form-group">
                                         <label for="jammu_and_kashmir_score" class="form-label">Jammu and Kashmir Score <em>*</em></label>
                                         <input type="number" name="jammu_and_kashmir_score" id="jammu_and_kashmir_score" class="form-control"
                                             placeholder="Enter Jammu and Kashmir Score" value="{{ old('jammu_and_kashmir_score') }}" data-rule-mandatorynumber="true"
                                              />
                                     </div>
 
                                     <div class="mt-4 d-flex justify-content-end">
                                         <button type="reset" class="btn btn-muted me-2">
                                             Cancel
                                         </button>
                                         <button type="submit" class="btn btn-success">
                                             Save
                                         </button>
                                     </div>
                                 </fieldset>
                             </form>
                         </div>
                         <div class="col-lg-7">
                             <!-- Goals List -->
                             <div class="map-options-list">
                                 <div class="map-options-sdg-icon active" role="button" data-mc-goal="mc-all">
                                     <img src="assets/images/sdg-wheel-goal.png" />
                                 </div>
                                 @foreach ($allGoals as $goal)
                                     <img role="button" src="assets/images/goals/100 x 100/goal_{{ $goal->id }}.png"
                                         data-mc-goal="mc-{{ $goal->id }}" />
                                 @endforeach
                             </div>
                             <!-- /Goals List -->
 
                             <!-- Goal Score Header -->
                             <div class="mc-header" data-mc-header="mc-all">
                                 <div class="mc-header-left">Composite Score</div>
                             </div>
                             <!-- /Goal Score Header -->
 
                             <!-- Goal Graph -->
                             <div data-wrapper="graph">
                                 <div id="mc-graph-goal"></div>
                                 <div class="miz-legend-wrapper vertical-ui">
                                     <div class="miz-legend__right">
                                         <div class="color-indicator-charts">
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-skyblue"></div>
                                                 <div class="ci__title">Achiever (100)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-green"></div>
                                                 <div class="ci__title">Front Runner (65 - 99)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-yellow"></div>
                                                 <div class="ci__title">Performer (50 - 64)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-red"></div>
                                                 <div class="ci__title">Aspirant (0 - 49)</div>
                                             </div>
                                             <div class="color-indicator__item">
                                                 <div class="ci__color ci__color-grey"></div>
                                                 <div class="ci__title">Information Unavailable</div>
                                             </div>
                                         </div>
                                     </div>
                                 </div>
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         </div>
     </div>
 
     <!-- /Page Content End -->
 @endsection
 @push('script')
     <!-- Library Bundle Script -->
     <script src="{{ asset('assets/js/core/libs.min.js') }}"></script>
 
     <!-- External Library Bundle Script -->
     <script src="{{ asset('assets/js/core/external.min.js') }}"></script>
 
     <!-- Dashboard Input Script -->
     <script>
         const comparisionDataUrl = "{{ route('comparisionData') }}";
         const allGoals = @json($allGoals);
     </script>
     <script src="{{ asset('assets/js/dashboard-input.js') }}" defer></script>
 
     <!-- App Script -->
     <script src="{{ asset('assets/js/hope-ui.js') }}" defer></script>
 
 
     <script src="{{ asset('assets/js/validation.js') }}"></script>
     <script src="{{ asset('assets/js/jquery.validate.js') }}" defer></script>
 
     <!-- Highcharts -->
     <script src="https://code.highcharts.com/maps/highmaps.js"></script>
     <script src="https://code.highcharts.com/highcharts-more.js"></script>
     <script src="https://code.highcharts.com/maps/modules/exporting.js"></script>
     <script src="https://code.highcharts.com/maps/modules/offline-exporting.js"></script>
     <script src="https://code.highcharts.com/maps/modules/data.js"></script>
     <script src="https://code.highcharts.com/maps/modules/accessibility.js"></script>
     <!-- Indicator JS -->
     <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/2.1.4/toastr.min.js" type="text/javascript"></script>
 
     <!-- Jquery UI Script -->
     <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
     <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
     <script>
        $(document).ready(function() {
            $(".validate_form").validate({
                errorClass: "text-danger",
                submitHandler: function(form) {
                    // If form is valid, submit the form
                    form.submit();
                }
            });
        });
    </script>
 @endpush
 