@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Create User', 'custom_css' =>''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">

            @if ($errors->any())
            <ul class="alert alert-warning">
                @foreach ($errors->all() as $error)
                <li>{{$error}}</li>
                @endforeach
            </ul>
            @endif

            <div class="card">
                <div class="card-header">
                    <h4>Create User
                        <a href="{{ url('users') }}" class="btn btn-danger float-end">Back</a>
                    </h4>
                </div>
                <div class="card-body">
                    <form action="{{ url('users') }}" method="POST" class="validate_form" id="validatejs">
                        @csrf
                        <div class="mb-3">
                            <label for="">Username</label>
                            <input type="text" name="username" class="form-control" value="{{old('username')}}" placeholder="Enter Username" data-rule-required="true"/>
                            @error('username') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        {{-- BOC: Added the email address field. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193 --}}
                        <div class="mb-3">
                            <label for="">Email Address</label>
                            <input type="email" name="email_address" class="form-control" value="{{old('email_address')}}" placeholder="Enter Email Address" data-rule-required="true" data-rule-email="true"/>
                            @error('email_address') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        {{-- EOC: Added the email address field. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193 --}}
                        <div class="mb-3">
                            <label for="">Password</label>
                            <input type="text" name="password" id="passwd" class="form-control" placeholder="Enter Password" data-rule-passwd="true" />
                            @error('password') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="">Roles</label>
                            <select name="role" id="role" class="form-select" data-rule-required="true">
                                <option value="">Select Role</option>
                                @foreach ($roles as $role)
                                <option value="{{ $role }}" {{old('role') == $role ? 'selected' : ''}}>{{ $role }}</option>
                                @endforeach
                            </select>
                            @error('role') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        {{-- BOC: Added the department and district dropdowns. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193 --}}
                        <div class="mb-3 d-none" id="department-section">
                            <label for="">Department</label>
                            <select name="department_id" id="department_id" class="form-select">
                                <option value="">Select Department</option>
                                @foreach ($departments as $department)
                                <option value="{{ $department->id }}" {{old('department_id') == $department->id ? 'selected' : ''}}>{{ $department->department_name }}</option>
                                @endforeach
                            </select>
                            @error('department_id') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="mb-3 d-none" id="district-section">
                            <label for="">District</label>
                            <select name="district_id" id="district_id" class="form-select">
                                <option value="">Select District</option>
                                @foreach ($districts as $district)
                                <option value="{{ $district->id }}" {{old('district_id') == $district->id ? 'selected' : ''}}>{{ $district->district_name }}</option>
                                @endforeach
                            </select>
                            @error('district_id') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        {{-- EOC: Added the department and district dropdowns. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193 --}}
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary">Save</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

{{-- BOC: Added the script to validate the password and encode it . BY ALMAAZ AHMED on 21-March-2025 PMS: 148137 --}}
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}" defer></script>
<script>
    function encryptPassword(e, form) {
        e.preventDefault(); // Prevent the form from submitting immediately

        // Get the password and confirm password field values
        var passwordInput = document.getElementById('passwd');

        var password = passwordInput.value;

        // Encrypt the password using your custom XOR + base64 encoding method
        var encodedPassword = encodePassword(password);

        // Set the encrypted values back to the input fields
        passwordInput.value = encodedPassword;

        // Optionally, toggle password visibility
        var input = $('#passwd');
        if (input.attr("type") === "text") {
            input.attr("type", "password");
        }

        // Now submit the form
        form.submit();
    }

    // Function to encode the password
    function encodePassword(password) {
        var encoded = "";
        var passwordStr = btoa(btoa(password)); // Double base64 encoding

        // XOR encryption with number 10
        for (var i = 0; i < passwordStr.length; i++) {
            var a = passwordStr.charCodeAt(i);
            var b = a ^ 10; // Bitwise XOR with number 10
            encoded += String.fromCharCode(b);
        }

        return btoa(encoded); // Final base64 encoding
    }
</script>

<script>
    $(document).ready(function () {
        $(".validate_form").validate({
            errorClass: "text-danger",
            submitHandler: function (form, event) {
                encryptPassword(event, form);
            }
        });

        // BOC: Added the script to show/hide the department/district dropdowns. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193
        // Handle role change to show/hide department/district dropdowns
        $('#role').change(function() {
            var selectedRole = $(this).val();
            $('#department-section').addClass('d-none');
            $('#district-section').addClass('d-none');
            
            if (selectedRole === 'Department-User' || selectedRole === 'Department-Approver' || selectedRole === 'Department-HOD') {
                $('#department-section').removeClass('d-none');
            } else if (selectedRole === 'District-User' || selectedRole === 'District-Approver' || selectedRole === 'District-HOD') {
                $('#district-section').removeClass('d-none');
            }
        });
        // EOC: Added the script to show/hide the department/district dropdowns. BY ALMAAZ AHMED on 05-May-2025 PMS: 160193
    });
</script>
{{-- EOC: Added the script to validate the password and encode it. BY ALMAAZ AHMED on 21-March-2025 PMS: 148137  --}}
@endpush