@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Change Password', 'custom_css' =>''])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">
            @if ($errors->any())
            <ul class="alert alert-warning">
                @foreach ($errors->all() as $error)
                <li>{{$error}}</li>
                @endforeach
            </ul>
            @endif

            <div class="card">
                <div class="card-header">
                    <h4>Change Password
                        <a href="{{ url('graph-dashboard') }}" class="btn btn-danger float-end">Back</a>
                    </h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('updatePassword') }}" method="POST" class="validate_form" id="validatejs">
                        @csrf
                        <div class="mb-3">
                            <label for="">Current Password</label>
                            <input type="password" name="old_password" id="old_password" class="form-control" placeholder="Enter Old Password" data-rule-required="true" data-rule-passwd="true"/>
                            @error('old_password') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="">New Password</label>
                            <input type="password" name="password" id="new_passwd" class="form-control" placeholder="Enter New Password" data-rule-required="true" data-rule-passwd="true" data-rule-oldpsswd="true"/>
                            @error('password') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="mb-3">
                            <label for="">Confirm Password</label>
                            <input type="password" name="password_confirmation" id="confirm_passwd" class="form-control" placeholder="Confirm New Password" data-rule-required="true" data-rule-equalTo="#new_passwd"/>
                            @error('password_confirmation') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                        <div class="mb-3">
                            <button type="submit" class="btn btn-primary">Change Password</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>
<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>
<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>
<script src="{{ asset('assets/js/validation.js') }}"></script>
<script src="{{ asset('assets/js/jquery.validate.js') }}" defer></script>
<script>
    $(document).ready(function () {
        $(".validate_form").validate({
            errorClass: "text-danger",
            submitHandler: function (form, event) {
                encryptPasswords(event, form);
            }
        });
    });

    function encryptPasswords(e, form) {
        e.preventDefault();
        var oldPassword = document.getElementById('old_password').value;
        var newPassword = document.getElementById('new_passwd').value;
        var confirmPassword = document.getElementById('confirm_passwd').value;

        document.getElementById('old_password').value = encodePassword(oldPassword);
        document.getElementById('new_passwd').value = encodePassword(newPassword);
        document.getElementById('confirm_passwd').value = encodePassword(confirmPassword);

        form.submit();
    }

    function encodePassword(password) {
        var encoded = "";
        var passwordStr = btoa(btoa(password));
        for (var i = 0; i < passwordStr.length; i++) {
            var a = passwordStr.charCodeAt(i);
            var b = a ^ 10;
            encoded += String.fromCharCode(b);
        }
        return btoa(encoded);
    }
</script>
@endpush
