@extends('layouts.main_content.admin_pages_layout')

@section('head')
@include('layouts.head.admin_pages_head', ['title'=> 'SDG J&K - Access Control', 'custom_css' =>'assets/css/access-control.css'])
@endsection

@section('header')
@include('layouts.header.admin_page_header')
@endsection

@section('sidebar')
@include('layouts.sidebar.sidebar')
@endsection

@section('footer')
@include('layouts.footer.footer')
@endsection

@section('loader')
@include('layouts.other.loader')
@endsection

@section('content')
<div class="page-content">
  <div class="card">
    <div class="card-header">
      <h1 class="page-title">Access Control -> Role : {{ $role->name }}<a href="{{ url('roles') }}" class="btn btn-danger me-2 float-end">Back</a></h1>
    </div>
    @if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
    @endif
    <div class="card-body">
      <form action="{{ url('roles/'.$role->id.'/give-permissions') }}" method="POST">
        @csrf
        @method('PUT')
        <div class="access-control-wrapper">
          <header class="access-control-header">
            <div class="form-group cs-form-group">
              <div class="form-check-wrapper">
                <div class="form-check">
                  <input class="form-check-input" type="checkbox" value="" id="selectAll" data-checkbox="select-all" />
                  <label class="form-check-label" for="selectAll">
                    Select/Deselect All
                  </label>
                </div>
              </div>
            </div>
          </header>
          <div class="access-control-content" data-checkbox="checkboxes">
            @foreach ($permissions as $module => $modulePermissions)
            <div class="checkbox-row-wrapper">
              <h2 class="sub-heading">{{ $module }}</h2>
              <div class="checkbox-row">
                @foreach ($modulePermissions as $permission)
                <div class="checkbox-item">
                  <div class="form-group cs-form-group">
                    <div class="form-check-wrapper">
                      <div class="form-check">
                        <input class="form-check-input" id="{{ Str::slug($permission['name']) }}" type="checkbox" name="permission[]" value="{{ $permission['name'] }}" {{ in_array($permission['id'], $rolePermissions) ? 'checked':'' }} />
                        <label class="form-check-label" for="{{ Str::slug($permission['name']) }}">
                          {{ $permission['name'] }}
                        </label>
                      </div>
                    </div>
                  </div>
                </div>
                @endforeach
              </div>
            </div>
            @endforeach
          </div>

          <div class="main-action-area m-3">
            <div class="d-flex justify-content-end align-items-center">
              <button type="submit" class="btn btn-success ms-2">
                Save
              </button>
            </div>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
</div>
@endsection

@push('script')
<!-- Library Bundle Script -->
<script src="{{asset('assets/js/core/libs.min.js')}}"></script>

<!-- External Library Bundle Script -->
<script src="{{asset('assets/js/core/external.min.js')}}"></script>

<!-- App Script -->
<script src="{{asset('assets/js/hope-ui.js')}}" defer></script>

<script src="{{ asset('assets/js/access-control.js') }}"></script>
@endpush