<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class sdgScoreCategorizationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Seed data for sdg_score_categorization table
        $sdgScoreCategorization = [
            [
                'id' => 1,
                'name' => 'Performer',
                'color_code' => '#ffc000',
                'min_value' => 50,
                'max_value' => 64,
            ],
            [
                'id' => 2,
                'name' => 'Front Runner',
                'color_code' => '#009900',
                'min_value' => 65,
                'max_value' => 99,
            ],
            [
                'id' => 3,
                'name' => 'Achiever',
                'color_code' => '#4bacc6',
                'min_value' => 100,
                'max_value' => 100,
            ],
            [
                'id' => 4,
                'name' => 'Aspirant',
                'color_code' => '#dc3746',
                'min_value' => 0,
                'max_value' => 40,
            ],
        ];

        foreach ($sdgScoreCategorization as $data) {
            DB::table('sdg_score_categorization')->insert($data);
        }
    }
}
