<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Faker\Factory;
use Illuminate\Support\Facades\DB;

class districtSdgIndexSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Factory::create();
        // Seed data for sdg_index table
        $reporting_years = [
            [
                'year' => '2017-2018',
                'id' => 1
            ],
            [
                'year' => '2018-2019',
                'id' => 2
            ],
            [
                'year' => '2019-2020',
                'id' => 3
            ],
            [
                'year' => '2020-2021',
                'id' => 4
            ],
            [
                'year' => '2021-2022',
                'id' => 5
            ],
            [
                'year' => '2022-2023',
                'id' => 6
            ],
            [
                'year' => '2023-2024',
                'id' => 7
            ],
            [
                'year' => '2024-2025',
                'id' => 8
            ],
        ];

        foreach ($reporting_years as $year) {
            for ($goalId = 1; $goalId <= 16; $goalId++) {
                for ($districtId = 1; $districtId <= 20; $districtId++) {
                    if ($goalId == 14) continue;
                    DB::table('district_sdg_indexes')->insert([
                        'district_id' => $districtId,
                        'goal_id' => $goalId,
                        'score' => $faker->randomFloat(2, 0, 100),
                        'reporting_year_id' => $year['id'],
                        'reporting_year' => $year['year'],
                    ]);
                }
            }
        }
    }
}
