<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Faker\Factory;

class TagSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $faker = Factory::create();

        $tags = [
            "Agriculture",
            "Health",
            "Education",
            "Environment",
            "Technology",
            "Economy",
            "Infrastructure",
            "Tourism",
            "Water",
            "Sanitation",
            "Energy",
            "Industry",
            "Innovation",
            "Equality",
            "Justice",
            "Peace",
            "Partnerships"
        ];
        foreach ($tags as $tag) {
            DB::table('tags')->insert([
                'tag' => $tag,
                'entity_type'=> $faker->randomElement(['scheme', 'target', 'goal', 'indicator']),
                'scheme_id' => rand(1, 51),
                'target_id' => rand(1, 39),
                'goal_id' => rand(1, 13),
                'indicator_id' => rand(1, 51),
                'status' => 'active', 
                'date_added' => now(),
                'date_updated' => now(),
            ]);
        }
    }
}
