<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class SchemeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $schemes = [
            'Universal Basic Income Initiative',
            'Microfinance and Entrepreneurship Development Program',
            'National Rural Employment Guarantee Act (NREGA)',
            'National Food Security Mission',
            'Integrated Child Development Services (ICDS)',
            'Pradhan Mantri Matru Vandana Yojana (PMMVY)',
            'Ayushman Bharat - Pradhan Mantri Jan Arogya Yojana (PMJAY)',
            'National Nutrition Mission (POSHAN Abhiyaan)',
            'Swachh Bharat Mission (SBM)',
            'Sarva Shiksha Abhiyan (SSA)',
            'Rashtriya Madhyamik Shiksha Abhiyan (RMSA)',
            'National Programme for Education of Girls at Elementary Level (NPEGEL)',
            'Beti Bachao Beti Padhao (BBBP)',
            'National Mission for Empowerment of Women (NMEW)',
            'Mahila Shakti Kendra (MSK)',
            'Jal Jeevan Mission (JJM)',
            'Swachh Bharat Mission (SBM) - Urban',
            'Atal Bhujal Yojana (ABY)',
            'Pradhan Mantri Ujjwala Yojana (PMUY)',
            'National Solar Mission (NSM)',
            'Ujala Scheme',
            'Mahatma Gandhi National Rural Employment Guarantee Act (MGNREGA)',
            'Pradhan Mantri Kaushal Vikas Yojana (PMKVY)',
            'Start-Up India',
            'Make in India',
            'Digital India',
            'Smart Cities Mission',
            'National Social Assistance Programme (NSAP)',
            'Deen Dayal Antyodaya Yojana (DAY-NRLM)',
            'Pradhan Mantri Jan Dhan Yojana (PMJDY)',
            'Atal Mission for Rejuvenation and Urban Transformation (AMRUT)',
            'Heritage City Development and Augmentation Yojana (HRIDAY)',
            'Pradhan Mantri Awas Yojana (PMAY) - Urban',
            'Swachh Bharat Mission (SBM) - Rural',
            'Waste-to-Wealth Mission',
            'Green India Mission (GIM)',
            'National Action Plan on Climate Change (NAPCC)',
            'National Adaptation Fund for Climate Change (NAFCC)',
            'National Mission for Sustainable Agriculture (NMSA)',
            'National Plan for Conservation of Aquatic Ecosystems (NPCA)',
            'Blue Revolution - Integrated Development and Management of Fisheries',
            'Project Dolphin',
            'National Mission for Green India (GIM)',
            'Project Tiger',
            'Green Highways (Plantation, Transplantation, Beautification & Maintenance)',
            'National Legal Services Authority (NALSA)',
            'Pradhan Mantri Jan Arogya Yojana (PMJAY)',
            'Digital India',
            'National Institution for Transforming India (NITI Aayog)',
            'Public Private Partnership (PPP) Model',
            'Sustainable Development Goals India Index'
        ];

        foreach ($schemes as $scheme) {
            DB::table('schemes')->insert([
                'scheme_name' => $scheme,
                'status' => 'active', // or 'inactive', depending on your needs
                'date_added' => now(),
                'date_updated' => now(),
            ]);
        }
    }
}
