<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ReportingYearSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $years = [
            '2011-2012',
            '2015-2016',
            '2019-2020',
            '2018-2019',
            '2020-2021',
            '2021-2022',
            '2022-2023',
            '2016-2017',
            '2017-2018',
            '2023-2024',
            '2014-2015',
            '2016-2018',
            '2013-2014',
            '2029-2030',
            '2012-2013'

        ];

        foreach ($years as $year) {
            DB::table('reporting_years')->insert([
                'reporting_year' => $year,
                'status' => 'active', 
                'date_added' => now(),
                'date_updated' => now(),
            ]);
        }
    }
}
