<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class IndicatorDataEntriesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Seed data for indicator_data_entries table
        $indicatorDataEntries = [
            [
                'indicator_id' => 1,
                'indicator_number' => '1.1.1',
                'indicator_name' => 'Proportion of population below the international poverty line',
                'target_id' => 1,
                'target_name' => 'By 2030, eradicate extreme poverty for all people everywhere, currently measured as people living on less than $1.25 a day',
                'goal_id' => 1,
                'goal_name' => 'End poverty in all its forms everywhere',
                'reporter_id' => 1,
                'reporter_name' => 'John Doe',
                'approver_id' => 2,
                'approver_name' => 'Jane Doe',
                'unit' => 'Percentage',
                'target_value' => 10.00,
                'numerator' => 5.00,
                'denominator' => 50.00,
                'multiplier' => 2.00,
                'indicator_value' => 10.00,
                'baseline_year_id' => 1,
                'baseline_year' => '2020',
                'reporting_year_id' => 2,
                'reporting_year' => '2021',
                'district_id' => 1,
                'district_name' => 'Kathmandu',
                'department_id' => 1,
                'department_name' => 'Department of Health',
                'indicator_normalised_value' => 0,
                'status' => 'Pending',
                'disapproval_reason' => null,
                'approval_date' => '2021-04-01',
                'disapproval_date' => null,
            ]
        ];

        foreach ($indicatorDataEntries as $indicatorDataEntry) {
            \App\Models\IndicatorDataEntry::create($indicatorDataEntry);
        }
        
    }
}
