<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class GoalSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $goals = [
            ['id' => 1, 'goal_name' => 'No Poverty', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 2, 'goal_name' => 'Zero Hunger', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 3, 'goal_name' => 'Good Health & Well-Being', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 4, 'goal_name' => 'Quality Education', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 5, 'goal_name' => 'Gender Equality', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 6, 'goal_name' => 'Clean Water & Sanitation', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 7, 'goal_name' => 'Affordable & Clean Energy', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 8, 'goal_name' => 'Decent Work & Economic Growth', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 9, 'goal_name' => 'Industry, Innovation & Infrastructure', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 10, 'goal_name' => 'Reduced Inequalities', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 11, 'goal_name' => 'Sustainable Cities and Communities', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 12, 'goal_name' => 'Responsible Consumption and Production', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 13, 'goal_name' => 'Climate Action', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 15, 'goal_name' => 'Life on Land', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
            ['id' => 16, 'goal_name' => 'Peace, Justice and Strong Institutions', 'status' => 'Active', 'date_added' => '2024-04-18 10:39:22', 'date_updated' => '2024-04-18 10:39:22'],
        ];

        foreach ($goals as $goal) {
            DB::table('goals')->insert([
                'id' => $goal['id'],
                'goal_name' => $goal['goal_name'],
                'status' => $goal['status'],
                'date_added' => Carbon::createFromFormat('Y-m-d H:i:s', $goal['date_added']),
                'date_updated' => Carbon::createFromFormat('Y-m-d H:i:s', $goal['date_updated']),
            ]);
        }
    }
}
