<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            $table->string('value_type', 55)->nullable()->collation('utf8mb4_unicode_ci')->after('unit');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            $table->dropColumn('value_type');
        });
    }
};
