<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            $table->decimal('indicator_value', 10, 2)->nullable()->change();
            $table->integer('indicator_normalised_value')->default(0)->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('indicator_data_entries', function (Blueprint $table) {
            $table->decimal('indicator_value', 10, 2);
            $table->integer('indicator_normalised_value')->default(0);
        });
    }
};
