<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('indicators', function (Blueprint $table) {
            $table->integer('min_value')->default(0)->after('unit');
            $table->integer('max_value')->default(100)->after('min_value');
            $table->enum('is_discontinue', ['No', 'Yes'])->default('No')->after('status');
            $table->enum('consider_for_ranking', ['No', 'Yes'])->default('No')->after('is_discontinue');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('indicators', function (Blueprint $table) {
            $table->dropColumn('min_value');
            $table->dropColumn('max_value');
            $table->dropColumn('is_discontinue');
            $table->dropColumn('consider_for_ranking');
        });
    }
};
