<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        DB::unprepared("
           DROP PROCEDURE IF EXISTS `calculateDistrictGoalScore`;
           CREATE PROCEDURE `calculateDistrictGoalScore`(IN `p_goal_id` int, IN `p_district_id` int, IN `p_reporting_year_id` int)
           BEGIN
                DECLARE reportingyear VARCHAR(10);
                DECLARE districtindicatorvalue INT;
                DECLARE districtindicatorcount INT;
                DECLARE calculatedarithmeticvalue INT;

                
                SELECT reporting_year
                INTO reportingyear
                FROM reporting_years
                WHERE id = p_reporting_year_id;

                
                SELECT SUM(indicator_normalised_value)
                INTO districtindicatorvalue
                FROM indicator_data_entries
                WHERE district_id = p_district_id AND goal_id = p_goal_id
                AND reporting_year_id = p_reporting_year_id AND unit != 'Absolute' AND status = 'Approved' AND indicator_id IN (SELECT id from indicators WHERE consider_for_ranking = 'Yes');

                
                SELECT COUNT(indicator_normalised_value)
                INTO districtindicatorcount
                FROM indicator_data_entries
                WHERE district_id = p_district_id AND goal_id = p_goal_id
                AND reporting_year_id = p_reporting_year_id AND unit != 'Absolute' AND status = 'Approved' AND indicator_id IN (SELECT id from indicators WHERE consider_for_ranking = 'Yes');

                
                SET calculatedarithmeticvalue = ROUND(districtindicatorvalue / districtindicatorcount);


                IF calculatedarithmeticvalue IS NOT NULL Then
                INSERT INTO district_sdg_indexes(district_id, goal_id, score, reporting_year_id, reporting_year, date_added, date_updated)
            VALUES (p_district_id, p_goal_id, calculatedarithmeticvalue, p_reporting_year_id, reportingyear, NOW(), NOW())
            ON DUPLICATE KEY UPDATE
                score = calculatedarithmeticvalue,
                date_updated = NOW();
                END IF;

            END;
        ");
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        DB::unprepared('DROP PROCEDURE IF EXISTS `calculateDistrictGoalScore`');
    }
};
