<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

class CreateSdgScoreCategorizationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sdg_score_categorizations', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedInteger('min_value');
            $table->unsignedInteger('max_value');
            $table->string('color_code');
            $table->engine = 'InnoDB';
        });

        // Insert data into the table
        $data = [
            ['name' => 'Performer', 'min_value' => 50, 'max_value' => 64, 'color_code' => '#ffc000'],
            ['name' => 'Front_Runner', 'min_value' => 65, 'max_value' => 99, 'color_code' => '#009900'],
            ['name' => 'Achiever', 'min_value' => 100, 'max_value' => 100, 'color_code' => '#4bacc6'],
            ['name' => 'Aspirant', 'min_value' => 0, 'max_value' => 49, 'color_code' => '#dc3746'],
        ];

        DB::table('sdg_score_categorizations')->insert($data);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sdg_score_categorizations');
    }
};

