<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tags', function (Blueprint $table) {
            $table->id();
            $table->string('tag', 50);
            $table->enum('entity_type', ['goal', 'target', 'indicator', 'scheme']);
            $table->unsignedBigInteger('goal_id')->nullable();
            $table->unsignedBigInteger('target_id')->nullable();
            $table->unsignedBigInteger('indicator_id')->nullable();
            $table->unsignedBigInteger('scheme_id');
            $table->enum('status', ['Inactive', 'Active'])->default('Active');
            $table->dateTime('date_added')->useCurrent();
            $table->dateTime('date_updated')->nullable();
            $table->engine = 'InnoDB';

            // Foreign key constraints
            $table->foreign('goal_id')->references('id')->on('goals');
            $table->foreign('target_id')->references('target_id')->on('targets');
            $table->foreign('indicator_id')->references('id')->on('indicators');
            $table->foreign('scheme_id')->references('scheme_id')->on('schemes');

            // Indexes
            $table->index('goal_id');
            $table->index('target_id');
            $table->index('indicator_id');
            $table->index('scheme_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tags');
    }
};
