<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::dropIfExists('indicator_data_entries');

        Schema::create('indicator_data_entries', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('indicator_id');
            $table->string('indicator_number', 30);
            $table->string('indicator_name', 500);
            $table->unsignedBigInteger('target_id');
            $table->string('target_name', 1000);
            $table->unsignedBigInteger('goal_id');
            $table->string('goal_name', 255);
            $table->unsignedBigInteger('reporter_id')->nullable();
            $table->string('reporter_name', 255)->nullable();
            $table->unsignedBigInteger('approver_id')->nullable();
            $table->string('approver_name', 255)->nullable();
            $table->enum('unit', ['Percentage', 'Absolute', 'Ratio'])->default('Percentage');
            $table->decimal('target_value', 10, 2);
            $table->decimal('numerator', 10, 2)->nullable()->comment('It cannot be null if unit is percentage or ratio');
            $table->decimal('denominator', 10, 2)->nullable()->comment('It cannot be null if unit is percentage or ratio');
            $table->decimal('multiplier', 10, 2)->nullable()->comment('It cannot be null if unit is percentage');
            $table->decimal('indicator_value', 10, 2);
            $table->unsignedBigInteger('baseline_year_id');
            $table->string('baseline_year', 10);
            $table->unsignedBigInteger('reporting_year_id');
            $table->string('reporting_year', 10);
            $table->unsignedBigInteger('district_id')->nullable();
            $table->string('district_name', 255)->nullable();
            $table->unsignedBigInteger('department_id')->nullable();
            $table->string('department_name', 255)->nullable();
            $table->integer('indicator_normalised_value')->default(0)->nullable();
            $table->enum('status', ['Pending', 'Approved', 'Disapproved','Sent_to_approver'])->default('Pending');
            $table->bigInteger('update_count')->default(0);
            $table->string('disapproval_reason', 255)->nullable();
            $table->date('approval_date')->nullable();
            $table->date('disapproval_date')->nullable();
            $table->timestamps();
            $table->engine = 'InnoDB';

            $table->foreign('indicator_id')->references('id')->on('indicators');
            $table->foreign('target_id')->references('target_id')->on('targets');
            $table->foreign('goal_id')->references('id')->on('goals');
            $table->foreign('reporting_year_id')->references('id')->on('reporting_years');
            $table->foreign('district_id')->references('id')->on('districts');
            $table->foreign('department_id')->references('id')->on('departments');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('indicator_data_entries');
    }
};
