<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('indicators', function (Blueprint $table) {
            $table->id();
            $table->string('indicator_number', 30);
            $table->string('indicator_name', 500);
            $table->enum('unit', ['Percentage', 'Absolute', 'Ratio'])->default('Percentage');
            $table->unsignedBigInteger('department_id')->nullable();
            $table->unsignedBigInteger('scheme_id')->nullable();
            $table->unsignedBigInteger('target_id');
            $table->unsignedBigInteger('goal_id');
            $table->enum('is_positive_indicator', ['Positive', 'Negative'])->default('Positive');
            $table->enum('is_utif', ['No', 'Yes'])->default('No');
            $table->enum('is_dif', ['No', 'Yes'])->default('No');
            $table->enum('status', ['Inactive', 'Active'])->default('Active');
            $table->dateTime('date_added')->useCurrent();
            $table->dateTime('date_updated')->nullable();
            $table->engine = 'InnoDB';
            // Foreign key constraints
            $table->foreign('department_id')->references('id')->on('departments');
            $table->foreign('scheme_id')->references('scheme_id')->on('schemes');
            $table->foreign('target_id')->references('target_id')->on('targets');
            $table->foreign('goal_id')->references('id')->on('goals');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('indicators');
    }
};
