$(document).ready(function () {
    //#region
    /**
     * Below code will handle the tab menu click event
     */
    $("[data-toggle-tab-btn]").click(function () {
        let clickedTab = $(this).data("toggle-tab-btn");
        $(this)
            .parents("[data-toggle-tab]")
            .find("[data-toggle-tab-btn]")
            .removeClass("active");
        $(this).addClass("active");
        $(this)
            .parents("[data-toggle-tab]")
            .find("[data-toggle-tab-content]")
            .addClass("d-none");
        $(this)
            .parents("[data-toggle-tab]")
            .find(`[data-toggle-tab-content="${clickedTab}"]`)
            .removeClass("d-none");

        if (clickedTab == 2) {
            if ($("#department2").length && $("#department2").is("select")) {
                $("#department2").select2({
                    tokenSeparators: [",", " "],
                });
            }

            $("#financial_year2").select2({
                placeholder:
                    "-- Select Financial Year --".padEnd(40) + "\u25BC",
                allowClear: true,
                closeOnSelect: false,
            });

            $("#financial_year2").on("select2:select", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is selected, select all options and disable them
                    $("#financial_year2 option").prop("selected", true);
                    $("#financial_year2").trigger("change.select2");
                }
            });

            $("#financial_year2").on("select2:unselect", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is unselected, unselect and enable all options
                    $("#financial_year2 option").prop("selected", false);
                    $("#financial_year2").trigger("change.select2");
                }
            });

            $("#goal2").select2({
                placeholder: "-- Select Goal --".padEnd(50) + "\u25BC",
                allowClear: true,
                closeOnSelect: false,
            });

            $("#goal2").on("select2:select", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is selected, select all options and disable them
                    $("#goal2 option").prop("selected", true);
                    $("#goal2").trigger("change.select2");
                }
            });

            $("#goal2").on("select2:unselect", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is unselected, unselect and enable all options
                    $("#goal2 option").prop("selected", false);
                    $("#goal2").trigger("change.select2");
                }
            });
        }
        if (clickedTab == 3) {
            if ($("#district3").length && $("#district3").is("select")) {
                $("#district3").select2({
                    tokenSeparators: [",", " "],
                });
            }

            $("#financial_year3").select2({
                placeholder:
                    "-- Select Financial Year --".padEnd(40) + "\u25BC",
                allowClear: true,
                closeOnSelect: false,
            });

            $("#financial_year3").on("select2:select", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is selected, select all options and disable them
                    $("#financial_year3 option").prop("selected", true);
                    $("#financial_year3").trigger("change.select2");
                }
            });

            $("#financial_year3").on("select2:unselect", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is unselected, unselect and enable all options
                    $("#financial_year3 option").prop("selected", false);
                    $("#financial_year3").trigger("change.select2");
                }
            });

            $("#goal3").select2({
                placeholder: "-- Select Goal --".padEnd(50) + "\u25BC",
                allowClear: true,
                closeOnSelect: false,
            });

            $("#goal3").on("select2:select", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is selected, select all options and disable them
                    $("#goal3 option").prop("selected", true);
                    $("#goal3").trigger("change.select2");
                }
            });

            $("#goal3").on("select2:unselect", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is unselected, unselect and enable all options
                    $("#goal3 option").prop("selected", false);
                    $("#goal3").trigger("change.select2");
                }
            });
        }
    });
    //#endregion

    //#region for first tab logic
    $("[data-radio]").click(function () {
        let targetVal = $(this).attr("data-radio");
        $("[data-field]").addClass("d-none");
        $(`[data-field="${targetVal}"]`).removeClass("d-none");
    });
    //#endregion

    //#region for generate report
    $("form").submit(function (e) {
        e.preventDefault();
    });
    $(`[data-generate-report]`).click(function () {
        const target = $(this).attr("data-generate-report");
        $(`[data-report-wrapper="${target}"]`).removeClass("d-none");
    });
    //#endregion

    //#region for financial_year select2
    $("#financial_year1").select2({
        placeholder: "-- Select Financial Year --".padEnd(40) + "\u25BC",
        allowClear: true,
        closeOnSelect: false,
    });

    $("#financial_year1").on("select2:select", function (e) {
        var data = e.params.data;
        if (data.id === "all") {
            // If 'all' is selected, select all options and disable them
            $("#financial_year1 option").prop("selected", true);
            $("#financial_year1").trigger("change.select2");
        }
    });

    $("#financial_year1").on("select2:unselect", function (e) {
        var data = e.params.data;
        if (data.id === "all") {
            // If 'all' is unselected, unselect and enable all options
            $("#financial_year1 option").prop("selected", false);
            $("#financial_year1").trigger("change.select2");
        }
    });
    //#endregion

    //#region for goals select2
    $("#goal1").select2({
        placeholder: "-- Select Goal --".padEnd(50) + "\u25BC",
        allowClear: true,
        closeOnSelect: false,
    });

    $("#goal1").on("select2:select", function (e) {
        var data = e.params.data;
        if (data.id === "all") {
            // If 'all' is selected, select all options and disable them
            $("#goal1 option").prop("selected", true);
            $("#goal1").trigger("change.select2");
        }
    });

    $("#goal1").on("select2:unselect", function (e) {
        var data = e.params.data;
        if (data.id === "all") {
            // If 'all' is unselected, unselect and enable all options
            $("#goal1 option").prop("selected", false);
            $("#goal1").trigger("change.select2");
        }
    });
    //#endregion

    //#region for districts select2
    if ($("#district1").length && $("#district1").is("select")) {
        $("#district1").select2({
            placeholder: "-- Select District --".padEnd(50) + "\u25BC",
            allowClear: true,
            closeOnSelect: false,
        });

        $("#district1").on("select2:select", function (e) {
            var data = e.params.data;
            if (data.id === "all") {
                // If 'all' is selected, select all options and disable them
                $("#district1 option").prop("selected", true);
                $("#district1").trigger("change.select2");
            }
        });

        $("#district1").on("select2:unselect", function (e) {
            var data = e.params.data;
            if (data.id === "all") {
                // If 'all' is unselected, unselect and enable all options
                $("#district1 option").prop("selected", false);
                $("#district1").trigger("change.select2");
            }
        });
    }
    //#endregion

    var includeRadioButtonJs = $('input[name="include-radio-button-js"]').val();

    if (includeRadioButtonJs === "yes") {
        $("#flexRadioDefault1-1").on("click", function () {
            $("#district1").select2({
                placeholder: "-- Select District --".padEnd(50) + "\u25BC",
                allowClear: true,
                closeOnSelect: false,
            });

            $("#district1").on("select2:select", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is selected, select all options and disable them
                    $("#district1 option").prop("selected", true);
                    $("#district1").trigger("change.select2");
                }
            });

            $("#district1").on("select2:unselect", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is unselected, unselect and enable all options
                    $("#district1 option").prop("selected", false);
                    $("#district1").trigger("change.select2");
                }
            });

            // Unselect all options in the dropdown except the placeholder
            $("#department1 option:not([value=''])").prop("selected", false);
            $("#department1").trigger("change.select2");
        });

        $("#flexRadioDefault1-2").on("click", function () {
            $("#department1").select2({
                placeholder: "-- Select Department --".padEnd(40) + "\u25BC",
                allowClear: true,
                closeOnSelect: false,
            });

            $("#department1").on("select2:select", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is selected, select all options and disable them
                    $("#department1 option").prop("selected", true);
                    $("#department1").trigger("change.select2");
                }
            });

            $("#department1").on("select2:unselect", function (e) {
                var data = e.params.data;
                if (data.id === "all") {
                    // If 'all' is unselected, unselect and enable all options
                    $("#department1 option").prop("selected", false);
                    $("#department1").trigger("change.select2");
                }
            });
            // Unselect all options in the dropdown except the placeholder
            $("#district1 option:not([value=''])").prop("selected", false);
            $("#district1").trigger("change.select2");
        });
    }
});
