$(document).ready(function () {
  //#region
  /**
   * Below code will handle the click event of the goal spinner items
   */
  $("[data-goal-id]").click(function () {
    const selectedGoalId = $(this).data("goal-id");
    console.log(selectedGoalId);
  });
  $("[data-goal-id]").mouseenter(function () {
    $("[data-goal-id]").css("opacity", "0.5");
    $(this).css("opacity", "1");
  });
  $("[data-goal-id]").mouseleave(function () {
    $("[data-goal-id]").css("opacity", "1");
  });
  //#endregion

  //#region
  /**
   * Below code will handle the tab menu click event
   */
  $("[data-toggle-tab-btn]").click(function () {
    debugger
    let clickedTab = $(this).data("toggle-tab-btn");
    $(this)
      .parents("[data-toggle-tab]")
      .find("[data-toggle-tab-btn]")
      .removeClass("active");
    $(this).addClass("active");
    $(this)
      .parents("[data-toggle-tab]")
      .find("[data-toggle-tab-content]")
      .addClass("d-none");
    $(this)
      .parents("[data-toggle-tab]")
      .find(`[data-toggle-tab-content="${clickedTab}"]`)
      .removeClass("d-none");

    if (clickedTab == 2) {
      $('[data-content="know-calculation-btn"]').addClass("d-none");
      $('[data-content="score-board"]').addClass("d-none");
      $('[data-content="ut-score-board"]').removeClass("d-none");
    } else {
      $('[data-content="know-calculation-btn"]').removeClass("d-none");
      $('[data-content="score-board"]').removeClass("d-none");
      $('[data-content="ut-score-board"]').addClass("d-none");
    }
  });
  //#endregion

  //#region
  /**
   * Function to handle the click events on the goals
   */
  $("[data-mc-goal]").click(function () {
    const TITLES = {
      "mc-1": "1. No Poverty",
      "mc-2": "2. Zero Hunger",
      "mc-3": "3. Good Health & Well-Being",
      "mc-4": "4. Quality Education",
      "mc-5": "5. Gender Equality",
      "mc-6": "6. Clean Water & Sanitation",
      "mc-7": "7. Affordable & Clean Energy",
      "mc-8": "8. Decent Work & Economic Growth",
      "mc-9": "9. Industry, Innovation & Infrastructure",
      "mc-10": "10. Reduced Inequalities",
      "mc-11": "11. Sustainable Cities and Communities",
      "mc-12": "12. Responsible Consumption and Production",
      "mc-13": "13. Climate Action",
      "mc-14": "14. Life Below Water",
      "mc-15": "15. Life on Land",
      "mc-16": "16. Peace, Justice and Strong Institutions",
      "mc-17": "17. Partnerships for the Goals",
    };
    const target = $(this).attr("data-mc-goal");
    $("[data-mc-goal]").each(function () {
      $(this).removeClass("active");
    });
    $(this).addClass("active");
    $("[data-mc-header]").attr("data-mc-header", target);
    $("[data-mc-header] .mc-header-left").html(TITLES[target]);
    if (target === "mc-14" || target === "mc-17") {
      $('[data-sdg-mc="score"]').addClass("d-none");
      $('[data-sdg-mc="score-board"]').addClass("d-none");
      $('[data-sdg-mc="invalid-score-board"]').removeClass("d-none");
    } else {
      $('[data-sdg-mc="score"]').removeClass("d-none");
      $('[data-sdg-mc="score-board"]').removeClass("d-none");
      $('[data-sdg-mc="invalid-score-board"]').addClass("d-none");
    }
  });
});