<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\App;
use App\Models\ReportingYear;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Paginator::useBootstrap();
        Schema::defaultStringLength(101);
        $this->app['request']->server->set('HTTPS', true);


        // Check if the table exists before trying to fetch the default year
        if (Schema::hasTable('reporting_years')) {
            // Fetch the default year from the reporting_years table
            $defaultYear = ReportingYear::where('is_default', 'Yes')->first();

            // Bind the variable to the service container
            $this->app->singleton('defaultYear', function ($app) use ($defaultYear) {
                return $defaultYear;
            });
        }

        // Disable SSL certificate verification for cURL requests
        if (App::environment('local')) {
            $this->app['request']->server->set('HTTPS', false);
            $this->app['request']->server->set('HTTP_X_FORWARDED_PROTO', 'http');
            $this->app['request']->server->set('HTTP_X_FORWARDED_PORT', '80');
        }
    }
}
