<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Queue\Events\JobFailed;
use Throwable;

class JobFailedNotification extends Notification
{
    use Queueable;

    private $exception;

    // Accept a Throwable directly
    public function __construct(JobFailed $event)
    {
        // Check if the passed event contains the exception and use it
        $this->exception = $event->exception;  // This is the actual exception that caused the failure
    }

    public function via($notifiable)
    {
        return ['mail']; // Can be adjusted to include 'slack', 'sms', etc.
    }

    public function toMail($notifiable)
    {
        // Adjust the message content as needed
        return (new MailMessage)
            ->line('A job has failed.')
            // Since we don't have the job name directly, you might need to adjust this part
            ->line('Exception Message: ' . $this->exception->getMessage())
            ->action('View Dashboard', url('/'))
            ->line('Thank you for using our application!');
    }
}
