<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Spatie\Permission\Traits\HasRoles;
use Carbon\Carbon;

/**
 * @mixin \Spatie\Permission\Traits\HasRoles
 */
/**
 * @method bool hasRole(string $role)
 */
class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, HasRoles;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'email_address',
        'password',
        'department_id',
        'district_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'password' => 'hashed',
        'last_logged_in' => 'datetime', // Automatically cast to Carbon instance
    ];

    public function indicatorDataEntries()
    {
        return $this->hasMany(IndicatorDataEntry::class, 'reporter_id');
    }

    public function indicatorDataEntryApprovers()
    {
        return $this->hasMany(IndicatorDataEntry::class, 'approver_id');
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function department()
    {
        return $this->belongsTo(Department::class);
    }
}
