<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Target extends Model
{
    use HasFactory;

    public $timestamps = false; // Disable timestamps

    protected $primaryKey = 'target_id';

    protected $fillable = ['target_name', 'status', 'date_added', 'date_updated']; // Fillable fields

    public function indicators()
    {
        return $this->hasMany(Indicator::class);
    }

    public function indicatorDataEntries()
    {
        return $this->hasMany(IndicatorDataEntry::class);
    }

    public function goals()
    {
        return $this->belongsTo(Goal::class);
    }
}
