<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tag extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = ['tag', 'entity_type', 'goal_id', 'target_id', 'indicator_id', 'scheme_id', 'status', 'date_added', 'date_updated']; // Fillable fields

    public function goal()
    {
        return $this->belongsTo(Goal::class);
    }

    public function target()
    {
        return $this->belongsTo(Target::class);
    }

    public function indicator()
    {
        return $this->belongsTo(Indicator::class);
    }

    public function scheme()
    {
        return $this->belongsTo(Scheme::class);
    }
}
