<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SdgIndex extends Model
{
    use HasFactory;

    protected $fillable = [
        'goal_id', 'score', 'reporting_year_id', 'reporting_year',
        'date_added', 'date_updated'
    ]; // Fillable fields

    public function goal()
    {
        return $this->belongsTo(Goal::class);
    }

    public function reportingYear()
    {
        return $this->belongsTo(ReportingYear::class);
    }
}
