<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndicatorDataEntry extends Model
{
    use HasFactory;

    public $timestamps = false;

    protected $fillable = [
        'indicator_id',
        'indicator_number',
        'indicator_name',
        'target_id',
        'target_name',
        'goal_id',
        'goal_name',
        'reporter_id',
        'reporter_name',
        'reporting_year_id',
        'unit',
        'value_type',
        'target_value',
        'indicator_value',
        'baseline_year_id',
        'baseline_year',
        'reporting_year_id',
        'reporting_year',
        'department_id',
        'department_name',
        'district_id',
        'district_name',
        'status',
        'created_at',
    ]; // Fillable fields

    public function user()
    {
        return $this->belongsTo(User::class, 'reporter_id');
    }

    public function indicator()
    {
        return $this->belongsTo(Indicator::class);
    }

    public function target()
    {
        return $this->belongsTo(Target::class);
    }

    public function goal()
    {
        return $this->belongsTo(Goal::class);
    }

    public function district()
    {
        return $this->belongsTo(District::class);
    }

    public function reportingYear()
    {
        return $this->belongsTo(ReportingYear::class);
    }
}
