<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoalComparisionWithIndia extends Model
{
    use HasFactory;

    protected $table = 'goal_comparision_with_india';

    public $timestamps = false; // Disable timestamps

    protected $fillable = [
        'goal_id',
        'india_score',
        'best_performer_state',
        'best_performer_state_score',
        'best_performer_ut',
        'best_performer_ut_score',
        'jammu_and_kashmir_score',
        'jammu_and_kashmir_category',
        'reporting_year',
        'reporting_year_id'
    ];

    public function goal()
    {
        return $this->belongsTo(Goal::class, 'goal_id');
    }

    public function reportingYear()
    {
        return $this->belongsTo(ReportingYear::class, 'reporting_year_id');
    }
}
